/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.eviction.AbstractEvictionController;
import org.apache.geode.internal.cache.eviction.DisabledEvictionStatistics;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.eviction.InternalEvictionStatistics;
import org.apache.geode.internal.cache.eviction.LIFOList;
import org.apache.geode.internal.cache.eviction.LRUListWithAsyncSorting;
import org.apache.geode.internal.cache.eviction.LRUListWithSyncSorting;
import org.apache.geode.internal.lang.SystemPropertyHelper;

public class EvictionListBuilder {
    private final boolean EVICTION_SCAN_ASYNC = SystemPropertyHelper.getProductBooleanProperty("EvictionScanAsync");
    private EvictionAlgorithm algorithm;
    private Object region;
    private EvictionController controller;
    private InternalRegionArguments args;

    public EvictionListBuilder(EvictionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public EvictionListBuilder withRegion(Object region) {
        this.region = region;
        return this;
    }

    public EvictionListBuilder withEvictionController(EvictionController evictionController) {
        this.controller = evictionController;
        return this;
    }

    public EvictionListBuilder withArgs(InternalRegionArguments args) {
        this.args = args;
        return this;
    }

    public EvictionList create() {
        if (this.algorithm.isLIFO()) {
            return new LIFOList(this.getEvictionStats(), this.getBucketRegion());
        }
        if (this.EVICTION_SCAN_ASYNC) {
            return new LRUListWithAsyncSorting(this.getEvictionStats(), this.getBucketRegion());
        }
        return new LRUListWithSyncSorting(this.getEvictionStats(), this.getBucketRegion());
    }

    private InternalEvictionStatistics getEvictionStats() {
        InternalEvictionStatistics statistics = null;
        if (this.region != null) {
            if (this.region instanceof BucketRegion) {
                statistics = this.args != null && this.args.getPartitionedRegion() != null ? (InternalEvictionStatistics)this.args.getPartitionedRegion().getEvictionController().getStatistics() : new DisabledEvictionStatistics();
            } else if (this.region instanceof PlaceHolderDiskRegion) {
                statistics = (InternalEvictionStatistics)((PlaceHolderDiskRegion)this.region).getPRLRUStats();
            } else if (this.region instanceof PartitionedRegion && (statistics = (InternalEvictionStatistics)((PartitionedRegion)this.region).getPRLRUStatsDuringInitialization()) != null) {
                PartitionedRegion partitionedRegion = (PartitionedRegion)this.region;
                EvictionController evictionController = partitionedRegion.getEvictionController();
                ((AbstractEvictionController)evictionController).setStatistics(statistics);
            }
        }
        if (statistics == null) {
            DistributedSystem sf = GemFireCacheImpl.getExisting("").getDistributedSystem();
            statistics = (InternalEvictionStatistics)this.controller.initStats(this.region, sf);
        }
        return statistics;
    }

    private BucketRegion getBucketRegion() {
        return this.region instanceof BucketRegion ? (BucketRegion)this.region : null;
    }
}

