/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;
import org.apache.geode.internal.cache.eviction.EvictionStatisticsImpl;
import org.apache.geode.internal.cache.eviction.InternalEvictionStatistics;
import org.apache.geode.internal.i18n.LocalizedStrings;

abstract class AbstractEvictionController
implements EvictionController,
Serializable,
Cloneable {
    protected static final String EVICTION_ACTION = "eviction-action";
    private static final int DESTROYS_LIMIT = 1000;
    protected EvictionAction evictionAction;
    protected transient InternalEvictionStatistics stats;
    protected BucketRegion bucketRegion;
    private volatile transient String regionName;

    protected AbstractEvictionController(EvictionAction evictionAction, Region region) {
        this.bucketRegion = (BucketRegion)(region instanceof BucketRegion ? region : null);
        this.setEvictionAction(evictionAction);
    }

    public abstract String toString();

    @Override
    public void setBucketRegion(Region region) {
        if (region instanceof BucketRegion) {
            this.bucketRegion = (BucketRegion)region;
            this.bucketRegion.setLimit(this.getLimit());
        }
    }

    @Override
    public EvictionAction getEvictionAction() {
        return this.evictionAction;
    }

    @Override
    public synchronized EvictionStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void close() {
        if (this.stats != null) {
            if (this.bucketRegion != null) {
                this.stats.incEvictions(this.bucketRegion.getEvictions() * -1L);
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.close();
            } else {
                this.stats.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        AbstractEvictionController abstractEvictionController = this;
        synchronized (abstractEvictionController) {
            AbstractEvictionController clone = (AbstractEvictionController)super.clone();
            clone.stats = null;
            return clone;
        }
    }

    public boolean equals(Object cc) {
        if (cc == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(cc.getClass())) {
            return false;
        }
        AbstractEvictionController other = (AbstractEvictionController)cc;
        return other.evictionAction.equals(this.evictionAction);
    }

    public int hashCode() {
        return this.evictionAction.hashCode();
    }

    @Override
    public long limit() {
        if (this.stats == null) {
            throw new InternalGemFireException(LocalizedStrings.LRUAlgorithm_LRU_STATS_IN_EVICTION_CONTROLLER_INSTANCE_SHOULD_NOT_BE_NULL.toLocalizedString());
        }
        if (this.bucketRegion != null) {
            return this.bucketRegion.getLimit();
        }
        return this.stats.getLimit();
    }

    @Override
    public EvictionStatistics initStats(Object region, StatisticsFactory statsFactory) {
        this.setRegionName(region);
        EvictionStatisticsImpl stats = new EvictionStatisticsImpl(statsFactory, this.getRegionName(), this);
        stats.setLimit(this.getLimit());
        stats.setDestroysLimit(1000L);
        this.setStatistics(stats);
        return stats;
    }

    protected void setEvictionAction(EvictionAction evictionAction) {
        this.evictionAction = evictionAction;
    }

    protected String getRegionName() {
        return this.regionName;
    }

    protected void setRegionName(Object region) {
        String fullPathName;
        if (region instanceof Region) {
            fullPathName = ((Region)region).getFullPath();
        } else if (region instanceof PlaceHolderDiskRegion) {
            PlaceHolderDiskRegion placeHolderDiskRegion = (PlaceHolderDiskRegion)region;
            fullPathName = placeHolderDiskRegion.isBucket() ? placeHolderDiskRegion.getPrName() : placeHolderDiskRegion.getName();
        } else {
            throw new IllegalStateException("expected Region or PlaceHolderDiskRegion");
        }
        if (this.regionName != null && !this.regionName.equals(fullPathName)) {
            throw new IllegalArgumentException(LocalizedStrings.LRUAlgorithm_LRU_EVICTION_CONTROLLER_0_ALREADY_CONTROLS_THE_CAPACITY_OF_1_IT_CANNOT_ALSO_CONTROL_THE_CAPACITY_OF_REGION_2.toLocalizedString(this, this.regionName, fullPathName));
        }
        this.regionName = fullPathName;
    }

    protected void setStatistics(InternalEvictionStatistics stats) {
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        AbstractEvictionController abstractEvictionController = this;
        synchronized (abstractEvictionController) {
            out.writeObject(this.evictionAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AbstractEvictionController abstractEvictionController = this;
        synchronized (abstractEvictionController) {
            this.evictionAction = (EvictionAction)in.readObject();
        }
    }
}

