/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.CancelCriterion;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.event.BulkOperationHolder;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.event.EventTracker;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;

public class DistributedEventTracker
implements EventTracker {
    private static final Logger logger = LogService.getLogger();
    private final ConcurrentMap<ThreadIdentifier, EventSequenceNumberHolder> recordedEvents = new ConcurrentHashMap<ThreadIdentifier, EventSequenceNumberHolder>(100);
    private final ConcurrentMap<ThreadIdentifier, Object> recordedBulkOps = new ConcurrentHashMap<ThreadIdentifier, Object>(100);
    private final ConcurrentMap<ThreadIdentifier, BulkOperationHolder> recordedBulkOpVersionTags = new ConcurrentHashMap<ThreadIdentifier, BulkOperationHolder>(100);
    private volatile InternalDistributedMember initialImageProvider;
    private InternalCache cache;
    private String name;
    private volatile boolean initialized;
    private final StoppableCountDownLatch initializationLatch;

    public DistributedEventTracker(InternalCache cache, CancelCriterion stopper, String regionName) {
        this.cache = cache;
        this.name = "Event Tracker for " + regionName;
        this.initializationLatch = new StoppableCountDownLatch(stopper, 1);
    }

    @Override
    public void start() {
        if (this.cache.getEventTrackerTask() != null) {
            this.cache.getEventTrackerTask().addTracker(this);
        }
    }

    @Override
    public void stop() {
        if (this.cache.getEventTrackerTask() != null) {
            this.cache.getEventTrackerTask().removeTracker(this);
        }
    }

    @Override
    public Map<ThreadIdentifier, EventSequenceNumberHolder> getState() {
        HashMap<ThreadIdentifier, EventSequenceNumberHolder> result = new HashMap<ThreadIdentifier, EventSequenceNumberHolder>(this.recordedEvents.size());
        for (Map.Entry entry : this.recordedEvents.entrySet()) {
            EventSequenceNumberHolder holder = (EventSequenceNumberHolder)entry.getValue();
            result.put((ThreadIdentifier)entry.getKey(), new EventSequenceNumberHolder(holder.getLastSequenceNumber(), null));
        }
        return result;
    }

    @Override
    public void recordState(InternalDistributedMember provider, Map<ThreadIdentifier, EventSequenceNumberHolder> state) {
        this.initialImageProvider = provider;
        StringBuffer sb = null;
        if (logger.isDebugEnabled()) {
            sb = new StringBuffer(200);
            sb.append("Recording initial state for ").append(this.name).append(": ");
        }
        for (Map.Entry<ThreadIdentifier, EventSequenceNumberHolder> entry : state.entrySet()) {
            if (sb != null) {
                sb.append("\n  ").append(entry.getKey().expensiveToString()).append("; sequenceID=").append(entry.getValue());
            }
            this.recordSequenceNumber(entry.getKey(), entry.getValue(), true);
        }
        if (sb != null) {
            logger.debug((CharSequence)sb);
        }
        this.setInitialized();
    }

    @Override
    public void setInitialized() {
        this.initializationLatch.countDown();
        this.initialized = true;
    }

    @Override
    public void waitOnInitialization() throws InterruptedException {
        this.initializationLatch.await();
    }

    protected void recordSequenceNumber(ThreadIdentifier membershipID, EventSequenceNumberHolder evhObj) {
        this.recordSequenceNumber(membershipID, evhObj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSequenceNumber(ThreadIdentifier threadID, EventSequenceNumberHolder evh, boolean ifAbsent) {
        boolean removed;
        if (logger.isDebugEnabled()) {
            logger.debug("recording {} {}", (Object)threadID.expensiveToString(), (Object)evh.toString());
        }
        do {
            removed = false;
            EventSequenceNumberHolder oldEvh = this.recordedEvents.putIfAbsent(threadID, evh);
            if (oldEvh != null) {
                EventSequenceNumberHolder eventSequenceNumberHolder = oldEvh;
                synchronized (eventSequenceNumberHolder) {
                    if (oldEvh.isRemoved()) {
                        removed = true;
                    }
                    if (ifAbsent) {
                        break;
                    }
                    oldEvh.setEndOfLifeTimestamp(0L);
                    if (oldEvh.getLastSequenceNumber() < evh.getLastSequenceNumber()) {
                        oldEvh.setLastSequenceNumber(evh.getLastSequenceNumber());
                        oldEvh.setVersionTag(evh.getVersionTag());
                    }
                }
            } else {
                evh.setEndOfLifeTimestamp(0L);
            }
        } while (removed);
    }

    @Override
    public void recordEvent(InternalCacheEvent event) {
        EventID eventID = event.getEventId();
        if (this.ignoreEvent(event, eventID)) {
            return;
        }
        LocalRegion lr = (LocalRegion)event.getRegion();
        ThreadIdentifier membershipID = this.createThreadIDFromEvent(eventID);
        VersionTag tag = null;
        if (lr.getServerProxy() == null) {
            tag = event.getVersionTag();
            RegionVersionVector v = ((LocalRegion)event.getRegion()).getVersionVector();
            this.canonicalizeIDs(tag, v);
        }
        EventSequenceNumberHolder newEvh = new EventSequenceNumberHolder(eventID.getSequenceID(), tag);
        if (logger.isTraceEnabled()) {
            logger.trace("region event tracker recording {}", (Object)event);
        }
        this.recordSequenceNumber(membershipID, newEvh);
        if (lr.getConcurrencyChecksEnabled() && (event.getOperation().isPutAll() || event.getOperation().isRemoveAll()) && lr.getServerProxy() == null) {
            this.recordBulkOpEvent(event, membershipID);
        }
    }

    private ThreadIdentifier createThreadIDFromEvent(EventID eventID) {
        return new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordBulkOpEvent(InternalCacheEvent event, ThreadIdentifier threadID) {
        EventID eventID = event.getEventId();
        VersionTag tag = event.getVersionTag();
        if (tag == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("recording bulkOp event {} {} {} op={}", (Object)threadID.expensiveToString(), (Object)eventID, (Object)tag, (Object)event.getOperation());
        }
        RegionVersionVector versionVector = ((LocalRegion)event.getRegion()).getVersionVector();
        this.canonicalizeIDs(tag, versionVector);
        boolean retry = false;
        do {
            BulkOperationHolder old;
            BulkOperationHolder bulkOpTracker;
            if ((bulkOpTracker = (BulkOperationHolder)this.recordedBulkOpVersionTags.get(threadID)) == null && (old = this.recordedBulkOpVersionTags.putIfAbsent(threadID, bulkOpTracker = new BulkOperationHolder())) != null) {
                retry = true;
                continue;
            }
            BulkOperationHolder bulkOperationHolder = bulkOpTracker;
            synchronized (bulkOperationHolder) {
                if (bulkOpTracker.isRemoved()) {
                    retry = true;
                    continue;
                }
                bulkOpTracker.putVersionTag(eventID, event.getVersionTag());
                retry = false;
            }
        } while (retry);
    }

    private void canonicalizeIDs(VersionTag tag, RegionVersionVector versionVector) {
        if (tag != null && versionVector != null) {
            tag.setMemberID(versionVector.getCanonicalId(tag.getMemberID()));
            if (tag.getPreviousMemberID() != null) {
                tag.setPreviousMemberID(versionVector.getCanonicalId(tag.getPreviousMemberID()));
            }
        }
    }

    @Override
    public boolean hasSeenEvent(InternalCacheEvent event) {
        EventID eventID = event.getEventId();
        if (this.ignoreEvent(event, eventID)) {
            return false;
        }
        return this.hasSeenEvent(eventID, event);
    }

    @Override
    public boolean hasSeenEvent(EventID eventID) {
        return this.hasSeenEvent(eventID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSeenEvent(EventID eventID, InternalCacheEvent tagHolder) {
        if (eventID == null) {
            return false;
        }
        EventSequenceNumberHolder evh = this.getSequenceHolderForEvent(eventID);
        if (evh == null) {
            return false;
        }
        EventSequenceNumberHolder eventSequenceNumberHolder = evh;
        synchronized (eventSequenceNumberHolder) {
            if (evh.isRemoved() || evh.getLastSequenceNumber() < eventID.getSequenceID()) {
                return false;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER)) {
                logger.trace(LogMarker.DISTRIBUTION_BRIDGE_SERVER, "Cache encountered replay of event with ID {}.  Highest recorded for this source is {}", (Object)eventID, (Object)evh.getLastSequenceNumber());
            }
            if (evh.getLastSequenceNumber() == eventID.getSequenceID() && tagHolder != null && evh.getVersionTag() != null) {
                ((EntryEventImpl)tagHolder).setVersionTag(evh.getVersionTag());
            }
            return true;
        }
    }

    private EventSequenceNumberHolder getSequenceHolderForEvent(EventID eventID) {
        ThreadIdentifier membershipID = this.createThreadIDFromEvent(eventID);
        return (EventSequenceNumberHolder)this.recordedEvents.get(membershipID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionTag findVersionTagForSequence(EventID eventID) {
        EventSequenceNumberHolder evh = this.getSequenceHolderForEvent(eventID);
        if (evh == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag failed as no event is recorded for {}", (Object)this.createThreadIDFromEvent(eventID).expensiveToString());
            }
            return null;
        }
        EventSequenceNumberHolder eventSequenceNumberHolder = evh;
        synchronized (eventSequenceNumberHolder) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag located last event for {}: {}", (Object)this.createThreadIDFromEvent(eventID).expensiveToString(), (Object)evh);
            }
            if (evh.getLastSequenceNumber() != eventID.getSequenceID()) {
                return null;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER) && evh.getVersionTag() == null) {
                logger.trace(LogMarker.DISTRIBUTION_BRIDGE_SERVER, "Could not recover version tag.  Found event holder with no version tag for {}", (Object)eventID);
            }
            return evh.getVersionTag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionTag findVersionTagForBulkOp(EventID eventID) {
        if (eventID == null) {
            return null;
        }
        ThreadIdentifier threadID = this.createThreadIDFromEvent(eventID);
        BulkOperationHolder evh = (BulkOperationHolder)this.recordedBulkOpVersionTags.get(threadID);
        if (evh == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag failed as no events are recorded for {}", (Object)threadID.expensiveToString());
            }
            return null;
        }
        BulkOperationHolder bulkOperationHolder = evh;
        synchronized (bulkOperationHolder) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag located event holder for {}: {}", (Object)threadID.expensiveToString(), (Object)evh);
            }
            return evh.getEntryVersionTags().get(eventID);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean ignoreEvent(InternalCacheEvent event, EventID eventID) {
        if (eventID == null) {
            return true;
        }
        boolean isVersioned = event.getVersionTag() != null;
        boolean isClient = event.hasClientOrigin();
        if (isVersioned && isClient) {
            return false;
        }
        boolean isEntry = event.getOperation().isEntry();
        boolean isPr = event.getRegion().getAttributes().getDataPolicy().withPartitioning() || ((LocalRegion)event.getRegion()).isUsedForPartitionedRegionBucket();
        return !isClient && isEntry && !isPr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncBulkOp(Runnable r, EventID eventID, boolean partOfTransaction) {
        if (partOfTransaction) {
            r.run();
            return;
        }
        Assert.assertTrue(eventID != null);
        ThreadIdentifier membershipID = this.createThreadIDFromEvent(eventID);
        Object opSyncObj = null;
        do {
            if ((opSyncObj = this.recordedBulkOps.putIfAbsent(membershipID, new Object())) != null) continue;
            opSyncObj = this.recordedBulkOps.get(membershipID);
        } while (opSyncObj == null);
        Object object = opSyncObj;
        synchronized (object) {
            try {
                this.recordBulkOpStart(eventID, membershipID);
                r.run();
            }
            finally {
                this.recordedBulkOps.remove(membershipID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordBulkOpStart(EventID eventID, ThreadIdentifier tid) {
        EventSequenceNumberHolder evh;
        if (logger.isDebugEnabled()) {
            logger.debug("recording bulkOp start for {}", (Object)tid.expensiveToString());
        }
        if ((evh = (EventSequenceNumberHolder)this.recordedEvents.get(tid)) == null) {
            return;
        }
        EventSequenceNumberHolder eventSequenceNumberHolder = evh;
        synchronized (eventSequenceNumberHolder) {
            if (eventID.getSequenceID() > evh.getLastSequenceNumber()) {
                this.recordedBulkOpVersionTags.remove(tid);
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isInitialImageProvider(DistributedMember mbr) {
        return this.initialImageProvider != null && mbr != null && this.initialImageProvider.equals(mbr);
    }

    @Override
    public ConcurrentMap<ThreadIdentifier, BulkOperationHolder> getRecordedBulkOpVersionTags() {
        return this.recordedBulkOpVersionTags;
    }

    @Override
    public ConcurrentMap<ThreadIdentifier, EventSequenceNumberHolder> getRecordedEvents() {
        return this.recordedEvents;
    }

    public String toString() {
        return "" + this.name + "(initialized=" + this.initialized + ")";
    }
}

