/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryOffHeap;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsRegionEntryOffHeapIntKey
extends VMStatsRegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VMStatsRegionEntryOffHeapIntKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsRegionEntryOffHeapIntKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VMStatsRegionEntryOffHeapIntKey> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsRegionEntryOffHeapIntKey.class, "offHeapAddress");
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryOffHeapIntKey> HIT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryOffHeapIntKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryOffHeapIntKey> MISS_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryOffHeapIntKey.class, "missCount");
    private final int key;

    public VMStatsRegionEntryOffHeapIntKey(RegionEntryContext context, int key, Object value) {
        super(context, value);
        this.key = key;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public void updateStatsForGet(boolean isHit, long time) {
        this.setLastAccessed(time);
        if (isHit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    @Override
    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        HIT_COUNT_UPDATER.incrementAndGet(this);
    }

    private void incrementMissCount() {
        MISS_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        HIT_COUNT_UPDATER.set(this, 0);
        MISS_COUNT_UPDATER.set(this, 0);
    }

    @Override
    public void txDidDestroy(long timeStamp) {
        this.setLastModified(timeStamp);
        this.setLastAccessed(timeStamp);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof Integer) {
            return (Integer)key == this.key;
        }
        return false;
    }
}

