/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.FlushToDiskFactory;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class FlushToDiskOperation {
    private static final Logger logger = LogService.getLogger();
    private final DM dm;
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final FlushToDiskFactory flushToDiskFactory;

    FlushToDiskOperation(DM dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, FlushToDiskFactory flushToDiskFactory) {
        this.flushToDiskFactory = flushToDiskFactory;
        this.dm = dm;
        this.member = member;
        this.recipients = recipients;
        this.cache = cache;
    }

    void send() {
        ReplyProcessor21 replyProcessor = this.createReplyProcessor();
        this.dm.putOutgoing(this.createDistributionMessage(replyProcessor));
        this.processLocally();
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private ReplyProcessor21 createReplyProcessor() {
        return this.flushToDiskFactory.createReplyProcessor(this.dm, this.recipients);
    }

    private DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.flushToDiskFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId());
    }

    private void processLocally() {
        this.flushToDiskFactory.createFlushToDisk(this.cache).run();
    }
}

