/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class FinishBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();
    private final transient FinishBackupFactory finishBackupFactory;
    private File targetDir;
    private File baselineDir;
    private boolean abort;

    public FinishBackupRequest() {
        this.finishBackupFactory = new FinishBackupFactory();
    }

    FinishBackupRequest(InternalDistributedMember sender, Set<InternalDistributedMember> recipients, int processorId, File targetDir, File baselineDir, boolean abort, FinishBackupFactory finishBackupFactory) {
        this.setSender(sender);
        this.setRecipients(recipients);
        this.msgId = processorId;
        this.finishBackupFactory = finishBackupFactory;
        this.targetDir = targetDir;
        this.baselineDir = baselineDir;
        this.abort = abort;
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        HashSet<PersistentID> persistentIds;
        try {
            persistentIds = this.finishBackupFactory.createFinishBackup(dm.getCache(), this.targetDir, this.baselineDir, this.abort).run();
        }
        catch (IOException e) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
            return AdminFailureResponse.create(this.getSender(), e);
        }
        return this.finishBackupFactory.createBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2114;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.targetDir = DataSerializer.readFile(in);
        this.baselineDir = DataSerializer.readFile(in);
        this.abort = DataSerializer.readBoolean(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeFile(this.targetDir, out);
        DataSerializer.writeFile(this.baselineDir, out);
        DataSerializer.writeBoolean(this.abort, out);
    }
}

