/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupOperation;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class FinishBackupOperation
extends BackupOperation {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final File targetDir;
    private final File baselineDir;
    private final boolean abort;
    private final FinishBackupFactory finishBackupFactory;

    FinishBackupOperation(DM dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, File targetDir, File baselineDir, boolean abort, FinishBackupFactory FinishBackupFactory2) {
        super(dm);
        this.member = member;
        this.cache = cache;
        this.recipients = recipients;
        this.targetDir = targetDir;
        this.baselineDir = baselineDir;
        this.abort = abort;
        this.finishBackupFactory = FinishBackupFactory2;
    }

    @Override
    ReplyProcessor21 createReplyProcessor() {
        return this.finishBackupFactory.createReplyProcessor(this, this.getDistributionManager(), this.recipients);
    }

    @Override
    DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.finishBackupFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId(), this.targetDir, this.baselineDir, this.abort);
    }

    @Override
    void processLocally() {
        try {
            this.addToResults(this.member, this.finishBackupFactory.createFinishBackup(this.cache, this.targetDir, this.baselineDir, this.abort).run());
        }
        catch (IOException e) {
            logger.fatal("Failed to FinishBackup in " + this.member, (Throwable)e);
        }
    }
}

