/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.backup.BackupDefinition;
import org.apache.geode.internal.cache.backup.BackupDestination;
import org.apache.geode.internal.cache.backup.RestoreScript;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class FileSystemBackupDestination
implements BackupDestination {
    static final String INCOMPLETE_BACKUP_FILE = "INCOMPLETE_BACKUP_FILE";
    private final Path backupDir;

    FileSystemBackupDestination(Path backupDir) {
        this.backupDir = backupDir;
    }

    @Override
    public void backupFiles(BackupDefinition backupDefinition) throws IOException {
        Files.createDirectories(this.backupDir, new FileAttribute[0]);
        Files.createFile(this.backupDir.resolve(INCOMPLETE_BACKUP_FILE), new FileAttribute[0]);
        this.backupAllFilesets(backupDefinition);
        Files.delete(this.backupDir.resolve(INCOMPLETE_BACKUP_FILE));
    }

    private void backupAllFilesets(BackupDefinition backupDefinition) throws IOException {
        this.backupUserFiles(backupDefinition.getUserFiles());
        this.backupDeployedJars(backupDefinition.getDeployedJars());
        this.backupConfigFiles(backupDefinition.getConfigFiles());
        this.backupOplogs(backupDefinition.getOplogFilesByDiskStore());
        this.backupDiskInitFiles(backupDefinition.getDiskInitFiles());
        RestoreScript script = backupDefinition.getRestoreScript();
        if (script != null) {
            File scriptFile = script.generate(this.backupDir.toFile());
            this.backupRestoreScript(scriptFile.toPath());
        }
        this.writeReadMe();
    }

    private void writeReadMe() throws IOException {
        String text = LocalizedStrings.BackupManager_README.toLocalizedString();
        Files.write(this.backupDir.resolve("README_FILE.txt"), text.getBytes(), new OpenOption[0]);
    }

    private void backupRestoreScript(Path restoreScriptFile) throws IOException {
        Files.copy(restoreScriptFile, this.backupDir.resolve(restoreScriptFile.getFileName()), new CopyOption[0]);
    }

    private void backupDiskInitFiles(Map<DiskStore, Path> diskInitFiles) throws IOException {
        for (Map.Entry<DiskStore, Path> entry : diskInitFiles.entrySet()) {
            Path destinationDirectory = this.getOplogBackupDir(entry.getKey(), ((DiskStoreImpl)entry.getKey()).getInforFileDirIndex());
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
            Files.copy(entry.getValue(), destinationDirectory.resolve(entry.getValue().getFileName()), StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    private void backupUserFiles(Collection<Path> userFiles) throws IOException {
        Path userDirectory = this.backupDir.resolve("user");
        Files.createDirectories(userDirectory, new FileAttribute[0]);
        this.moveFilesOrDirectories(userFiles, userDirectory);
    }

    private void backupDeployedJars(Collection<Path> jarFiles) throws IOException {
        Path jarsDirectory = this.backupDir.resolve("user");
        Files.createDirectories(jarsDirectory, new FileAttribute[0]);
        this.moveFilesOrDirectories(jarFiles, jarsDirectory);
    }

    private void backupConfigFiles(Collection<Path> configFiles) throws IOException {
        Path configDirectory = this.backupDir.resolve("config");
        Files.createDirectories(configDirectory, new FileAttribute[0]);
        this.moveFilesOrDirectories(configFiles, configDirectory);
    }

    private void backupOplogs(Map<DiskStore, Collection<Path>> oplogFiles) throws IOException {
        for (Map.Entry<DiskStore, Collection<Path>> entry : oplogFiles.entrySet()) {
            for (Path path : entry.getValue()) {
                int index = ((DiskStoreImpl)entry.getKey()).getInforFileDirIndex();
                Path backupDir = this.createOplogBackupDir(entry.getKey(), index);
                this.backupOplog(backupDir, path);
            }
        }
    }

    private Path getOplogBackupDir(DiskStore diskStore, int index) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        name = name + "_" + ((DiskStoreImpl)diskStore).getDiskStoreID().toString();
        return this.backupDir.resolve("diskstores").resolve(name).resolve("dir" + index);
    }

    private Path createOplogBackupDir(DiskStore diskStore, int index) throws IOException {
        Path oplogBackupDir = this.getOplogBackupDir(diskStore, index);
        Files.createDirectories(oplogBackupDir, new FileAttribute[0]);
        return oplogBackupDir;
    }

    private void backupOplog(Path targetDir, Path path) throws IOException {
        this.backupFile(targetDir, path.toFile());
    }

    private void backupFile(Path targetDir, File file) throws IOException {
        Files.move(file.toPath(), targetDir.resolve(file.getName()), new CopyOption[0]);
    }

    private void moveFilesOrDirectories(Collection<Path> paths, Path targetDirectory) throws IOException {
        for (Path userFile : paths) {
            Path destination = targetDirectory.resolve(userFile.getFileName());
            if (Files.isDirectory(userFile, new LinkOption[0])) {
                FileUtils.moveDirectory((File)userFile.toFile(), (File)destination.toFile());
                continue;
            }
            Files.move(userFile, destination, new CopyOption[0]);
        }
    }
}

