/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.cache.backup.BackupDataStoreHelper;
import org.apache.geode.internal.cache.backup.BackupDataStoreResult;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.BackupStatus;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.BackupStatusImpl;

public class BackupUtil {
    private BackupUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupStatus backupAllMembers(DM dm, File targetDir, File baselineDir) throws ManagementException {
        BackupStatusImpl status = null;
        if (BackupDataStoreHelper.obtainLock(dm)) {
            try {
                Set<PersistentID> missingMembers = AdminDistributedSystemImpl.getMissingPersistentMembers(dm);
                Set recipients = dm.getOtherDistributionManagerIds();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                targetDir = new File(targetDir, format.format(new Date()));
                BackupDataStoreResult result = BackupDataStoreHelper.backupAllMembers(dm, recipients, targetDir, baselineDir);
                for (Set<PersistentID> onlineMembersIds : result.getSuccessfulMembers().values()) {
                    missingMembers.removeAll(onlineMembersIds);
                }
                result.getExistingDataStores().keySet().removeAll(result.getSuccessfulMembers().keySet());
                for (Set<PersistentID> lostMembersIds : result.getExistingDataStores().values()) {
                    missingMembers.addAll(lostMembersIds);
                }
                status = new BackupStatusImpl(result.getSuccessfulMembers(), missingMembers);
            }
            finally {
                BackupDataStoreHelper.releaseLock(dm);
            }
        } else {
            throw new ManagementException(LocalizedStrings.DistributedSystem_BACKUP_ALREADY_IN_PROGRESS.toLocalizedString());
        }
        return status;
    }
}

