/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Set;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.cache.backup.BackupResponse;
import org.apache.geode.internal.cache.backup.BackupResultCollector;

class BackupReplyProcessor
extends AdminMultipleReplyProcessor {
    private final BackupResultCollector resultCollector;

    BackupReplyProcessor(BackupResultCollector resultCollector, DM dm, Set<InternalDistributedMember> recipients) {
        super(dm, recipients);
        this.resultCollector = resultCollector;
    }

    @Override
    protected boolean stopBecauseOfExceptions() {
        return false;
    }

    @Override
    protected int getAckWaitThreshold() {
        return 0;
    }

    @Override
    public long getAckSevereAlertThresholdMS() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void process(DistributionMessage message, boolean warn) {
        if (message instanceof BackupResponse) {
            BackupResponse response = (BackupResponse)message;
            this.resultCollector.addToResults(response.getSender(), response.getPersistentIds());
        }
        super.process(message, warn);
    }
}

