/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.backup.BackupResultCollector;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

abstract class BackupOperation
implements BackupResultCollector {
    private static final Logger logger = LogService.getLogger();
    private final DM dm;
    private final Map<DistributedMember, Set<PersistentID>> results = Collections.synchronizedMap(new HashMap());

    protected BackupOperation(DM dm) {
        this.dm = dm;
    }

    abstract ReplyProcessor21 createReplyProcessor();

    abstract DistributionMessage createDistributionMessage(ReplyProcessor21 var1);

    abstract void processLocally();

    Map<DistributedMember, Set<PersistentID>> send() {
        ReplyProcessor21 replyProcessor = this.createReplyProcessor();
        this.dm.putOutgoing(this.createDistributionMessage(replyProcessor));
        this.processLocally();
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return this.getResults();
    }

    @Override
    public void addToResults(InternalDistributedMember member, Set<PersistentID> persistentIds) {
        if (persistentIds != null && !persistentIds.isEmpty()) {
            this.results.put(member, persistentIds);
        }
    }

    Map<DistributedMember, Set<PersistentID>> getResults() {
        return this.results;
    }

    protected DM getDistributionManager() {
        return this.dm;
    }
}

