/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskStoreBackup;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.backup.BackupDefinition;
import org.apache.geode.internal.cache.backup.BackupInspector;
import org.apache.geode.internal.cache.backup.FileSystemBackupDestination;
import org.apache.geode.internal.cache.backup.RestoreScript;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class BackupManager {
    private static final Logger logger = LogService.getLogger();
    static final String INCOMPLETE_BACKUP_FILE = "INCOMPLETE_BACKUP_FILE";
    private static final String BACKUP_DIR_PREFIX = "dir";
    private static final String DATA_STORES_DIRECTORY = "diskstores";
    public static final String DATA_STORES_TEMPORARY_DIRECTORY = "backupTemp_";
    private static final String USER_FILES = "user";
    private static final String CONFIG_DIRECTORY = "config";
    private final MembershipListener membershipListener = new BackupMembershipListener();
    private final Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
    private final RestoreScript restoreScript = new RestoreScript();
    private final InternalDistributedMember sender;
    private final InternalCache cache;
    private final CountDownLatch allowDestroys = new CountDownLatch(1);
    private final BackupDefinition backupDefinition = new BackupDefinition();
    private final String diskStoreDirectoryName;
    private volatile boolean isCancelled = false;
    private Path tempDirectory;
    private final Map<DiskStore, Map<DirectoryHolder, Path>> diskStoreDirTempDirsByDiskStore = new HashMap<DiskStore, Map<DirectoryHolder, Path>>();

    public BackupManager(InternalDistributedMember sender, InternalCache gemFireCache) {
        this.sender = sender;
        this.cache = gemFireCache;
        this.diskStoreDirectoryName = DATA_STORES_TEMPORARY_DIRECTORY + System.currentTimeMillis();
    }

    public void validateRequestingAdmin() {
        Set allIds = this.getDistributionManager().addAllMembershipListenerAndGetAllIds(this.membershipListener);
        if (!allIds.contains(this.sender)) {
            this.cleanup();
            throw new IllegalStateException("The admin member requesting a backup has already departed");
        }
    }

    public HashSet<PersistentID> prepareForBackup() {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            DiskStoreImpl storeImpl = (DiskStoreImpl)store;
            storeImpl.lockStoreBeforeBackup();
            if (!storeImpl.hasPersistedData()) continue;
            persistentIds.add(storeImpl.getPersistentID());
            storeImpl.getStats().startBackup();
        }
        return persistentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentID> doBackup(File targetDir, File baselineDir, boolean abort) throws IOException {
        try {
            if (abort) {
                HashSet<PersistentID> hashSet = new HashSet<PersistentID>();
                return hashSet;
            }
            this.tempDirectory = Files.createTempDirectory("backup_" + System.currentTimeMillis(), new FileAttribute[0]);
            File backupDir = this.getBackupDir(targetDir);
            BackupInspector inspector = (baselineDir = this.checkBaseline(baselineDir)) == null ? null : BackupInspector.createInspector(baselineDir);
            File storesDir = new File(backupDir, DATA_STORES_DIRECTORY);
            Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
            Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStores = this.startDiskStoreBackups(inspector, storesDir, diskStores);
            this.allowDestroys.countDown();
            HashSet<PersistentID> persistentIds = this.finishDiskStoreBackups(backupByDiskStores);
            if (!backupByDiskStores.isEmpty()) {
                this.backupAdditionalFiles(backupDir);
                this.backupDefinition.setRestoreScript(this.restoreScript);
            }
            if (!backupByDiskStores.isEmpty()) {
                FileSystemBackupDestination backupDestination = new FileSystemBackupDestination(backupDir.toPath());
                backupDestination.backupFiles(this.backupDefinition);
            }
            HashSet<PersistentID> hashSet = persistentIds;
            return hashSet;
        }
        finally {
            this.cleanup();
        }
    }

    private HashSet<PersistentID> finishDiskStoreBackups(Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStores) throws IOException {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        for (Map.Entry<DiskStoreImpl, DiskStoreBackup> entry : backupByDiskStores.entrySet()) {
            DiskStoreImpl diskStore = entry.getKey();
            this.completeBackup(diskStore, entry.getValue());
            diskStore.getStats().endBackup();
            persistentIds.add(diskStore.getPersistentID());
        }
        return persistentIds;
    }

    private Map<DiskStoreImpl, DiskStoreBackup> startDiskStoreBackups(BackupInspector inspector, File storesDir, Collection<DiskStore> diskStores) throws IOException {
        HashMap<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
        for (DiskStore store : diskStores) {
            DiskStoreImpl diskStore = (DiskStoreImpl)store;
            if (diskStore.hasPersistedData()) {
                File diskStoreDir = new File(storesDir, this.getBackupDirName(diskStore));
                DiskStoreBackup backup = this.startDiskStoreBackup(diskStore, diskStoreDir, inspector);
                backupByDiskStore.put(diskStore, backup);
            }
            diskStore.releaseBackupLock();
        }
        return backupByDiskStore;
    }

    public void abort() {
        this.cleanup();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void waitForBackup() {
        try {
            this.allowDestroys.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError(e);
        }
    }

    private DM getDistributionManager() {
        return this.cache.getInternalDistributedSystem().getDistributionManager();
    }

    private void cleanup() {
        this.isCancelled = true;
        this.allowDestroys.countDown();
        this.cleanupTemporaryFiles();
        this.releaseBackupLocks();
        this.getDistributionManager().removeAllMembershipListener(this.membershipListener);
        this.cache.clearBackupManager();
    }

    private void cleanupTemporaryFiles() {
        if (this.tempDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)this.tempDirectory.toFile());
            }
            catch (IOException e) {
                logger.warn("Unable to delete temporary directory created during backup, " + this.tempDirectory, (Throwable)e);
            }
        }
        for (Map<DirectoryHolder, Path> diskStoreDirToTempDirMap : this.diskStoreDirTempDirsByDiskStore.values()) {
            for (Path tempDir : diskStoreDirToTempDirMap.values()) {
                try {
                    FileUtils.deleteDirectory((File)tempDir.toFile());
                }
                catch (IOException e) {
                    logger.warn("Unable to delete temporary directory created during backup, " + tempDir, (Throwable)e);
                }
            }
        }
    }

    private void releaseBackupLocks() {
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            ((DiskStoreImpl)store).releaseBackupLock();
        }
    }

    private File findBaselineForThisMember(File baselineParentDir) {
        File baselineDir = null;
        for (DiskStore diskStore : this.cache.listDiskStoresIncludingRegionOwned()) {
            File[] matchingFiles = baselineParentDir.listFiles((file, name) -> name.endsWith(this.getBackupDirName((DiskStoreImpl)diskStore)));
            if (null == matchingFiles || matchingFiles.length <= 0) continue;
            baselineDir = matchingFiles[0].getParentFile().getParentFile();
        }
        return baselineDir;
    }

    private File checkBaseline(File baselineParentDir) throws IOException {
        File baselineDir = null;
        if (null != baselineParentDir) {
            File incompleteBackup;
            baselineDir = this.getBackupDir(baselineParentDir);
            if (!baselineDir.exists()) {
                baselineDir = this.findBaselineForThisMember(baselineParentDir);
            }
            if (null != baselineDir && (incompleteBackup = new File(baselineDir, INCOMPLETE_BACKUP_FILE)).exists()) {
                baselineDir = null;
            }
        }
        return baselineDir;
    }

    private void backupAdditionalFiles(File backupDir) throws IOException {
        this.backupConfigFiles();
        this.backupUserFiles(backupDir);
        this.backupDeployedJars(backupDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeBackup(DiskStoreImpl diskStore, DiskStoreBackup backup) throws IOException {
        if (backup == null) {
            return;
        }
        try {
            diskStore.waitForDelayedWrites();
            for (Oplog oplog : backup.getPendingBackup()) {
                if (this.isCancelled()) {
                    break;
                }
                this.copyOplog(diskStore, this.tempDirectory.toFile(), oplog);
                backup.backupFinished(oplog);
            }
        }
        finally {
            backup.cleanup();
        }
    }

    private String getBackupDirName(DiskStoreImpl diskStore) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return name + "_" + diskStore.getDiskStoreID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DiskStoreBackup startDiskStoreBackup(DiskStoreImpl diskStore, File targetDir, BackupInspector baselineInspector) throws IOException {
        diskStore.getBackupLock().setBackupThread();
        DiskStoreBackup backup = null;
        boolean done = false;
        try {
            block10: {
                while (true) {
                    Object childLock;
                    Oplog childOplog;
                    if ((childOplog = diskStore.getPersistentOplogSet().getChild()) == null) {
                        backup = new DiskStoreBackup(new Oplog[0], targetDir);
                        this.backupByDiskStore.put(diskStore, backup);
                        break block10;
                    }
                    Object object = childLock = childOplog.getLock();
                    synchronized (object) {
                        if (diskStore.getPersistentOplogSet().getChild() == childOplog) break;
                    }
                }
                {
                    if (logger.isDebugEnabled()) {
                        logger.debug("snapshotting oplogs for disk store {}", (Object)diskStore.getName());
                    }
                    this.addDiskStoreDirectoriesToRestoreScript(diskStore, targetDir);
                    this.restoreScript.addExistenceTest(diskStore.getDiskInitFile().getIFFile());
                    Oplog[] allOplogs = null != baselineInspector ? this.filterBaselineOplogs(diskStore, baselineInspector) : diskStore.getAllOplogsForBackup();
                    backup = new DiskStoreBackup(allOplogs, targetDir);
                    this.backupByDiskStore.put(diskStore, backup);
                    this.backupDiskInitFile(diskStore, this.tempDirectory);
                    diskStore.getPersistentOplogSet().forceRoll(null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("done backing up disk store {}", (Object)diskStore.getName());
                    }
                }
            }
            done = true;
            return backup;
        }
        finally {
            if (!done && backup != null) {
                this.backupByDiskStore.remove(diskStore);
                backup.cleanup();
            }
        }
    }

    private void backupDiskInitFile(DiskStoreImpl diskStore, Path tempDir) throws IOException {
        File diskInitFile = diskStore.getDiskInitFile().getIFFile();
        String subDir = Integer.toString(diskStore.getInforFileDirIndex());
        Files.createDirectories(tempDir.resolve(subDir), new FileAttribute[0]);
        Files.copy(diskInitFile.toPath(), tempDir.resolve(subDir).resolve(diskInitFile.getName()), StandardCopyOption.COPY_ATTRIBUTES);
        this.backupDefinition.addDiskInitFile(diskStore, tempDir.resolve(subDir).resolve(diskInitFile.getName()));
    }

    private void addDiskStoreDirectoriesToRestoreScript(DiskStoreImpl diskStore, File targetDir) {
        DirectoryHolder[] directories = diskStore.getDirectoryHolders();
        for (int i = 0; i < directories.length; ++i) {
            File backupDir = this.getBackupDir(targetDir, i);
            this.restoreScript.addFile(directories[i].getDir(), backupDir);
        }
    }

    private Oplog[] filterBaselineOplogs(DiskStoreImpl diskStore, BackupInspector baselineInspector) {
        Oplog[] allOplogs;
        File baselineDir = new File(baselineInspector.getBackupDir(), DATA_STORES_DIRECTORY);
        baselineDir = new File(baselineDir, this.getBackupDirName(diskStore));
        Collection baselineOplogFiles = FileUtils.listFiles((File)baselineDir, (String[])new String[]{"krf", "drf", "crf"}, (boolean)true);
        LinkedList<Oplog> oplogList = new LinkedList<Oplog>();
        for (Oplog log : allOplogs = diskStore.getAllOplogsForBackup()) {
            Map<File, File> oplogMap = log.mapBaseline(baselineOplogFiles);
            if (oplogMap.isEmpty() && baselineInspector.isIncremental()) {
                oplogMap = this.addBaselineOplogToRestoreScript(baselineInspector, log);
            }
            if (oplogMap.isEmpty()) {
                oplogList.add(log);
                continue;
            }
            this.restoreScript.addBaselineFiles(oplogMap);
        }
        return oplogList.toArray(new Oplog[oplogList.size()]);
    }

    private Map<File, File> addBaselineOplogToRestoreScript(BackupInspector baselineInspector, Oplog log) {
        HashMap<File, File> oplogMap = new HashMap<File, File>();
        Set<String> matchingOplogs = log.gatherMatchingOplogFiles(baselineInspector.getIncrementalOplogFileNames());
        for (String matchingOplog : matchingOplogs) {
            oplogMap.put(new File(baselineInspector.getCopyFromForOplogFile(matchingOplog)), new File(baselineInspector.getCopyToForOplogFile(matchingOplog)));
        }
        return oplogMap;
    }

    private File getBackupDir(File targetDir, int index) {
        return new File(targetDir, BACKUP_DIR_PREFIX + index);
    }

    private void backupConfigFiles() throws IOException {
        Files.createDirectories(this.tempDirectory.resolve(CONFIG_DIRECTORY), new FileAttribute[0]);
        this.addConfigFileToBackup(this.cache.getCacheXmlURL());
        this.addConfigFileToBackup(DistributedSystem.getPropertiesFileURL());
    }

    private void addConfigFileToBackup(URL fileUrl) throws IOException {
        if (fileUrl != null) {
            try {
                Path source = Paths.get(fileUrl.toURI());
                Path destination = this.tempDirectory.resolve(CONFIG_DIRECTORY).resolve(source.getFileName());
                Files.copy(source, destination, StandardCopyOption.COPY_ATTRIBUTES);
                this.backupDefinition.addConfigFileToBackup(destination);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    private void backupUserFiles(File backupDir) throws IOException {
        Files.createDirectories(this.tempDirectory.resolve(USER_FILES), new FileAttribute[0]);
        List<File> backupFiles = this.cache.getBackupFiles();
        File userBackupDir = new File(backupDir, USER_FILES);
        for (File original : backupFiles) {
            if (!original.exists()) continue;
            original = original.getAbsoluteFile();
            Path destination = this.tempDirectory.resolve(USER_FILES).resolve(original.getName());
            if (original.isDirectory()) {
                FileUtils.copyDirectory((File)original, (File)destination.toFile());
            } else {
                Files.copy(original.toPath(), destination, StandardCopyOption.COPY_ATTRIBUTES);
            }
            this.backupDefinition.addUserFilesToBackup(destination);
            File restoreScriptDestination = new File(userBackupDir, original.getName());
            this.restoreScript.addUserFile(original, restoreScriptDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupDeployedJars(File backupDir) throws IOException {
        JarDeployer deployer = null;
        try {
            deployer = ClassPathLoader.getLatest().getJarDeployer();
            deployer.suspendAll();
            List<DeployedJar> jarList = deployer.findDeployedJars();
            if (!jarList.isEmpty()) {
                File userBackupDir = new File(backupDir, USER_FILES);
                for (DeployedJar jar : jarList) {
                    File source = new File(jar.getFileCanonicalPath());
                    String sourceFileName = source.getName();
                    Path destination = this.tempDirectory.resolve(USER_FILES).resolve(sourceFileName);
                    Files.copy(source.toPath(), destination, StandardCopyOption.COPY_ATTRIBUTES);
                    this.backupDefinition.addDeployedJarToBackup(destination);
                    File restoreScriptDestination = new File(userBackupDir, sourceFileName);
                    this.restoreScript.addFile(source, restoreScriptDestination);
                }
            }
        }
        finally {
            if (deployer != null) {
                deployer.resumeAll();
            }
        }
    }

    private File getBackupDir(File targetDir) {
        InternalDistributedMember memberId = this.cache.getInternalDistributedSystem().getDistributedMember();
        String vmId = memberId.toString();
        vmId = this.cleanSpecialCharacters(vmId);
        return new File(targetDir, vmId);
    }

    private void copyOplog(DiskStore diskStore, File targetDir, Oplog oplog) throws IOException {
        DirectoryHolder dirHolder = oplog.getDirectoryHolder();
        this.backupFile(diskStore, dirHolder, targetDir, oplog.getCrfFile());
        this.backupFile(diskStore, dirHolder, targetDir, oplog.getDrfFile());
        oplog.finishKrf();
        this.backupFile(diskStore, dirHolder, targetDir, oplog.getKrfFile());
    }

    private void backupFile(DiskStore diskStore, DirectoryHolder dirHolder, File targetDir, File file) throws IOException {
        if (file != null && file.exists()) {
            try {
                Path tempDiskDir = this.getTempDirForDiskStore(diskStore, dirHolder);
                Files.createLink(tempDiskDir.resolve(file.getName()), file.toPath());
                this.backupDefinition.addOplogFileToBackup(diskStore, tempDiskDir.resolve(file.getName()));
            }
            catch (IOException | UnsupportedOperationException e) {
                logger.warn("Unable to create hard link for + {}. Reverting to file copy", (Object)targetDir);
                FileUtils.copyFileToDirectory((File)file, (File)targetDir);
            }
        }
    }

    private Path getTempDirForDiskStore(DiskStore diskStore, DirectoryHolder dirHolder) throws IOException {
        Path directory;
        Map<DirectoryHolder, Path> tempDirByDirectoryHolder = this.diskStoreDirTempDirsByDiskStore.get(diskStore);
        if (tempDirByDirectoryHolder == null) {
            tempDirByDirectoryHolder = new HashMap<DirectoryHolder, Path>();
            this.diskStoreDirTempDirsByDiskStore.put(diskStore, tempDirByDirectoryHolder);
        }
        if ((directory = tempDirByDirectoryHolder.get(dirHolder)) != null) {
            return directory;
        }
        File diskStoreDir = dirHolder.getDir();
        directory = diskStoreDir.toPath().resolve(this.diskStoreDirectoryName);
        Files.createDirectories(directory, new FileAttribute[0]);
        tempDirByDirectoryHolder.put(dirHolder, directory);
        return directory;
    }

    private String cleanSpecialCharacters(String string) {
        return string.replaceAll("[^\\w]+", "_");
    }

    public DiskStoreBackup getBackupForDiskStore(DiskStoreImpl diskStore) {
        return this.backupByDiskStore.get(diskStore);
    }

    private class BackupMembershipListener
    implements MembershipListener {
        private BackupMembershipListener() {
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            BackupManager.this.cleanup();
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }
    }
}

