/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BackupLock
extends ReentrantLock {
    private final ThreadLocal<Boolean> isBackupThread = new ThreadLocal();
    private boolean isBackingUp;
    private Condition backupDone = super.newCondition();
    private final AtomicReference<BackupLockTestHook> hook = new AtomicReference();

    public void setBackupLockTestHook(BackupLockTestHook testHook) {
        this.hook.set(testHook);
    }

    public void lockForBackup() {
        super.lock();
        this.isBackingUp = true;
        super.unlock();
    }

    void setBackupThread() {
        this.isBackupThread.set(true);
    }

    public void unlockForBackup() {
        super.lock();
        this.isBackingUp = false;
        this.isBackupThread.remove();
        this.backupDone.signalAll();
        super.unlock();
    }

    boolean isCurrentThreadDoingBackup() {
        Boolean result = this.isBackupThread.get();
        return result != null && result != false;
    }

    boolean isBackingUp() {
        return this.isBackingUp;
    }

    boolean hasThreadLocal() {
        return this.isBackupThread.get() != null;
    }

    @Override
    public void unlock() {
        if (!this.isCurrentThreadDoingBackup()) {
            super.unlock();
        }
    }

    @Override
    public void lock() {
        if (!this.isCurrentThreadDoingBackup()) {
            super.lock();
            while (this.isBackingUp) {
                BackupLockTestHook testHook = this.hook.get();
                if (testHook != null) {
                    testHook.beforeWaitForBackupCompletion();
                }
                this.backupDone.awaitUninterruptibly();
            }
        }
    }

    public static interface BackupLockTestHook {
        public void beforeWaitForBackupCompletion();
    }
}

