/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.backup.RestoreScript;

class BackupDefinition {
    private final Map<DiskStore, Set<Path>> oplogFilesByDiskStore = new HashMap<DiskStore, Set<Path>>();
    private final Set<Path> configFiles = new HashSet<Path>();
    private final Set<Path> userFiles = new HashSet<Path>();
    private final Set<Path> deployedJars = new HashSet<Path>();
    private final Map<DiskStore, Path> diskInitFiles = new HashMap<DiskStore, Path>();
    private RestoreScript restoreScript;

    BackupDefinition() {
    }

    void addConfigFileToBackup(Path configFile) {
        this.configFiles.add(configFile);
    }

    void addUserFilesToBackup(Path userFile) {
        this.userFiles.add(userFile);
    }

    void addDeployedJarToBackup(Path deployedJar) {
        this.deployedJars.add(deployedJar);
    }

    void addDiskInitFile(DiskStore diskStore, Path diskInitFile) {
        this.diskInitFiles.put(diskStore, diskInitFile);
    }

    void setRestoreScript(RestoreScript restoreScript) {
        this.restoreScript = restoreScript;
    }

    Map<DiskStore, Collection<Path>> getOplogFilesByDiskStore() {
        return Collections.unmodifiableMap(this.oplogFilesByDiskStore);
    }

    Set<Path> getConfigFiles() {
        return Collections.unmodifiableSet(this.configFiles);
    }

    Set<Path> getUserFiles() {
        return Collections.unmodifiableSet(this.userFiles);
    }

    Set<Path> getDeployedJars() {
        return Collections.unmodifiableSet(this.deployedJars);
    }

    Map<DiskStore, Path> getDiskInitFiles() {
        return Collections.unmodifiableMap(this.diskInitFiles);
    }

    RestoreScript getRestoreScript() {
        return this.restoreScript;
    }

    void addOplogFileToBackup(DiskStore diskStore, Path fileLocation) {
        Set files = this.oplogFilesByDiskStore.computeIfAbsent(diskStore, k -> new HashSet());
        files.add(fileLocation);
    }
}

