/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.Serializable;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.AbstractLRURegionMap;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;

public class RegionStatus
implements Serializable {
    private static final long serialVersionUID = 3442040750396350302L;
    protected int numberOfEntries;
    protected long heapSize;

    public RegionStatus() {
    }

    public RegionStatus(Region region) {
        this.initialize(region);
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    protected void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    private void setHeapSize(long heapSize) {
        this.heapSize = heapSize;
    }

    private void initialize(Region region) {
        this.setNumberOfEntries(region.size());
        EvictionAttributes ea = region.getAttributes().getEvictionAttributes();
        if (ea != null && ea.getAlgorithm().isLRUMemory()) {
            LocalRegion lr = (LocalRegion)region;
            EvictionStatistics stats = ((AbstractLRURegionMap)lr.getRegionMap()).getEvictionController().getStatistics();
            this.setHeapSize(stats.getCounter());
        } else {
            this.setHeapSize(-1L);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RegionStatus[").append("numberOfEntries=").append(this.numberOfEntries).append("; heapSize=").append(this.heapSize).append("]");
        return buffer.toString();
    }
}

