/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.LocalRegion;

abstract class RegionExpiryTask
extends ExpiryTask {
    private boolean isCanceled = false;

    protected RegionExpiryTask(LocalRegion reg) {
        super(reg);
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    protected ExpirationAttributes getIdleAttributes() {
        return this.getLocalRegion().getRegionIdleTimeout();
    }

    @Override
    protected ExpirationAttributes getTTLAttributes() {
        return this.getLocalRegion().getRegionTimeToLive();
    }

    @Override
    protected long getLastAccessedTime() {
        return this.getLocalRegion().getLastAccessedTime();
    }

    @Override
    protected long getLastModifiedTime() {
        return this.getLocalRegion().getLastModifiedTime();
    }

    @Override
    protected boolean destroy(boolean isPending) throws CacheException {
        return this.getLocalRegion().expireRegion(this, true, true);
    }

    @Override
    protected boolean invalidate() throws TimeoutException {
        return this.getLocalRegion().expireRegion(this, true, false);
    }

    @Override
    protected boolean localDestroy() throws CacheException {
        return this.getLocalRegion().expireRegion(this, false, true);
    }

    @Override
    protected boolean localInvalidate() {
        return this.getLocalRegion().expireRegion(this, false, false);
    }

    @Override
    public boolean cancel() {
        this.isCanceled = true;
        return super.cancel();
    }

    @Override
    protected void performTimeout() throws CacheException {
        if (this.isCanceled) {
            return;
        }
        super.performTimeout();
    }

    @Override
    protected void basicPerformTimeout(boolean isPending) throws CacheException {
        if (this.isCanceled) {
            return;
        }
        if (!this.isExpirationAllowed()) {
            return;
        }
        if (this.isExpirationPossible()) {
            if (this.expire(isPending)) {
                this.reschedule();
            }
        } else {
            this.reschedule();
        }
    }

    @Override
    protected void reschedule() throws CacheException {
        if (this.isCacheClosing() || this.getLocalRegion().isClosed() || this.getLocalRegion().isDestroyed() || !this.isExpirationAllowed()) {
            return;
        }
        this.addExpiryTask();
        if (expiryTaskListener != null) {
            expiryTaskListener.afterReschedule(this);
        }
    }

    @Override
    public String toString() {
        String expireTime = "<unavailable>";
        try {
            expireTime = String.valueOf(this.getExpirationTime());
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
        }
        return super.toString() + " for " + this.getLocalRegion().getFullPath() + ", expiration time: " + expireTime + " [now: " + this.calculateNow() + "]";
    }
}

