/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.geode.CopyHelper;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.CompiledGroupBySelect;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CumulativeNonDistinctResults;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.NWayMergeResults;
import org.apache.geode.cache.query.internal.OrderByComparator;
import org.apache.geode.cache.query.internal.PRQueryTraceInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.SortedStructBag;
import org.apache.geode.cache.query.internal.StructSet;
import org.apache.geode.cache.query.internal.utils.PDXUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.streaming.StreamingOperation;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PRQueryProcessor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.QueryMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.partitioned.StreamingPartitionOperation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionQueryEvaluator
extends StreamingPartitionOperation {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_PR_QUERY_RETRIES = Integer.getInteger("gemfire.MAX_PR_QUERY_RETRIES", 10);
    private final PartitionedRegion pr;
    private volatile Map<InternalDistributedMember, List<Integer>> node2bucketIds;
    private final DefaultQuery query;
    private final Object[] parameters;
    private SelectResults cumulativeResults;
    private final ConcurrentMap<InternalDistributedMember, Collection<Collection>> resultsPerMember;
    private ConcurrentLinkedQueue<PRQueryTraceInfo> prQueryTraceInfoList = null;
    private final Set<Integer> bucketsToQuery;
    private final IntOpenHashSet successfulBuckets;
    private Set<InternalDistributedMember> failedMembers;

    public PartitionedRegionQueryEvaluator(InternalDistributedSystem sys, PartitionedRegion pr, DefaultQuery query, Object[] parameters, SelectResults cumulativeResults, Set<Integer> bucketsToQuery) {
        super(sys, pr.getPRId());
        this.pr = pr;
        this.query = query;
        this.parameters = parameters;
        this.cumulativeResults = cumulativeResults;
        this.bucketsToQuery = bucketsToQuery;
        this.successfulBuckets = new IntOpenHashSet(this.bucketsToQuery.size());
        this.resultsPerMember = new ConcurrentHashMap<InternalDistributedMember, Collection<Collection>>();
        this.node2bucketIds = Collections.emptyMap();
        if (query != null && query.isTraced()) {
            this.prQueryTraceInfoList = new ConcurrentLinkedQueue();
        }
    }

    @Override
    protected DistributionMessage createRequestMessage(Set recipients, ReplyProcessor21 processor) {
        throw new UnsupportedOperationException();
    }

    protected DistributionMessage createRequestMessage(InternalDistributedMember recipient, ReplyProcessor21 processor, List bucketIds) {
        return new QueryMessage(recipient, this.pr.getPRId(), processor, this.query, this.parameters, bucketIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processData(List objects, InternalDistributedMember sender, int sequenceNum, boolean lastInSequence) {
        Object traceObject;
        Object object;
        Collection results;
        CompiledSelect cs;
        boolean sortNeeded = false;
        List<CompiledSortCriterion> orderByAttribs = null;
        if (sender.getVersionObject().compareTo(Version.GFE_90) < 0 && (cs = this.query.getSimpleSelect()) != null && cs.isOrderBy()) {
            sortNeeded = true;
            orderByAttribs = cs.getOrderByAttrs();
        }
        if ((results = (Collection)this.resultsPerMember.get(sender)) == null) {
            object = this.resultsPerMember;
            synchronized (object) {
                results = (Collection)this.resultsPerMember.get(sender);
                if (results == null) {
                    results = new MemberResultsList();
                    this.resultsPerMember.put(sender, results);
                }
            }
        }
        if (objects.size() > 0 && (traceObject = objects.get(0)) instanceof PRQueryTraceInfo) {
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook("Pull off PR Query Trace Info");
            }
            PRQueryTraceInfo queryTrace = (PRQueryTraceInfo)objects.remove(0);
            queryTrace.setSender(sender);
            if (this.prQueryTraceInfoList != null) {
                this.prQueryTraceInfoList.add(queryTrace);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Results per member, for {} size: {}", (Object)sender, (Object)objects.size());
        }
        if (sortNeeded) {
            objects = this.sortIncomingData(objects, orderByAttribs);
        }
        object = results;
        synchronized (object) {
            if (QueryMonitor.isLowMemory()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("query canceled while gathering results, aborting");
                }
                String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
                this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
                return false;
            }
            results.add(objects);
            if (lastInSequence) {
                ((MemberResultsList)results).setLastChunkReceived(true);
            }
        }
        return true;
    }

    private List sortIncomingData(List objects, List<CompiledSortCriterion> orderByAttribs) {
        SortedStructBag newResults;
        boolean nullAtStart;
        ObjectType resultType = this.cumulativeResults.getCollectionType().getElementType();
        ExecutionContext local = new ExecutionContext(null, this.pr.cache);
        OrderByComparator comparator = new OrderByComparator(orderByAttribs, resultType, local);
        boolean bl = nullAtStart = !orderByAttribs.get(0).getCriterion();
        if (resultType != null && resultType.isStructType()) {
            SortedStructBag sortedStructBag = new SortedStructBag((Comparator<Object[]>)comparator, (StructType)resultType, nullAtStart);
            for (Object o : objects) {
                Struct s = (Struct)o;
                sortedStructBag.addFieldValues(s.getFieldValues());
            }
            newResults = sortedStructBag;
        } else {
            newResults = new SortedResultsBag(comparator, resultType, nullAtStart);
            newResults.addAll(objects);
        }
        objects = newResults.asList();
        return objects;
    }

    /*
     * Unable to fully structure code
     */
    public boolean executeQueryOnRemoteAndLocalNodes(TestHook th) throws InterruptedException, QueryException {
        block34: {
            isDebugEnabled = PartitionedRegionQueryEvaluator.logger.isDebugEnabled();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            n2b = new HashMap<InternalDistributedMember, List<Integer>>(this.node2bucketIds);
            n2b.remove(this.pr.getMyId());
            if (this.query.isQueryWithFunctionContext() && !n2b.isEmpty()) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("Remote buckets found for query executed in a Function.");
                }
                throw new QueryInvocationTargetException("Data movement detected accross PartitionRegion nodes while executing the Query with function filter.");
            }
            if (isDebugEnabled) {
                PartitionedRegionQueryEvaluator.logger.debug("Sending query execution request to {} remote members for the query:{}", (Object)n2b.size(), (Object)this.query.getQueryString());
            }
            processor = null;
            requiresRetry = false;
            if (n2b.isEmpty()) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("No remote members with buckets to query.");
                }
            } else {
                processor = this.createStreamingQueryPartitionResponse(this.sys, n2b);
                for (Map.Entry<InternalDistributedMember, List<Integer>> me : n2b.entrySet()) {
                    rcp = me.getKey();
                    bucketIds = me.getValue();
                    m = this.createRequestMessage(rcp, processor, bucketIds);
                    notReceivedMembers = this.sendMessage(m);
                    if (th != null) {
                        th.hook(4);
                    }
                    if (notReceivedMembers == null || notReceivedMembers.isEmpty()) continue;
                    requiresRetry = true;
                    processor.removeFailedSenders(notReceivedMembers);
                    if (!isDebugEnabled) continue;
                    PartitionedRegionQueryEvaluator.logger.debug("Failed sending to members {} retry required", (Object)notReceivedMembers);
                }
                if (th != null) {
                    th.hook(5);
                }
            }
            localFault = null;
            localNeedsRetry = false;
            if (this.node2bucketIds.containsKey(this.pr.getMyId())) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("Started query execution on local data for query:{}", (Object)this.query.getQueryString());
                }
                try {
                    localNeedsRetry = this.executeQueryOnLocalNode();
                    if (th == null) ** GOTO lbl54
                    th.hook(0);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    localFault = t;
                }
            } else if (isDebugEnabled) {
                PartitionedRegionQueryEvaluator.logger.debug("No local buckets to query.");
            }
lbl54:
            // 6 sources

            if (processor != null) {
                try {
                    this.failedMembers = processor.waitForCacheOrQueryException();
                    for (InternalDistributedMember member : this.failedMembers) {
                        this.memberStreamCorrupted(member);
                    }
                    requiresRetry |= this.failedMembers.isEmpty() == false;
                    if (isDebugEnabled) {
                        PartitionedRegionQueryEvaluator.logger.debug("Following remote members failed {} and retry flag is set to: {}", this.failedMembers, (Object)requiresRetry);
                    }
                }
                catch (TimeoutException e) {
                    if (localFault == null) {
                        throw new QueryException(e);
                    }
                }
                catch (ReplyException e) {
                    if (localFault == null) {
                        throw e;
                    }
                }
                catch (Error e) {
                    if (localFault == null) {
                        throw e;
                    }
                }
                catch (RuntimeException e) {
                    if (localFault != null) break block34;
                    throw e;
                }
            }
        }
        if (this.query.isCanceled()) {
            throw this.query.getQueryCanceledException();
        }
        if (localFault != null) {
            if (localFault instanceof QueryException) {
                throw (QueryException)localFault;
            }
            if (localFault instanceof InterruptedException) {
                throw (InterruptedException)localFault;
            }
            if (localFault instanceof Error) {
                throw (Error)localFault;
            }
            if (localFault instanceof RuntimeException) {
                throw (RuntimeException)localFault;
            }
        }
        return requiresRetry | localNeedsRetry;
    }

    protected Set sendMessage(DistributionMessage m) {
        return this.sys.getDistributionManager().putOutgoing(m);
    }

    protected StreamingQueryPartitionResponse createStreamingQueryPartitionResponse(InternalDistributedSystem system, HashMap<InternalDistributedMember, List<Integer>> n2b) {
        return new StreamingQueryPartitionResponse(system, n2b.keySet());
    }

    public SelectResults queryBuckets(TestHook th) throws QueryException, InterruptedException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (isDebugEnabled) {
            logger.debug("PRQE query :{}", (Object)this.query.getQueryString());
        }
        Assert.assertTrue(this.bucketsToQuery != null && !this.bucketsToQuery.isEmpty(), "bucket set is empty.");
        this.node2bucketIds = this.buildNodeToBucketMap();
        Assert.assertTrue(!this.node2bucketIds.isEmpty(), " There are no data stores hosting any of the buckets.");
        boolean needsRetry = true;
        int retry = 0;
        while (needsRetry && retry < MAX_PR_QUERY_RETRIES) {
            needsRetry = this.executeQueryOnRemoteAndLocalNodes(th);
            if (th != null) {
                th.hook(1);
            }
            if (needsRetry) {
                if (this.query.isQueryWithFunctionContext()) {
                    if (!isDebugEnabled) break;
                    logger.debug("No of retry attempts are: {}", (Object)retry);
                    break;
                }
                Map<InternalDistributedMember, List<Integer>> b2n = this.buildNodeToBucketMapForBuckets(this.calculateRetryBuckets());
                if (th != null) {
                    th.hook(2);
                }
                this.node2bucketIds = b2n;
                if (isDebugEnabled) {
                    logger.debug("PR Query retry: {} total: {}", (Object)retry, (Object)this.pr.getCachePerfStats().getPRQueryRetries());
                }
                this.pr.getCachePerfStats().incPRQueryRetries();
                ++retry;
                this.waitBeforeRetry();
            }
            if (th == null) continue;
            th.hook(3);
        }
        if (needsRetry) {
            String msg = "Failed to query all the partitioned region dataset (buckets) after " + retry + " attempts.";
            if (isDebugEnabled) {
                logger.debug("{} Unable to query some of the buckets from the set :{}", (Object)msg, this.calculateRetryBuckets());
            }
            throw new QueryException(msg);
        }
        return this.addResultsToResultSet();
    }

    private void waitBeforeRetry() {
        boolean interrupted = Thread.interrupted();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException intEx) {
            interrupted = true;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Set<Integer> calculateRetryBuckets() {
        Iterator<Map.Entry<InternalDistributedMember, List<Integer>>> memberToBucketList = this.node2bucketIds.entrySet().iterator();
        HashSet<Integer> retryBuckets = new HashSet<Integer>();
        while (memberToBucketList.hasNext()) {
            Map.Entry<InternalDistributedMember, List<Integer>> e = memberToBucketList.next();
            InternalDistributedMember m = e.getKey();
            if (this.resultsPerMember.containsKey(m) && ((MemberResultsList)this.resultsPerMember.get(m)).isLastChunkReceived()) continue;
            retryBuckets.addAll((Collection<Integer>)e.getValue());
            this.resultsPerMember.remove(m);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer logStr = new StringBuffer();
            logStr.append("Query ").append(this.query.getQueryString()).append(" needs to retry bucketsIds: [");
            for (Integer i : retryBuckets) {
                logStr.append("," + i);
            }
            logStr.append("]");
            logger.debug((CharSequence)logStr);
        }
        return retryBuckets;
    }

    private SelectResults addResultsToResultSet() throws QueryException {
        boolean isGroupByResults;
        boolean numElementsInResult = false;
        boolean isDistinct = false;
        boolean isCount = false;
        int limit = -1;
        CompiledSelect cs = null;
        if (this.query != null) {
            cs = this.query.getSimpleSelect();
            limit = this.query.getLimit(this.parameters);
            isDistinct = cs != null ? cs.isDistinct() : true;
            boolean bl = isCount = cs != null ? cs.isCount() : false;
        }
        if (isCount && !isDistinct) {
            this.addTotalCountForMemberToResults(limit);
            return this.cumulativeResults;
        }
        boolean bl = isGroupByResults = cs.getType() == -17;
        if (isGroupByResults) {
            SelectResults baseResults = null;
            CompiledGroupBySelect cgs = (CompiledGroupBySelect)cs;
            baseResults = cgs.getOrderByAttrs() != null && !cgs.getOrderByAttrs().isEmpty() ? this.buildSortedResult(cs, limit) : this.buildCumulativeResults(isDistinct, limit);
            ExecutionContext context = new ExecutionContext(null, this.pr.cache);
            context.setIsPRQueryNode(true);
            return cgs.applyAggregateAndGroupBy(baseResults, context);
        }
        if (this.cumulativeResults.getCollectionType().isOrdered() && cs.getOrderByAttrs() != null) {
            return this.buildSortedResult(cs, limit);
        }
        return this.buildCumulativeResults(isDistinct, limit);
    }

    private SelectResults buildCumulativeResults(boolean isDistinct, int limit) {
        boolean getDeserializedObject = false;
        int numElementsInResult = 0;
        ObjectType elementType = this.cumulativeResults.getCollectionType().getElementType();
        boolean isStruct = elementType != null && elementType.isStructType();
        InternalDistributedMember me = this.pr.getMyId();
        if (DefaultQuery.testHook != null) {
            DefaultQuery.testHook.doTestHook(4);
        }
        boolean localResults = false;
        ArrayList<CumulativeNonDistinctResults.Metadata> collectionsMetadata = null;
        ArrayList<Collection> results = null;
        if (isDistinct) {
            if (isStruct) {
                StructType stype = (StructType)elementType;
                this.cumulativeResults = new StructSet(stype);
            } else {
                this.cumulativeResults = new ResultsSet(elementType);
            }
        } else {
            collectionsMetadata = new ArrayList<CumulativeNonDistinctResults.Metadata>();
            results = new ArrayList<Collection>();
        }
        block0: for (Map.Entry entry : this.resultsPerMember.entrySet()) {
            boolean getDomainObjectForPdx;
            this.checkLowMemory();
            if (((InternalDistributedMember)entry.getKey()).equals(me)) {
                getDomainObjectForPdx = false;
                localResults = true;
            } else {
                boolean bl = getDomainObjectForPdx = !this.pr.getCache().getPdxReadSerializedByAnyGemFireServices();
                if (!getDeserializedObject && !this.query.isKeepSerialized()) {
                    getDeserializedObject = true;
                }
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (!isDistinct) {
                CumulativeNonDistinctResults.Metadata wrapper = CumulativeNonDistinctResults.getCollectionMetadata(getDomainObjectForPdx, getDeserializedObject, localResults);
                for (Collection res : (Collection)entry.getValue()) {
                    results.add(res);
                    collectionsMetadata.add(wrapper);
                }
                continue;
            }
            block2: for (Collection res : (Collection)entry.getValue()) {
                this.checkLowMemory();
                if (res == null) continue;
                if (isDebugEnabled) {
                    logger.debug("Query Result from member :{}: {}", entry.getKey(), (Object)res.size());
                }
                if (numElementsInResult == limit) continue block0;
                boolean[] objectChangedMarker = new boolean[1];
                for (Object obj : res) {
                    this.checkLowMemory();
                    boolean occurence = false;
                    obj = PDXUtils.convertPDX(obj, isStruct, getDomainObjectForPdx, getDeserializedObject, localResults, objectChangedMarker, true);
                    boolean elementGotAdded = isStruct ? ((StructSet)this.cumulativeResults).addFieldValues((Object[])obj) : this.cumulativeResults.add(obj);
                    occurence = elementGotAdded;
                    if (!occurence || ++numElementsInResult != limit) continue;
                    continue block2;
                }
            }
        }
        if (this.prQueryTraceInfoList != null && this.query.isTraced() && logger.isInfoEnabled()) {
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook("Create PR Query Trace String");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(LocalizedStrings.PartitionedRegion_QUERY_TRACE_LOG.toLocalizedString(this.query.getQueryString())).append("\n");
            for (PRQueryTraceInfo queryTraceInfo : this.prQueryTraceInfoList) {
                sb.append(queryTraceInfo.createLogLine(me)).append("\n");
            }
            logger.info(sb.toString());
        }
        if (!isDistinct) {
            this.cumulativeResults = new CumulativeNonDistinctResults(results, limit, this.cumulativeResults.getCollectionType().getElementType(), collectionsMetadata);
        }
        return this.cumulativeResults;
    }

    private void checkLowMemory() {
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
            this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook(5);
            }
            throw this.query.getQueryCanceledException();
        }
    }

    private void addTotalCountForMemberToResults(int limit) {
        int count = 0;
        for (Collection results : this.resultsPerMember.values()) {
            for (Collection res : results) {
                if (res == null) continue;
                for (Object obj : res) {
                    if (limit > -1 && count >= limit) {
                        count = limit;
                        break;
                    }
                    count += ((Integer)obj).intValue();
                }
                res.clear();
            }
        }
        this.cumulativeResults.clear();
        this.cumulativeResults.add(count);
    }

    private SelectResults buildSortedResult(CompiledSelect cs, int limit) throws QueryException {
        try {
            QueryExecutionContext localContext = new QueryExecutionContext(this.parameters, this.pr.cache);
            ArrayList<Collection> allResults = new ArrayList<Collection>();
            for (Collection memberResults : this.resultsPerMember.values()) {
                for (Collection res : memberResults) {
                    if (res == null) continue;
                    allResults.add(res);
                }
            }
            this.cumulativeResults = new NWayMergeResults(allResults, cs.isDistinct(), limit, cs.getOrderByAttrs(), localContext, cs.getElementTypeForOrderByQueries());
            return this.cumulativeResults;
        }
        catch (Exception ex) {
            throw new QueryException("Unable to apply order-by on the partition region cumulative results.", ex);
        }
    }

    Map<InternalDistributedMember, List<Integer>> buildNodeToBucketMap() throws QueryException {
        return this.buildNodeToBucketMapForBuckets(this.bucketsToQuery);
    }

    private Map<InternalDistributedMember, List<Integer>> buildNodeToBucketMapForBuckets(Set<Integer> bucketIdsToConsider) throws QueryException {
        HashMap<InternalDistributedMember, List<Integer>> ret = new HashMap<InternalDistributedMember, List<Integer>>();
        if (bucketIdsToConsider.isEmpty()) {
            return ret;
        }
        ArrayList<Integer> bucketIds = new ArrayList<Integer>();
        PartitionedRegionDataStore dataStore = this.pr.getDataStore();
        int totalBucketsToQuery = bucketIdsToConsider.size();
        if (dataStore != null) {
            for (Integer bid : bucketIdsToConsider) {
                if (!dataStore.isManagingBucket(bid)) continue;
                bucketIds.add(bid);
            }
            if (bucketIds.size() > 0) {
                ret.put(this.pr.getMyId(), new ArrayList(bucketIds));
                if (bucketIds.size() == totalBucketsToQuery) {
                    return ret;
                }
            }
        }
        ArrayList allNodes = this.getAllNodes(this.pr.getRegionAdvisor());
        if (this.failedMembers != null && !this.failedMembers.isEmpty()) {
            allNodes.removeAll(this.failedMembers);
            allNodes.addAll(this.failedMembers);
        }
        Iterator dsItr = allNodes.iterator();
        while (dsItr.hasNext() && bucketIds.size() < totalBucketsToQuery) {
            InternalDistributedMember nd = (InternalDistributedMember)dsItr.next();
            ArrayList<Integer> buckets = new ArrayList<Integer>();
            for (Integer bid : bucketIdsToConsider) {
                Set<InternalDistributedMember> owners;
                if (bucketIds.contains(bid) || !(owners = this.getBucketOwners(bid)).contains(nd)) continue;
                buckets.add(bid);
                bucketIds.add(bid);
            }
            if (buckets.isEmpty()) continue;
            ret.put(nd, buckets);
        }
        if (bucketIds.size() != totalBucketsToQuery) {
            bucketIdsToConsider.removeAll(bucketIds);
            throw new QueryException("Data loss detected, unable to find the hosting  node for some of the dataset. [dataset/bucket ids:" + bucketIdsToConsider + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Node to bucketId map: {}", ret);
        }
        return ret;
    }

    protected Set<InternalDistributedMember> getBucketOwners(Integer bid) {
        return this.pr.getRegionAdvisor().getBucketOwners(bid);
    }

    protected ArrayList getAllNodes(RegionAdvisor regionAdvisor) {
        ArrayList<InternalDistributedMember> nodes = new ArrayList<InternalDistributedMember>(regionAdvisor.adviseDataStore());
        Collections.shuffle(nodes);
        return nodes;
    }

    private boolean executeQueryOnLocalNode() throws QueryException, InterruptedException {
        long startTime = 0L;
        if (this.query.isTraced()) {
            startTime = NanoTimer.getTime();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.pr.getDataStore() != null) {
            this.pr.getDataStore().invokeBucketReadHook();
            InternalDistributedMember me = this.pr.getMyId();
            List<Integer> bucketList = this.node2bucketIds.get(me);
            try {
                PRQueryProcessor qp = this.createLocalPRQueryProcessor(bucketList);
                MemberResultsList resultCollector = new MemberResultsList();
                qp.executeQuery(resultCollector);
                if (!this.query.isRemoteQuery() && this.pr.getCompressor() == null && this.pr.getCache().isCopyOnRead() && (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL || qp.isIndexUsed() && DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL)) {
                    MemberResultsList tmpResultCollector = new MemberResultsList();
                    for (Object o : resultCollector) {
                        if (o instanceof Collection) {
                            Collection results = (Collection)o;
                            ArrayList tmpResults = new ArrayList();
                            for (Object collectionObject : results) {
                                tmpResults.add(CopyHelper.copy(collectionObject));
                            }
                            tmpResultCollector.add(tmpResults);
                            continue;
                        }
                        tmpResultCollector.add(CopyHelper.copy(o));
                    }
                    resultCollector = tmpResultCollector;
                }
                if (this.query.isTraced() && this.prQueryTraceInfoList != null) {
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook("Create PR Query Trace Info From Local Node");
                    }
                    PRQueryTraceInfo queryTraceInfo = new PRQueryTraceInfo();
                    queryTraceInfo.setNumResults(queryTraceInfo.calculateNumberOfResults(resultCollector));
                    queryTraceInfo.setTimeInMillis((float)(NanoTimer.getTime() - startTime) / 1000000.0f);
                    queryTraceInfo.setSender(me);
                    this.prQueryTraceInfoList.add(queryTraceInfo);
                }
                resultCollector.setLastChunkReceived(true);
                MemberResultsList otherResults = (MemberResultsList)this.resultsPerMember.put(me, resultCollector);
                if (otherResults != null) {
                    resultCollector.addAll(otherResults);
                }
            }
            catch (ForceReattemptException retryRequired) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught exception during local portion of query {}", (Object)this.query.getQueryString(), (Object)retryRequired);
                }
                return true;
            }
        }
        return false;
    }

    protected PRQueryProcessor createLocalPRQueryProcessor(List<Integer> bucketList) {
        return new PRQueryProcessor(this.pr, this.query, this.parameters, bucketList);
    }

    protected void memberStreamCorrupted(InternalDistributedMember sender) {
        this.resultsPerMember.remove(sender);
    }

    public Map getResultsPerMember() {
        return this.resultsPerMember;
    }

    public class StreamingQueryPartitionResponse
    extends StreamingPartitionOperation.StreamingPartitionResponse {
        public StreamingQueryPartitionResponse(InternalDistributedSystem system, Set members) {
            super(PartitionedRegionQueryEvaluator.this, system, members);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            this.msgsBeingProcessed.incrementAndGet();
            try {
                StreamingOperation.StreamingReplyMessage m = (StreamingOperation.StreamingReplyMessage)msg;
                boolean isLast = true;
                List objects = m.getObjects();
                if (m.isCanceled()) {
                    String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
                    PartitionedRegionQueryEvaluator.this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
                    this.abort = true;
                }
                if (objects != null) {
                    boolean isAborted = this.abort;
                    if (!isAborted) {
                        boolean bl = isAborted = !PartitionedRegionQueryEvaluator.this.processChunk(objects, m.getSender(), m.getMessageNumber(), m.isLastMessage());
                        if (isAborted) {
                            this.abort = true;
                        }
                    }
                    isLast = isAborted || this.trackMessage(m);
                } else {
                    isLast = true;
                }
                if (isLast) {
                    super.process(msg, false);
                }
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
            }
        }

        public ObjectType getResultType() {
            return PartitionedRegionQueryEvaluator.this.cumulativeResults.getCollectionType().getElementType();
        }
    }

    public static class PRQueryResultCollector {
        private BlockingQueue resultQueue = new LinkedBlockingQueue();
        private final Map<String, IndexTrackingQueryObserver.IndexInfo> usedIndexInfoMap = new Object2ObjectOpenHashMap();

        public boolean isEmpty() {
            return this.resultQueue.isEmpty();
        }

        public void setResultQueue(BlockingQueue resultQueue) {
            this.resultQueue = resultQueue;
        }

        public Map getIndexInfoMap() {
            return this.usedIndexInfoMap;
        }

        public int size() {
            return this.resultQueue.size();
        }

        public Object get() throws InterruptedException {
            return this.resultQueue.take();
        }

        public void put(Object obj) throws InterruptedException {
            this.resultQueue.put(obj);
        }
    }

    public static interface TestHook {
        public void hook(int var1) throws RuntimeException;
    }

    public static class MemberResultsList
    extends ArrayList {
        private boolean isLastChunkReceived = false;

        public boolean isLastChunkReceived() {
            return this.isLastChunkReceived;
        }

        public void setLastChunkReceived(boolean isLastChunkReceived) {
            this.isLastChunkReceived = isLastChunkReceived;
        }
    }
}

