/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.OneTaskOnlyExecutor;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.BucketBackupMessage;
import org.apache.geode.internal.cache.partitioned.CreateBucketMessage;
import org.apache.geode.internal.cache.partitioned.CreateMissingBucketsTask;
import org.apache.geode.internal.cache.partitioned.EndBucketCreationMessage;
import org.apache.geode.internal.cache.partitioned.FetchPartitionDetailsMessage;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.ManageBackupBucketMessage;
import org.apache.geode.internal.cache.partitioned.ManageBucketMessage;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetailsImpl;
import org.apache.geode.internal.cache.partitioned.PRLoad;
import org.apache.geode.internal.cache.partitioned.PartitionMemberInfoImpl;
import org.apache.geode.internal.cache.partitioned.PartitionRegionInfoImpl;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;
import org.apache.geode.internal.cache.partitioned.RedundancyLogger;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.partitioned.rebalance.CompositeDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.FPRDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.persistence.MembershipFlushRequest;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PRHARedundancyProvider {
    private static final Logger logger = LogService.getLogger();
    private static final boolean DISABLE_CREATE_BUCKET_RANDOMNESS = Boolean.getBoolean("gemfire.DISABLE_CREATE_BUCKET_RANDOMNESS");
    public static final String DATASTORE_DISCOVERY_TIMEOUT_PROPERTY_NAME = "gemfire.partitionedRegionDatastoreDiscoveryTimeout";
    static volatile Long DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS = Long.getLong("gemfire.partitionedRegionDatastoreDiscoveryTimeout");
    public final PartitionedRegion prRegion;
    private static AtomicLong insufficientLogTimeStamp = new AtomicLong(0L);
    private final AtomicBoolean firstInsufficentStoresLogged = new AtomicBoolean(false);
    protected final OneTaskOnlyExecutor recoveryExecutor;
    private volatile ScheduledFuture<?> recoveryFuture;
    private final Object shutdownLock = new Object();
    private boolean shutdown = false;
    volatile CountDownLatch allBucketsRecoveredFromDisk;
    private RedundancyLogger redundancyLogger = null;
    public static final StringId TIMEOUT_MSG = LocalizedStrings.PRHARedundancyProvider_IF_YOUR_SYSTEM_HAS_SUFFICIENT_SPACE_PERHAPS_IT_IS_UNDER_MEMBERSHIP_OR_REGION_CREATION_STRESS;
    public static final StringId INSUFFICIENT_STORES_MSG = LocalizedStrings.PRHARedundancyProvider_CONSIDER_STARTING_ANOTHER_MEMBER;
    public static final StringId SUFFICIENT_STORES_MSG = LocalizedStrings.PRHARRedundancyProvider_FOUND_A_MEMBER_TO_HOST_A_BUCKET;
    private static final StringId ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET = LocalizedStrings.PRHARRedundancyProvider_ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET;
    public static final long INSUFFICIENT_LOGGING_THROTTLE_TIME = TimeUnit.SECONDS.toNanos(Integer.getInteger("gemfire.InsufficientLoggingThrottleTime", 2).intValue());
    public static volatile boolean TEST_MODE = false;
    private static volatile EndBucketCreationObserver testEndObserverInstance;
    private static final ThreadLocal forceLocalPrimaries;

    public PRHARedundancyProvider(final PartitionedRegion region) {
        this.prRegion = region;
        InternalResourceManager resourceManager = region.getGemFireCache().getInternalResourceManager();
        this.recoveryExecutor = new OneTaskOnlyExecutor(resourceManager.getExecutor(), new OneTaskOnlyExecutor.ConflatedTaskListener(){

            @Override
            public void taskDropped() {
                InternalResourceManager.getResourceObserver().recoveryConflated(region);
            }
        });
    }

    public static String regionStatus(PartitionedRegion prRegion, Set allStores, Collection alreadyUsed, boolean forLog) {
        String spaces;
        char newLine;
        StringBuffer sb = new StringBuffer();
        sb.append("Partitioned Region name = " + prRegion.getFullPath());
        if (forLog) {
            newLine = ' ';
            spaces = "";
        } else {
            newLine = '\n';
            spaces = "   ";
        }
        if (allStores != null) {
            sb.append(newLine + spaces + "Redundancy level set to " + prRegion.getRedundantCopies());
            sb.append(newLine + ". Number of available data stores: " + allStores.size());
            sb.append(newLine + spaces + ". Number successfully allocated = " + alreadyUsed.size());
            sb.append(newLine + ". Data stores: " + PartitionedRegionHelper.printCollection(allStores));
            sb.append(newLine + ". Data stores successfully allocated: " + PartitionedRegionHelper.printCollection(alreadyUsed));
            sb.append(newLine + ". Equivalent members: " + PartitionedRegionHelper.printCollection(prRegion.getDistributionManager().getMembersInThisZone()));
        }
        return sb.toString();
    }

    public static void timedOut(PartitionedRegion prRegion, Set allStores, Collection alreadyUsed, String opString, long timeOut) {
        String tooManyRetries = LocalizedStrings.PRHARedundancyProvider_TIMED_OUT_ATTEMPTING_TO_0_IN_THE_PARTITIONED_REGION__1_WAITED_FOR_2_MS.toLocalizedString(opString, PRHARedundancyProvider.regionStatus(prRegion, allStores, alreadyUsed, true), timeOut) + TIMEOUT_MSG;
        throw new PartitionedRegionStorageException(tooManyRetries);
    }

    private Set<InternalDistributedMember> getAllStores(String partitionName) {
        if (partitionName != null) {
            return this.getFixedPartitionStores(partitionName);
        }
        Set<InternalDistributedMember> allStores = this.prRegion.getRegionAdvisor().adviseDataStore(true);
        PartitionedRegionDataStore myDS = this.prRegion.getDataStore();
        if (myDS != null) {
            allStores.add(this.prRegion.getDistributionManager().getId());
        }
        return allStores;
    }

    private Set<InternalDistributedMember> getFixedPartitionStores(String partitionName) {
        Set<InternalDistributedMember> members = this.prRegion.getRegionAdvisor().adviseFixedPartitionDataStores(partitionName);
        List<FixedPartitionAttributesImpl> FPAs = this.prRegion.getFixedPartitionAttributesImpl();
        if (FPAs != null) {
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                if (!fpa.getPartitionName().equals(partitionName)) continue;
                members.add(this.prRegion.getMyId());
            }
        }
        return members;
    }

    private void insufficientStores(Set allStores, Collection alreadyUsed, boolean onlyLog) {
        String regionStat = PRHARedundancyProvider.regionStatus(this.prRegion, allStores, alreadyUsed, onlyLog);
        char newLine = onlyLog ? (char)' ' : '\n';
        StringId notEnoughValidNodes = alreadyUsed.isEmpty() ? LocalizedStrings.PRHARRedundancyProvider_UNABLE_TO_FIND_ANY_MEMBERS_TO_HOST_A_BUCKET_IN_THE_PARTITIONED_REGION_0 : LocalizedStrings.PRHARRedundancyProvider_CONFIGURED_REDUNDANCY_LEVEL_COULD_NOT_BE_SATISFIED_0;
        Object[] notEnoughValidNodesArgs = new Object[]{INSUFFICIENT_STORES_MSG, newLine + regionStat + newLine};
        if (!onlyLog) {
            throw new PartitionedRegionStorageException(notEnoughValidNodes.toLocalizedString(notEnoughValidNodesArgs));
        }
        logger.warn((Message)LocalizedMessage.create(notEnoughValidNodes, notEnoughValidNodesArgs));
    }

    private InternalDistributedMember createBucketInstance(int bucketId, int newBucketSize, Set<InternalDistributedMember> excludedMembers, Collection<InternalDistributedMember> alreadyUsed, ArrayListWithClearState<InternalDistributedMember> failedMembers, long timeOut, Set<InternalDistributedMember> allStores) {
        RegionAdvisor.PartitionProfile pp;
        boolean isDebugEnabled = logger.isDebugEnabled();
        HashSet<InternalDistributedMember> candidateMembers = new HashSet<InternalDistributedMember>(allStores);
        candidateMembers.removeAll(alreadyUsed);
        candidateMembers.removeAll(excludedMembers);
        candidateMembers.removeAll(failedMembers);
        if (isDebugEnabled) {
            logger.debug("AllStores={} AlreadyUsed={} excluded={} failed={}", allStores, alreadyUsed, excludedMembers, failedMembers);
        }
        if (candidateMembers.size() == 0) {
            this.prRegion.checkReadiness();
            if (System.currentTimeMillis() > timeOut) {
                if (isDebugEnabled) {
                    logger.debug("createBucketInstance: ran out of candidates and timed out");
                }
                return null;
            }
            candidateMembers = new HashSet<InternalDistributedMember>(allStores);
            candidateMembers.removeAll(alreadyUsed);
            candidateMembers.removeAll(excludedMembers);
            failedMembers.clear();
        }
        if (isDebugEnabled) {
            logger.debug("createBucketInstance: candidateMembers = {}", candidateMembers);
        }
        InternalDistributedMember candidate = null;
        if (candidateMembers.size() == 0) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstance: no valid candidates");
            }
            return null;
        }
        if (this.prRegion.isFixedPartitionedRegion()) {
            candidate = candidateMembers.iterator().next();
        } else {
            String prName = this.prRegion.getAttributes().getPartitionAttributes().getColocatedWith();
            if (prName != null) {
                candidate = this.getColocatedDataStore(candidateMembers, alreadyUsed, bucketId, prName);
            } else {
                ArrayList<InternalDistributedMember> orderedCandidates = new ArrayList<InternalDistributedMember>(candidateMembers);
                candidate = this.getPreferredDataStore(orderedCandidates, alreadyUsed);
            }
        }
        if (candidate == null) {
            failedMembers.addAll(candidateMembers);
            return null;
        }
        if (!this.prRegion.isShadowPR() && !ColocationHelper.checkMembersColocation(this.prRegion, candidate)) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstances - Member does not have all of the regions colocated with prRegion {}", (Object)candidate);
            }
            failedMembers.add(candidate);
            return null;
        }
        if (!candidate.equals(this.prRegion.getMyId()) && (pp = this.prRegion.getRegionAdvisor().getPartitionProfile(candidate)) == null) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstance: {}: no partition profile for {}", (Object)this.prRegion.getFullPath(), (Object)candidate);
            }
            failedMembers.add(candidate);
            return null;
        }
        ManageBucketRsp response = this.createBucketOnMember(bucketId, candidate, newBucketSize, failedMembers.wasCleared());
        if (response.isAcceptance()) {
            return candidate;
        }
        if (isDebugEnabled) {
            logger.debug("createBucketInstance: {}: candidate {} declined to manage bucketId={}: {}", (Object)this.prRegion.getFullPath(), (Object)candidate, (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)response);
        }
        if (response.equals(ManageBucketRsp.CLOSED)) {
            excludedMembers.add(candidate);
        } else {
            failedMembers.add(candidate);
        }
        candidate = null;
        return null;
    }

    public InternalDistributedMember createBucketOnDataStore(int bucketId, int size, long startTime, PartitionedRegion.RetryTimeKeeper snoozer) {
        InternalDistributedMember ret;
        HashSet<InternalDistributedMember> attempted = new HashSet<InternalDistributedMember>();
        InternalDistributedMember primaryForFixedPartition = null;
        if (this.prRegion.isFixedPartitionedRegion()) {
            primaryForFixedPartition = this.prRegion.getRegionAdvisor().adviseFixedPrimaryPartitionDataStore(bucketId);
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            this.prRegion.checkReadiness();
            Set<InternalDistributedMember> available = this.prRegion.getRegionAdvisor().adviseInitializedDataStore();
            InternalDistributedMember target = null;
            available.removeAll(attempted);
            Iterator<InternalDistributedMember> iterator = available.iterator();
            if (iterator.hasNext()) {
                InternalDistributedMember member = iterator.next();
                target = available.contains(primaryForFixedPartition) ? primaryForFixedPartition : member;
            }
            if (target == null) {
                if (this.shouldLogInsufficientStores()) {
                    this.insufficientStores(available, Collections.emptySet(), true);
                }
                this.insufficientStores(available, Collections.emptySet(), false);
            }
            try {
                CreateBucketMessage.NodeResponse response;
                if (isDebugEnabled) {
                    logger.debug("Attempting to get data store {} to create the bucket {} for us", (Object)target, (Object)this.prRegion.bucketStringForLogs(bucketId));
                }
                if ((ret = (response = CreateBucketMessage.send(target, this.prRegion, bucketId, size)).waitForResponse()) != null) {
                    return ret;
                }
            }
            catch (ForceReattemptException forceReattemptException) {
                // empty catch block
            }
            attempted.add(target);
        } while ((ret = this.prRegion.getNodeForBucketWrite(bucketId, snoozer)) == null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalDistributedMember createBucketAtomically(int bucketId, int newBucketSize, long startTime, boolean finishIncompleteCreation, String partitionName) throws PartitionedRegionStorageException, PartitionedRegionException, PartitionOfflineException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        this.prRegion.checkPROffline();
        this.earlySufficientStoresCheck(partitionName);
        PRHARedundancyProvider pRHARedundancyProvider = this;
        synchronized (pRHARedundancyProvider) {
            if (this.prRegion.getCache().isCacheAtShutdownAll()) {
                throw new CacheClosedException("Cache is shutting down");
            }
            if (isDebugEnabled) {
                logger.debug("Starting atomic creation of bucketId={}", (Object)this.prRegion.bucketStringForLogs(bucketId));
            }
            Collection<InternalDistributedMember> acceptedMembers = new ArrayList<InternalDistributedMember>();
            HashSet<InternalDistributedMember> excludedMembers = new HashSet<InternalDistributedMember>();
            ArrayListWithClearState<InternalDistributedMember> failedMembers = new ArrayListWithClearState<InternalDistributedMember>();
            long timeOut = System.currentTimeMillis() + this.computeTimeout();
            BucketMembershipObserver observer = null;
            boolean needToElectPrimary = true;
            InternalDistributedMember bucketPrimary = null;
            try {
                this.prRegion.checkReadiness();
                Bucket toCreate = this.prRegion.getRegionAdvisor().getBucket(bucketId);
                if (!finishIncompleteCreation && (bucketPrimary = this.prRegion.getBucketPrimary(bucketId)) != null) {
                    if (isDebugEnabled) {
                        logger.debug("during atomic creation, discovered that the primary already exists {} returning early", (Object)bucketPrimary);
                    }
                    needToElectPrimary = false;
                    InternalDistributedMember internalDistributedMember = bucketPrimary;
                    return internalDistributedMember;
                }
                observer = new BucketMembershipObserver(toCreate).beginMonitoring();
                boolean loggedInsufficentStores = false;
                while (true) {
                    boolean bucketNotCreated;
                    this.prRegion.checkReadiness();
                    if (this.prRegion.getCache().isCacheAtShutdownAll()) {
                        if (!isDebugEnabled) throw new CacheClosedException("Cache is shutting down");
                        logger.debug("Aborted createBucketAtomically due to ShutdownAll");
                        throw new CacheClosedException("Cache is shutting down");
                    }
                    long timeLeft = timeOut - System.currentTimeMillis();
                    if (timeLeft < 0L) {
                        PRHARedundancyProvider.timedOut(this.prRegion, this.getAllStores(partitionName), acceptedMembers, ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET.toLocalizedString(), this.computeTimeout());
                    }
                    if (isDebugEnabled) {
                        logger.debug("createBucketAtomically: have {} ms left to finish this", (Object)timeLeft);
                    }
                    Set<InternalDistributedMember> allStores = this.getAllStores(partitionName);
                    loggedInsufficentStores = this.checkSufficientStores(allStores, loggedInsufficentStores);
                    InternalDistributedMember candidate = this.createBucketInstance(bucketId, newBucketSize, excludedMembers, acceptedMembers, failedMembers, timeOut, allStores);
                    if (candidate != null && this.prRegion.getDistributionManager().enforceUniqueZone()) {
                        if (!(this.prRegion.getDistributionManager() instanceof LonerDistributionManager)) {
                            Set<InternalDistributedMember> exm = this.getBuddyMembersInZone(candidate, allStores);
                            exm.remove(candidate);
                            exm.removeAll(acceptedMembers);
                            excludedMembers.addAll(exm);
                        } else {
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_ENFORCE_UNIQUE_HOST_NOT_APPLICABLE_FOR_LONER));
                        }
                    }
                    acceptedMembers = this.prRegion.getRegionAdvisor().getBucketOwners(bucketId);
                    if (isDebugEnabled) {
                        logger.debug("Accepted members: {}", acceptedMembers);
                    }
                    if (bucketPrimary == null && acceptedMembers.contains(candidate)) {
                        bucketPrimary = candidate;
                    }
                    this.verifyBucketNodes(excludedMembers, partitionName);
                    int potentialCandidateCount = allStores.size() - (excludedMembers.size() + acceptedMembers.size() + failedMembers.size());
                    boolean exhaustedPotentialCandidates = failedMembers.wasCleared() && potentialCandidateCount <= 0;
                    boolean redundancySatisfied = acceptedMembers.size() > this.prRegion.getRedundantCopies();
                    boolean bl = bucketNotCreated = acceptedMembers.size() == 0;
                    if (isDebugEnabled) {
                        logger.debug("potentialCandidateCount={}, exhaustedPotentialCandidates={}, redundancySatisfied={}, bucketNotCreated={}", (Object)potentialCandidateCount, (Object)exhaustedPotentialCandidates, (Object)redundancySatisfied, (Object)bucketNotCreated);
                    }
                    if (bucketNotCreated) continue;
                    if (exhaustedPotentialCandidates && !redundancySatisfied) {
                        this.insufficientStores(allStores, acceptedMembers, true);
                    }
                    if (redundancySatisfied || exhaustedPotentialCandidates) {
                        this.endBucketCreation(bucketId, acceptedMembers, bucketPrimary, partitionName);
                        int expectedRemoteHosts = acceptedMembers.size() - (acceptedMembers.contains(this.prRegion.getMyId()) ? 1 : 0);
                        boolean interrupted = Thread.interrupted();
                        try {
                            BucketMembershipObserverResults results = observer.waitForOwnersGetPrimary(expectedRemoteHosts, acceptedMembers, partitionName);
                            if (results.problematicDeparture) continue;
                            bucketPrimary = results.primary;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            this.prRegion.getCancelCriterion().checkCancelInProgress(e);
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        needToElectPrimary = false;
                        InternalDistributedMember internalDistributedMember = bucketPrimary;
                        return internalDistributedMember;
                    }
                    continue;
                    break;
                }
            }
            catch (CancelException e) {
                needToElectPrimary = false;
                throw e;
            }
            catch (RegionDestroyedException e) {
                needToElectPrimary = false;
                throw e;
            }
            catch (PartitionOfflineException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (isDebugEnabled) {
                    logger.debug("Unable to create new bucket {}: {}", (Object)bucketId, (Object)e.getMessage(), (Object)e);
                }
                if (finishIncompleteCreation) throw e;
                this.cleanUpBucket(bucketId);
                throw e;
            }
            finally {
                if (observer != null) {
                    observer.stopMonitoring();
                }
                if (needToElectPrimary) {
                    try {
                        this.endBucketCreation(bucketId, this.prRegion.getRegionAdvisor().getBucketOwners(bucketId), bucketPrimary, partitionName);
                    }
                    catch (Exception e) {
                        if (e instanceof CancelException || e instanceof CacheClosedException || this.prRegion.getCancelCriterion().isCancelInProgress()) {
                            logger.debug("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                        }
                        logger.warn("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                    }
                }
            }
        }
    }

    private void endBucketCreation(int bucketId, Collection<InternalDistributedMember> acceptedMembers, InternalDistributedMember targetPrimary, String partitionName) {
        if (acceptedMembers.isEmpty()) {
            return;
        }
        acceptedMembers = new HashSet<InternalDistributedMember>(acceptedMembers);
        if (partitionName != null) {
            if (this.isLocalPrimary(partitionName)) {
                targetPrimary = this.prRegion.getMyId();
            } else {
                targetPrimary = this.prRegion.getRegionAdvisor().adviseFixedPrimaryPartitionDataStore(bucketId);
                if (targetPrimary == null) {
                    Set<InternalDistributedMember> fpDataStores = this.getFixedPartitionStores(partitionName);
                    targetPrimary = fpDataStores.iterator().next();
                }
            }
        }
        if (targetPrimary == null) {
            targetPrimary = this.getPreferredDataStore(acceptedMembers, Collections.emptySet());
        }
        boolean isHosting = acceptedMembers.remove(this.prRegion.getDistributionManager().getId());
        EndBucketCreationMessage.send(acceptedMembers, targetPrimary, this.prRegion, bucketId);
        EndBucketCreationObserver observer = testEndObserverInstance;
        if (observer != null) {
            observer.afterEndBucketCreationMessageSend(this.prRegion, bucketId);
        }
        if (isHosting) {
            this.endBucketCreationLocally(bucketId, targetPrimary);
        }
        if (observer != null) {
            observer.afterEndBucketCreation(this.prRegion, bucketId);
        }
    }

    private boolean isLocalPrimary(String partitionName) {
        List<FixedPartitionAttributesImpl> FPAs = this.prRegion.getFixedPartitionAttributesImpl();
        if (FPAs != null) {
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                if (!fpa.getPartitionName().equals(partitionName) || !fpa.isPrimary()) continue;
                return true;
            }
        }
        return false;
    }

    public static void setTestEndBucketCreationObserver(EndBucketCreationObserver observer) {
        testEndObserverInstance = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBucketCreationLocally(int bucketId, InternalDistributedMember newPrimary) {
        if (this.prRegion.getCancelCriterion().isCancelInProgress() || this.prRegion.isDestroyed()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("endBucketCreationLocally: for region {} bucketId={} new primary: {}", (Object)this.prRegion.getFullPath(), (Object)bucketId, (Object)newPrimary);
        }
        BucketAdvisor bucketAdvisor = this.prRegion.getRegionAdvisor().getBucketAdvisor(bucketId);
        ProxyBucketRegion proxyBucketRegion = bucketAdvisor.getProxyBucketRegion();
        BucketPersistenceAdvisor persistentAdvisor = proxyBucketRegion.getPersistenceAdvisor();
        ProxyBucketRegion proxyBucketRegion2 = proxyBucketRegion;
        synchronized (proxyBucketRegion2) {
            BucketRegion realBucket;
            if (persistentAdvisor != null && (realBucket = proxyBucketRegion.getCreatedBucketRegion()) != null) {
                PersistentMemberID persistentID = realBucket.getPersistentID();
                persistentAdvisor.endBucketCreation(persistentID);
            }
            bucketAdvisor.setPrimaryElector(newPrimary);
            if (this.prRegion.getGemFireCache().getMyId().equals(newPrimary)) {
                if (bucketAdvisor.isHosting()) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
            } else {
                if (!bucketAdvisor.adviseInitialized().contains(newPrimary)) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
                if (bucketAdvisor.getHadPrimary()) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
            }
        }
        if (persistentAdvisor != null) {
            bucketAdvisor.endBucketCreation();
        }
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.prRegion);
        for (PartitionedRegion child : colocatedWithList) {
            if (!child.getRegionAdvisor().isBucketLocal(bucketId)) continue;
            child.getRedundancyProvider().endBucketCreationLocally(bucketId, newPrimary);
        }
    }

    private Set<InternalDistributedMember> getBuddyMembersInZone(InternalDistributedMember acceptedMember, Set<InternalDistributedMember> allStores) {
        HashSet allMembersOnSystem = new HashSet();
        DM dm = this.prRegion.getDistributionManager();
        Set<InternalDistributedMember> buddies = dm.getMembersInSameZone(acceptedMember);
        buddies.retainAll(allStores);
        return buddies;
    }

    private void earlySufficientStoresCheck(String partitionName) {
        assert (Assert.assertHoldsLock(this, false));
        Set<InternalDistributedMember> currentStores = this.getAllStores(partitionName);
        if (currentStores.isEmpty()) {
            if (this.shouldLogInsufficientStores()) {
                this.insufficientStores(currentStores, Collections.EMPTY_LIST, true);
            }
            this.insufficientStores(currentStores, Collections.EMPTY_LIST, false);
        }
    }

    private boolean shouldLogInsufficientStores() {
        long now = NanoTimer.getTime();
        long delta = now - insufficientLogTimeStamp.get();
        if (this.firstInsufficentStoresLogged.compareAndSet(false, true) || delta >= INSUFFICIENT_LOGGING_THROTTLE_TIME) {
            insufficientLogTimeStamp.set(now);
            return true;
        }
        return false;
    }

    private long computeTimeout() {
        long millis;
        if (DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS != null && (millis = DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS.longValue()) > 0L) {
            return millis;
        }
        return this.prRegion.getRetryTimeout();
    }

    private boolean checkSufficientStores(Set allStores, boolean loggedInsufficentStores) {
        if (!loggedInsufficentStores) {
            if (allStores.size() == 0) {
                this.insufficientStores(allStores, Collections.EMPTY_LIST, true);
                return true;
            }
        } else {
            if (allStores.size() > 0) {
                StringId logStr = LocalizedStrings.PRHARRedundancyProvider_0_IN_THE_PARTITIONED_REGION_REGION_NAME_1;
                Object[] logArgs = new Object[]{SUFFICIENT_STORES_MSG.toLocalizedString(), this.prRegion.getFullPath()};
                if (TEST_MODE) {
                    logger.fatal((Message)LocalizedMessage.create(logStr, logArgs));
                } else {
                    logger.info((Message)LocalizedMessage.create(logStr, logArgs));
                }
                return false;
            }
            this.insufficientStores(allStores, Collections.EMPTY_LIST, false);
        }
        return loggedInsufficentStores;
    }

    private void cleanUpBucket(int buck) {
        Set<InternalDistributedMember> dataStores = this.prRegion.getRegionAdvisor().adviseDataStore();
        BucketBackupMessage.send(dataStores, this.prRegion, buck);
    }

    public void finishIncompleteBucketCreation(int bucketId) {
        String partitionName = null;
        long startTime = PartitionedRegionStats.startTime();
        if (this.prRegion.isFixedPartitionedRegion()) {
            FixedPartitionAttributesImpl fpa = PartitionedRegionHelper.getFixedPartitionAttributesForBucket(this.prRegion, bucketId);
            partitionName = fpa.getPartitionName();
        }
        this.createBucketAtomically(bucketId, 0, startTime, true, partitionName);
    }

    public boolean createBackupBucketOnMember(int bucketId, InternalDistributedMember targetNMember, boolean isRebalance, boolean replaceOfflineData, InternalDistributedMember moveSource, boolean forceCreation) {
        boolean bucketManaged;
        if (logger.isDebugEnabled()) {
            logger.debug("createBackupBucketOnMember for bucketId={} member: {}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember);
        }
        if (!targetNMember.equals(this.prRegion.getMyId())) {
            RegionAdvisor.PartitionProfile pp = this.prRegion.getRegionAdvisor().getPartitionProfile(targetNMember);
            if (pp == null) {
                return false;
            }
            try {
                ManageBackupBucketMessage.NodeResponse response = ManageBackupBucketMessage.send(targetNMember, this.prRegion, bucketId, isRebalance, replaceOfflineData, moveSource, forceCreation);
                if (response.waitForAcceptance()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createBackupBucketOnMember: Bucket creation succeed for bucketId={} on member = {}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember);
                    }
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("createBackupBucketOnMember: Bucket creation failed for bucketId={} on member = {}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember);
                }
                return false;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!(e instanceof ForceReattemptException || e instanceof CancelException || e.getCause() != null && e.getCause() instanceof CancelException)) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PRHARedundancyProvider_EXCEPTION_CREATING_PARTITION_ON__0, targetNMember), e);
                }
                return false;
            }
        }
        PartitionedRegionDataStore prDS = this.prRegion.getDataStore();
        boolean bl = bucketManaged = prDS != null && prDS.grabBucket(bucketId, moveSource, forceCreation, replaceOfflineData, isRebalance, null, false).equals((Object)PartitionedRegionDataStore.CreateBucketResult.CREATED);
        if (!bucketManaged && logger.isDebugEnabled()) {
            logger.debug("createBackupBucketOnMember: Local data store refused to accommodate the data for bucketId={} prDS={}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)prDS);
        }
        return bucketManaged;
    }

    public static void setForceLocalPrimaries(boolean v) {
        forceLocalPrimaries.set(v);
    }

    private boolean getForceLocalPrimaries() {
        boolean result = false;
        Boolean v = (Boolean)forceLocalPrimaries.get();
        if (v != null) {
            result = v;
        }
        return result;
    }

    public ManageBucketRsp createBucketOnMember(int bucketId, InternalDistributedMember targetNMember, int newBucketSize, boolean forceCreation) {
        boolean bucketManaged;
        if (logger.isDebugEnabled()) {
            logger.debug("createBucketOnMember for bucketId={} member: {}{}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember, (Object)(forceCreation ? " forced" : ""));
        }
        if (!targetNMember.equals(this.prRegion.getMyId())) {
            RegionAdvisor.PartitionProfile pp = this.prRegion.getRegionAdvisor().getPartitionProfile(targetNMember);
            if (pp == null) {
                return ManageBucketRsp.NO;
            }
            try {
                ManageBucketMessage.NodeResponse response = ManageBucketMessage.send(targetNMember, this.prRegion, bucketId, newBucketSize, forceCreation);
                if (response.waitForAcceptance()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createBucketOnMember: Bucket creation succeed for bucketId={} on member = {}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember);
                    }
                    return ManageBucketRsp.YES;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("createBucketOnMember: Bucket creation failed for bucketId={} on member = {}", (Object)this.prRegion.bucketStringForLogs(bucketId), (Object)targetNMember);
                }
                return response.rejectedDueToInitialization() ? ManageBucketRsp.NO_INITIALIZING : ManageBucketRsp.NO;
            }
            catch (PartitionOfflineException e) {
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (e instanceof CancelException || e.getCause() != null && e.getCause() instanceof CancelException) {
                    return ManageBucketRsp.CLOSED;
                }
                if (!(e instanceof ForceReattemptException)) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PRHARedundancyProvider_EXCEPTION_CREATING_PARTITION_ON__0, targetNMember), e);
                }
                return ManageBucketRsp.NO;
            }
        }
        PartitionedRegionDataStore prDS = this.prRegion.getDataStore();
        boolean bl = bucketManaged = prDS != null && prDS.handleManageBucketRequest(bucketId, newBucketSize, this.prRegion.getMyId(), forceCreation);
        if (!bucketManaged && logger.isDebugEnabled()) {
            logger.debug("createBucketOnMember: Local data store not able to accommodate the data for bucketId={}", (Object)this.prRegion.bucketStringForLogs(bucketId));
        }
        return ManageBucketRsp.valueOf(bucketManaged);
    }

    private InternalDistributedMember getColocatedDataStore(Collection<InternalDistributedMember> candidates, Collection<InternalDistributedMember> alreadyUsed, int bucketId, String prName) {
        Assert.assertTrue(prName != null);
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.prRegion);
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(this.prRegion.getCache());
        PartitionRegionConfig config = (PartitionRegionConfig)prRoot.get(this.prRegion.getRegionIdentifier());
        if (!config.isColocationComplete()) {
            throw new IllegalStateException("Cannot create buckets, as colocated regions are not configured to be at the same nodes.");
        }
        RegionAdvisor advisor = colocatedRegion.getRegionAdvisor();
        if (alreadyUsed.isEmpty()) {
            InternalDistributedMember primary = advisor.getPrimaryMemberForBucket(bucketId);
            if (!candidates.contains(primary)) {
                return null;
            }
            return primary;
        }
        Set<InternalDistributedMember> bucketOwnersSet = advisor.getBucketOwners(bucketId);
        bucketOwnersSet.retainAll(candidates);
        ArrayList<InternalDistributedMember> members = new ArrayList<InternalDistributedMember>(bucketOwnersSet);
        if (members.isEmpty()) {
            return null;
        }
        return this.getPreferredDataStore(members, alreadyUsed);
    }

    private InternalDistributedMember getPreferredDataStore(Collection<InternalDistributedMember> candidates, Collection<InternalDistributedMember> alreadyUsed) {
        DataStoreBuckets aDataStore;
        PartitionedRegionDataStore myDS;
        boolean forPrimary;
        boolean bl = forPrimary = alreadyUsed.size() == 0;
        if (forPrimary && this.getForceLocalPrimaries() && (myDS = this.prRegion.getDataStore()) != null) {
            return this.prRegion.getMyId();
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        Assert.assertTrue(candidates.size() > 1);
        ArrayList<DataStoreBuckets> stores = this.prRegion.getRegionAdvisor().adviseFilteredDataStores(new HashSet<InternalDistributedMember>(candidates));
        DM dm = this.prRegion.getDistributionManager();
        InternalDistributedMember moi = dm.getId();
        PartitionedRegionDataStore myDS2 = this.prRegion.getDataStore();
        if (myDS2 != null && candidates.contains(moi)) {
            short bucketCount = myDS2.getBucketsManaged();
            int priCount = myDS2.getNumberOfPrimaryBucketsManaged();
            int localMaxMemory = this.prRegion.getLocalMaxMemory();
            stores.add(new DataStoreBuckets(moi, bucketCount, priCount, localMaxMemory));
        }
        if (stores.isEmpty()) {
            return null;
        }
        final HashSet<InternalDistributedMember> existingHosts = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember mem : alreadyUsed) {
            existingHosts.addAll(dm.getMembersInSameZone(mem));
        }
        Comparator<DataStoreBuckets> comparator = new Comparator<DataStoreBuckets>(){

            @Override
            public int compare(DataStoreBuckets d1, DataStoreBuckets d2) {
                float metric2;
                float metric1;
                boolean host1Used = existingHosts.contains(d1.memberId);
                boolean host2Used = existingHosts.contains(d2.memberId);
                if (!host1Used && host2Used) {
                    return -1;
                }
                if (host1Used && !host2Used) {
                    return 1;
                }
                if (forPrimary) {
                    metric1 = (float)d1.numPrimaries / (float)d1.localMaxMemoryMB;
                    metric2 = (float)d2.numPrimaries / (float)d2.localMaxMemoryMB;
                } else {
                    metric1 = (float)d1.numBuckets / (float)d1.localMaxMemoryMB;
                    metric2 = (float)d2.numBuckets / (float)d2.localMaxMemoryMB;
                }
                int result = Float.compare(metric1, metric2);
                if (result == 0) {
                    result = d2.localMaxMemoryMB - d1.localMaxMemoryMB;
                }
                return result;
            }
        };
        Collections.sort(stores, comparator);
        if (logger.isDebugEnabled()) {
            logger.debug(this.fancyFormatBucketAllocation("Sorted ", stores, existingHosts));
        }
        DataStoreBuckets bestDataStore = stores.get(0);
        ArrayList<DataStoreBuckets> bestStores = new ArrayList<DataStoreBuckets>();
        bestStores.add(bestDataStore);
        boolean allStoresInUse = alreadyUsed.contains(bestDataStore.memberId);
        for (int i = 1; i < stores.size(); ++i) {
            aDataStore = stores.get(i);
            if (!allStoresInUse && alreadyUsed.contains(aDataStore.memberId) || comparator.compare(bestDataStore, aDataStore) != 0) break;
            bestStores.add(aDataStore);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.fancyFormatBucketAllocation("Best Stores ", bestStores, existingHosts));
        }
        int chosen = DISABLE_CREATE_BUCKET_RANDOMNESS ? 0 : PartitionedRegion.RANDOM.nextInt(bestStores.size());
        aDataStore = (DataStoreBuckets)bestStores.get(chosen);
        return aDataStore.memberId;
    }

    public void startRedundancyRecovery() {
        this.prRegion.getRegionAdvisor().addMembershipListener(new PRMembershipListener());
        this.scheduleRedundancyRecovery(null);
    }

    private String fancyFormatBucketAllocation(String prefix, List dataStores, Set existingStores) {
        StringBuffer logStr = new StringBuffer();
        if (prefix != null) {
            logStr.append(prefix);
        }
        logStr.append("Bucket Allocation for prId=" + this.prRegion.getPRId() + ":\n");
        for (DataStoreBuckets dsb : dataStores) {
            logStr.append(dsb.memberId).append(": ");
            if (existingStores.contains(dsb.memberId)) {
                logStr.append("+");
            } else {
                logStr.append("-");
            }
            logStr.append(Integer.toString(dsb.numPrimaries));
            logStr.append("/");
            logStr.append(Integer.toString(dsb.numBuckets - dsb.numPrimaries));
            logStr.append('\n');
        }
        return logStr.toString();
    }

    void verifyBucketNodes(Collection<InternalDistributedMember> members, String partitionName) {
        if (members == null || members.isEmpty()) {
            return;
        }
        Set<InternalDistributedMember> availableMembers = this.getAllStores(partitionName);
        Iterator<InternalDistributedMember> itr = members.iterator();
        while (itr.hasNext()) {
            InternalDistributedMember node = itr.next();
            if (availableMembers.contains(node)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("verifyBucketNodes: removing member {}", (Object)node);
            }
            itr.remove();
            Assert.assertTrue(!members.contains(node), "return value does not contain " + node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRedundancyRecovery(Object failedMemId) {
        boolean requiresRedundancyRecovery;
        boolean movePrimaries;
        long delay;
        final boolean isStartup = failedMemId == null;
        InternalCache cache = this.prRegion.getCache();
        int redundantCopies = this.prRegion.getRedundantCopies();
        if (isStartup) {
            delay = this.prRegion.getPartitionAttributes().getStartupRecoveryDelay();
            movePrimaries = !Boolean.getBoolean("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP");
        } else {
            delay = this.prRegion.getPartitionAttributes().getRecoveryDelay();
            movePrimaries = false;
        }
        boolean bl = requiresRedundancyRecovery = delay >= 0L;
        if (!requiresRedundancyRecovery) {
            return;
        }
        if (!this.prRegion.isDataStore()) {
            return;
        }
        RecoveryRunnable task = new RecoveryRunnable(this){

            @Override
            public void run2() {
                try {
                    boolean isFixedPartitionedRegion = PRHARedundancyProvider.this.prRegion.isFixedPartitionedRegion();
                    boolean replaceOfflineData = isFixedPartitionedRegion || !isStartup;
                    RebalanceDirectorAdapter director = isFixedPartitionedRegion ? new FPRDirector(true, movePrimaries) : new CompositeDirector(true, true, false, movePrimaries);
                    PartitionedRegionRebalanceOp rebalance = new PartitionedRegionRebalanceOp(PRHARedundancyProvider.this.prRegion, false, director, replaceOfflineData, false);
                    long start = PRHARedundancyProvider.this.prRegion.getPrStats().startRecovery();
                    if (isFixedPartitionedRegion) {
                        rebalance.executeFPA();
                    } else {
                        rebalance.execute();
                    }
                    PRHARedundancyProvider.this.prRegion.getPrStats().endRecovery(start);
                    PRHARedundancyProvider.this.recoveryFuture = null;
                }
                catch (CancelException e) {
                    logger.debug("Cache closed while recovery in progress");
                }
                catch (RegionDestroyedException e) {
                    logger.debug("Region destroyed while recovery in progress");
                }
                catch (Exception e) {
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.PRHARedundancyProvider_UNEXPECTED_EXCEPTION_DURING_BUCKET_RECOVERY), (Throwable)e);
                }
            }
        };
        Object object = this.shutdownLock;
        synchronized (object) {
            if (!this.shutdown) {
                try {
                    if (logger.isDebugEnabled()) {
                        if (isStartup) {
                            logger.debug(this.prRegion + " scheduling redundancy recovery in {} ms", (Object)delay);
                        } else {
                            logger.debug("prRegion scheduling redundancy recovery after departure/crash/error in {} in {} ms", failedMemId, (Object)delay);
                        }
                    }
                    this.recoveryFuture = this.recoveryExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isRedundancyImpaired() {
        int numBuckets = this.prRegion.getPartitionAttributes().getTotalNumBuckets();
        int targetRedundancy = this.prRegion.getPartitionAttributes().getRedundantCopies();
        for (int i = 0; i < numBuckets; ++i) {
            int redundancy = this.prRegion.getRegionAdvisor().getBucketRedundancy(i);
            if ((redundancy >= targetRedundancy || redundancy == -1) && redundancy <= targetRedundancy) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverPersistentBuckets() {
        ProxyBucketRegion[] proxyBucketArray;
        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this.prRegion);
        PartitionedRegion persistentLeader = this.getPersistentLeader();
        if (persistentLeader == null) {
            return true;
        }
        if (!ColocationHelper.checkMembersColocation(leaderRegion, leaderRegion.getDistributionManager().getDistributionManagerId())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping persistent recovery of {} because colocation is not complete for {}", (Object)this.prRegion, (Object)leaderRegion);
            }
            return false;
        }
        for (ProxyBucketRegion proxyBucket : proxyBucketArray = persistentLeader.getRegionAdvisor().getProxyBucketArray()) {
            proxyBucket.initializePersistenceAdvisor();
        }
        Set<InternalDistributedMember> peers = this.prRegion.getRegionAdvisor().adviseGeneric();
        MembershipFlushRequest.send(peers, this.prRegion.getDistributionManager(), this.prRegion.getFullPath());
        ArrayList<ProxyBucketRegion> bucketsNotHostedLocally = new ArrayList<ProxyBucketRegion>(proxyBucketArray.length);
        ArrayList<ProxyBucketRegion> bucketsHostedLocally = new ArrayList<ProxyBucketRegion>(proxyBucketArray.length);
        this.allBucketsRecoveredFromDisk = new CountDownLatch(proxyBucketArray.length);
        try {
            if (proxyBucketArray.length > 0) {
                this.redundancyLogger = new RedundancyLogger(this);
                Thread loggingThread = new Thread((Runnable)this.redundancyLogger, "RedundancyLogger for region " + this.prRegion.getName());
                loggingThread.start();
            }
        }
        catch (RuntimeException e) {
            this.allBucketsRecoveredFromDisk = null;
            throw e;
        }
        for (final ProxyBucketRegion proxyBucket : proxyBucketArray) {
            if (proxyBucket.getPersistenceAdvisor().wasHosting()) {
                RecoveryRunnable recoveryRunnable = new RecoveryRunnable(this){

                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        finally {
                            PRHARedundancyProvider.this.allBucketsRecoveredFromDisk.countDown();
                        }
                    }

                    @Override
                    public void run2() {
                        proxyBucket.recoverFromDiskRecursively();
                    }
                };
                Thread recoveryThread = new Thread((Runnable)recoveryRunnable, "Recovery thread for bucket " + proxyBucket.getName());
                recoveryThread.start();
                bucketsHostedLocally.add(proxyBucket);
                continue;
            }
            bucketsNotHostedLocally.add(proxyBucket);
        }
        try {
            for (ProxyBucketRegion proxyBucket : bucketsHostedLocally) {
                proxyBucket.waitForPrimaryPersistentRecovery();
            }
            for (ProxyBucketRegion proxyBucket : bucketsNotHostedLocally) {
                proxyBucket.recoverFromDiskRecursively();
            }
        }
        finally {
            for (ProxyBucketRegion proxyBucket : bucketsNotHostedLocally) {
                this.allBucketsRecoveredFromDisk.countDown();
            }
        }
        return true;
    }

    protected PartitionedRegion getPersistentLeader() {
        PartitionedRegion leader = ColocationHelper.getLeaderRegion(this.prRegion);
        return this.findPersistentRegionRecursively(leader);
    }

    private PartitionedRegion findPersistentRegionRecursively(PartitionedRegion pr) {
        if (pr.getDataPolicy().withPersistence()) {
            return pr;
        }
        for (PartitionedRegion child : ColocationHelper.getColocatedChildRegions(pr)) {
            PartitionedRegion leader = this.findPersistentRegionRecursively(child);
            if (leader == null) continue;
            return leader;
        }
        return null;
    }

    public void scheduleCreateMissingBuckets() {
        if (this.prRegion.getColocatedWith() != null && ColocationHelper.isColocationComplete(this.prRegion)) {
            CreateMissingBucketsTask task = new CreateMissingBucketsTask(this);
            InternalResourceManager resourceManager = this.prRegion.getGemFireCache().getInternalResourceManager();
            resourceManager.getExecutor().execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            ScheduledFuture<?> recoveryFuture = this.recoveryFuture;
            if (recoveryFuture != null) {
                recoveryFuture.cancel(false);
                this.recoveryExecutor.purge();
            }
        }
    }

    public InternalPRInfo buildPartitionedRegionInfo(boolean internal, LoadProbe loadProbe) {
        PartitionedRegion pr = this.prRegion;
        if (pr == null) {
            return null;
        }
        PartitionedRegionStats prStats = pr.getPrStats();
        int configuredBucketCount = pr.getTotalNumberOfBuckets();
        int createdBucketCount = pr.getRegionAdvisor().getCreatedBucketsCount();
        int lowRedundancyBucketCount = prStats.getLowRedundancyBucketCount();
        int configuredRedundantCopies = pr.getRedundantCopies();
        int actualRedundantCopies = prStats.getActualRedundantCopies();
        PartitionedRegionDataStore ds = pr.getDataStore();
        Set<InternalDistributedMember> datastores = pr.getRegionAdvisor().adviseDataStore();
        TreeSet<InternalPartitionDetails> memberDetails = new TreeSet<InternalPartitionDetails>();
        OfflineMemberDetails offlineMembers = null;
        boolean fetchOfflineMembers = false;
        if (ds != null) {
            memberDetails.add(this.buildPartitionMemberDetails(internal, loadProbe));
            offlineMembers = this.fetchOfflineMembers();
        } else {
            fetchOfflineMembers = true;
        }
        if (!datastores.isEmpty()) {
            FetchPartitionDetailsMessage.FetchPartitionDetailsResponse response = FetchPartitionDetailsMessage.send(datastores, pr, internal, fetchOfflineMembers, loadProbe);
            memberDetails.addAll(response.waitForResponse());
            if (fetchOfflineMembers) {
                offlineMembers = response.getOfflineMembers();
            }
        }
        String colocatedWithPath = pr.getColocatedWith();
        PartitionRegionInfoImpl details = new PartitionRegionInfoImpl(pr.getFullPath(), configuredBucketCount, createdBucketCount, lowRedundancyBucketCount, configuredRedundantCopies, actualRedundantCopies, memberDetails, colocatedWithPath, offlineMembers);
        return details;
    }

    public OfflineMemberDetailsImpl fetchOfflineMembers() {
        ProxyBucketRegion[] proxyBuckets = this.prRegion.getRegionAdvisor().getProxyBucketArray();
        Set[] offlineMembers = new Set[proxyBuckets.length];
        for (int i = 0; i < proxyBuckets.length; ++i) {
            ProxyBucketRegion proxy = proxyBuckets[i];
            if (this.prRegion.getDataPolicy().withPersistence()) {
                Set<PersistentMemberID> persistedMembers = proxy.getPersistenceAdvisor().getMissingMembers();
                if (persistedMembers == null) {
                    persistedMembers = Collections.emptySet();
                }
                offlineMembers[i] = persistedMembers;
                continue;
            }
            offlineMembers[i] = Collections.emptySet();
        }
        return new OfflineMemberDetailsImpl(offlineMembers);
    }

    public InternalPartitionDetails buildPartitionMemberDetails(boolean internal, LoadProbe loadProbe) {
        PartitionedRegion pr = this.prRegion;
        PartitionedRegionDataStore ds = pr.getDataStore();
        if (ds == null) {
            return null;
        }
        PartitionMemberInfoImpl localDetails = null;
        long size = 0L;
        InternalDistributedMember localMember = pr.getMyId();
        int configuredBucketCount = pr.getTotalNumberOfBuckets();
        long[] bucketSizes = new long[configuredBucketCount];
        Map bucketSizeMap = ds.getSizeLocally();
        for (Map.Entry me : bucketSizeMap.entrySet()) {
            long bucketSize;
            int bid = (Integer)me.getKey();
            bucketSizes[bid] = bucketSize = ds.getBucketSize(bid);
            size += bucketSize;
        }
        if (internal) {
            this.waitForPersistentBucketRecoveryOrClose();
            PRLoad prLoad = loadProbe.getLoad(pr);
            localDetails = new PartitionMemberInfoImpl(localMember, (long)pr.getLocalMaxMemory() * 0x100000L, size, ds.getBucketsManaged(), ds.getNumberOfPrimaryBucketsManaged(), prLoad, bucketSizes);
        } else {
            localDetails = new PartitionMemberInfoImpl(localMember, (long)pr.getLocalMaxMemory() * 0x100000L, size, ds.getBucketsManaged(), ds.getNumberOfPrimaryBucketsManaged());
        }
        return localDetails;
    }

    protected void waitForPersistentBucketRecoveryOrClose() {
        CountDownLatch recoveryLatch = this.allBucketsRecoveredFromDisk;
        if (recoveryLatch != null) {
            boolean interrupted = false;
            while (true) {
                try {
                    boolean done;
                    do {
                        this.prRegion.getCancelCriterion().checkCancelInProgress(null);
                    } while (!(done = recoveryLatch.await(100L, TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        List<PartitionedRegion> colocatedRegions = ColocationHelper.getColocatedChildRegions(this.prRegion);
        for (PartitionedRegion child : colocatedRegions) {
            child.getRedundancyProvider().waitForPersistentBucketRecoveryOrClose();
        }
    }

    protected void waitForPersistentBucketRecovery() {
        CountDownLatch recoveryLatch = this.allBucketsRecoveredFromDisk;
        if (recoveryLatch != null) {
            boolean interrupted = false;
            while (true) {
                try {
                    recoveryLatch.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isPersistentRecoveryComplete() {
        if (!ColocationHelper.checkMembersColocation(this.prRegion, this.prRegion.getMyId())) {
            return false;
        }
        if (this.allBucketsRecoveredFromDisk != null && this.allBucketsRecoveredFromDisk.getCount() > 0L) {
            return false;
        }
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(this.prRegion);
        for (PartitionedRegion region : colocatedRegions.values()) {
            PRHARedundancyProvider redundancyProvider = region.getRedundancyProvider();
            if (redundancyProvider.allBucketsRecoveredFromDisk == null || redundancyProvider.allBucketsRecoveredFromDisk.getCount() <= 0L) continue;
            return false;
        }
        return true;
    }

    public CountDownLatch getAllBucketsRecoveredFromDiskLatch() {
        return this.allBucketsRecoveredFromDisk;
    }

    static {
        forceLocalPrimaries = new ThreadLocal();
    }

    protected class PRPersistenceListener
    extends PersistentStateListener.PersistentStateAdapter {
        protected PRPersistenceListener() {
        }

        @Override
        public void memberRemoved(PersistentMemberID persistentID, boolean revoked) {
            if (!revoked) {
                return;
            }
            InternalDistributedMember dmem = PRHARedundancyProvider.this.prRegion.getSystem().getDistributedMember();
            if (logger.isDebugEnabled()) {
                logger.debug("Persistent Membership Listener invoked on DistributedMember = {} for removed memberId = {}", (Object)dmem, (Object)persistentID);
            }
            if (!(PRHARedundancyProvider.this.prRegion.isCacheClosing() || PRHARedundancyProvider.this.prRegion.isDestroyed() || PRHARedundancyProvider.this.prRegion.isFixedPartitionedRegion())) {
                PRHARedundancyProvider.this.scheduleRedundancyRecovery(persistentID);
            }
        }
    }

    protected class PRMembershipListener
    implements MembershipListener {
        protected PRMembershipListener() {
        }

        @Override
        public void memberDeparted(final InternalDistributedMember id, boolean crashed) {
            try {
                InternalDistributedMember dmem = PRHARedundancyProvider.this.prRegion.getSystem().getDistributedMember();
                if (logger.isDebugEnabled()) {
                    logger.debug("MembershipListener invoked on DistributedMember = {} for failed memberId = {}", (Object)dmem, (Object)id);
                }
                if (!(PRHARedundancyProvider.this.prRegion.isCacheClosing() || PRHARedundancyProvider.this.prRegion.isDestroyed() || ((Object)dmem).equals(id))) {
                    Runnable postRecoveryTask = null;
                    if (!PRHARedundancyProvider.this.prRegion.isFixedPartitionedRegion()) {
                        postRecoveryTask = new Runnable(){

                            @Override
                            public void run() {
                                PRHARedundancyProvider.this.scheduleRedundancyRecovery(id);
                            }
                        };
                    }
                    PartitionedRegionHelper.cleanUpMetaDataForRegion(PRHARedundancyProvider.this.prRegion.getCache(), PRHARedundancyProvider.this.prRegion.getRegionIdentifier(), id, postRecoveryTask);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }

    private class BucketMembershipObserver
    implements MembershipListener {
        final Bucket bucketToMonitor;
        final AtomicInteger arrivals = new AtomicInteger(0);
        final AtomicBoolean departures = new AtomicBoolean(false);

        public BucketMembershipObserver(Bucket b) {
            this.bucketToMonitor = b;
        }

        public BucketMembershipObserver beginMonitoring() {
            int profilesPresent = this.bucketToMonitor.getBucketAdvisor().addMembershipListenerAndAdviseGeneric(this).size();
            this.arrivals.addAndGet(profilesPresent);
            return this;
        }

        public void stopMonitoring() {
            this.bucketToMonitor.getBucketAdvisor().removeMembershipListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberJoined(InternalDistributedMember id) {
            if (logger.isDebugEnabled()) {
                logger.debug("Observer for bucket {} member joined {}", (Object)this.bucketToMonitor, (Object)id);
            }
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                this.arrivals.addAndGet(1);
                this.notify();
            }
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (logger.isDebugEnabled()) {
                logger.debug("Observer for bucket {} member departed {}", (Object)this.bucketToMonitor, (Object)id);
            }
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                this.departures.getAndSet(true);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BucketMembershipObserverResults waitForOwnersGetPrimary(int expectedCount, Collection<InternalDistributedMember> expectedOwners, String partitionName) throws InterruptedException {
            boolean problematicDeparture = false;
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                while (true) {
                    this.bucketToMonitor.getCancelCriterion().checkCancelInProgress(null);
                    boolean oldDepartures = this.departures.get();
                    if (oldDepartures) {
                        PRHARedundancyProvider.this.verifyBucketNodes(expectedOwners, partitionName);
                        if (expectedOwners.isEmpty()) {
                            problematicDeparture = true;
                        }
                        this.arrivals.set(expectedOwners.size());
                        this.departures.set(false);
                        if (!problematicDeparture || !logger.isDebugEnabled()) break;
                        logger.debug("Bucket observer found departed members - retrying");
                        break;
                    }
                    int oldArrivals = this.arrivals.get();
                    if (oldArrivals >= expectedCount) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for bucket {} to finish being created", (Object)PRHARedundancyProvider.this.prRegion.bucketStringForLogs(this.bucketToMonitor.getId()));
                    }
                    PRHARedundancyProvider.this.prRegion.checkReadiness();
                    int creationWaitMillis = 5000;
                    this.wait(5000L);
                    if (oldArrivals != this.arrivals.get() || oldDepartures != this.departures.get()) continue;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PRHARedundancyProvider_TIME_OUT_WAITING_0_MS_FOR_CREATION_OF_BUCKET_FOR_PARTITIONED_REGION_1_MEMBERS_REQUESTED_TO_CREATE_THE_BUCKET_ARE_2, new Object[]{5000, PRHARedundancyProvider.this.prRegion.getFullPath(), expectedOwners}));
                }
            }
            if (problematicDeparture) {
                return new BucketMembershipObserverResults(true, null);
            }
            InternalDistributedMember primmy = this.bucketToMonitor.getBucketAdvisor().getPrimary();
            if (primmy == null) {
                return new BucketMembershipObserverResults(true, null);
            }
            return new BucketMembershipObserverResults(false, primmy);
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }

    private static class BucketMembershipObserverResults {
        final boolean problematicDeparture;
        final InternalDistributedMember primary;

        BucketMembershipObserverResults(boolean re, InternalDistributedMember p) {
            this.problematicDeparture = re;
            this.primary = p;
        }

        public String toString() {
            return "pDepart:" + this.problematicDeparture + " primary:" + this.primary;
        }
    }

    private static class ManageBucketRsp {
        static final ManageBucketRsp NO = new ManageBucketRsp("NO");
        static final ManageBucketRsp YES = new ManageBucketRsp("YES");
        static final ManageBucketRsp NO_INITIALIZING = new ManageBucketRsp("NO_INITIALIZING");
        public static final ManageBucketRsp CLOSED = new ManageBucketRsp("CLOSED");
        private final String name;

        private ManageBucketRsp(String name) {
            this.name = name;
        }

        boolean isRejection() {
            return this == NO || this == NO_INITIALIZING || this == CLOSED;
        }

        boolean isAcceptance() {
            return this == YES;
        }

        boolean isInitializing() {
            return this == NO_INITIALIZING;
        }

        public String toString() {
            return "ManageBucketRsp(" + this.name + ")";
        }

        static ManageBucketRsp valueOf(boolean managed) {
            return managed ? YES : NO;
        }
    }

    public static class DataStoreBuckets {
        public final InternalDistributedMember memberId;
        public final int numBuckets;
        public final int numPrimaries;
        private final int localMaxMemoryMB;

        public DataStoreBuckets(InternalDistributedMember mem, int buckets, int primaryBuckets, int localMaxMemory) {
            this.memberId = mem;
            this.numBuckets = buckets;
            this.numPrimaries = primaryBuckets;
            this.localMaxMemoryMB = localMaxMemory;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof DataStoreBuckets)) {
                return false;
            }
            DataStoreBuckets other = (DataStoreBuckets)obj;
            return this.numBuckets == other.numBuckets && this.memberId.equals(other.memberId);
        }

        public int hashCode() {
            return this.memberId.hashCode();
        }

        public String toString() {
            return "DataStoreBuckets memberId=" + this.memberId + "; numBuckets=" + this.numBuckets + "; numPrimaries=" + this.numPrimaries;
        }
    }

    public static interface EndBucketCreationObserver {
        public void afterEndBucketCreationMessageSend(PartitionedRegion var1, int var2);

        public void afterEndBucketCreation(PartitionedRegion var1, int var2);
    }

    public static class ArrayListWithClearState<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        private boolean wasCleared = false;

        public boolean wasCleared() {
            return this.wasCleared;
        }

        @Override
        public void clear() {
            super.clear();
            this.wasCleared = true;
        }
    }
}

