/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.persistence.DiskExceptionHandler;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;

public class OfflineCompactionDiskRegion
extends DiskRegion
implements DiskRecoveryStore {
    private OfflineCompactionDiskRegion(DiskStoreImpl ds, DiskRegionView drv) {
        super(ds, drv.getName(), drv.isBucket(), true, false, true, new DiskRegionStats(ds.getCache().getDistributedSystem(), drv.getName()), new DummyCancelCriterion(), new DummyDiskExceptionHandler(), null, drv.getFlags(), drv.getPartitionName(), drv.getStartingBucketId(), drv.getCompressorClassName(), drv.getOffHeap());
        this.setConfig(drv.getLruAlgorithm(), drv.getLruAction(), drv.getLruLimit(), drv.getConcurrencyLevel(), drv.getInitialCapacity(), drv.getLoadFactor(), drv.getStatisticsEnabled(), drv.isBucket(), drv.getFlags(), drv.getPartitionName(), drv.getStartingBucketId(), drv.getCompressorClassName(), drv.getOffHeap());
    }

    static OfflineCompactionDiskRegion create(DiskStoreImpl dsi, DiskRegionView drv) {
        assert (dsi != null);
        OfflineCompactionDiskRegion result = new OfflineCompactionDiskRegion(dsi, drv);
        result.register();
        return result;
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this;
    }

    @Override
    public DiskEntry getDiskEntry(Object key) {
        return null;
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        throw new IllegalStateException("updateRecoveredEntry should not be called when offline compacting");
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        throw new IllegalStateException("updateRecoveredEntry should not be called when offline compacting");
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
    }

    @Override
    public void foreachRegionEntry(LocalRegion.RegionEntryCallback callback) {
        throw new IllegalStateException("foreachRegionEntry should not be called when offline compacting");
    }

    @Override
    public boolean lruLimitExceeded() {
        return false;
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        throw new IllegalStateException("copyRecoveredEntries should not be called on OfflineCompactionDiskRegion");
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newSize, int bytesOnDisk) {
        throw new IllegalStateException("updateSizeOnFaultIn should not be called on OfflineCompactionDiskRegion");
    }

    @Override
    public int calculateValueSize(Object val) {
        return 0;
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry re) {
        return 0;
    }

    @Override
    public RegionMap getRegionMap() {
        throw new IllegalStateException("getRegionMap should not be called on OfflineCompactionDiskRegion");
    }

    @Override
    public void handleDiskAccessException(DiskAccessException dae) {
        throw new IllegalStateException("handleDiskAccessException should not be called on OfflineCompactionDiskRegion");
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        throw new IllegalStateException("initializeStats should not be called on OfflineCompactionDiskRegion");
    }

    private static class DummyCancelCriterion
    extends CancelCriterion {
        private DummyCancelCriterion() {
        }

        @Override
        public String cancelInProgress() {
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            return new RuntimeException(e);
        }
    }

    public static class DummyDiskExceptionHandler
    implements DiskExceptionHandler {
        @Override
        public void handleDiskAccessException(DiskAccessException dae) {
        }

        public boolean shouldStopServer() {
            return false;
        }
    }
}

