/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class FindRemoteTXMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private TXId txId;
    private int processorId;

    public FindRemoteTXMessage() {
    }

    public FindRemoteTXMessage(TXId txid, int processorId, Set recipients) {
        this.setRecipients(recipients);
        this.txId = txid;
        this.processorId = processorId;
    }

    public static FindRemoteTXMessageReplyProcessor send(Cache cache, TXId txId) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DM dm = system.getDistributionManager();
        Set recipients = dm.getOtherDistributionManagerIds();
        FindRemoteTXMessageReplyProcessor processor = new FindRemoteTXMessageReplyProcessor(dm, (Collection)recipients, txId);
        FindRemoteTXMessage msg = new FindRemoteTXMessage(txId, processor.getProcessorId(), recipients);
        dm.putOutgoing(msg);
        return processor;
    }

    @Override
    public int getDSFID() {
        return -40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        boolean sendReply = true;
        Throwable thr = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("processing {}", (Object)this);
            }
            FindRemoteTXMessageReply reply = new FindRemoteTXMessageReply();
            InternalCache cache = dm.getCache();
            if (cache != null) {
                TXManagerImpl mgr = (TXManagerImpl)cache.getCacheTransactionManager();
                mgr.waitForCompletingTransaction(this.txId);
                boolean bl = reply.isHostingTx = mgr.isHostedTxInProgress(this.txId) || mgr.isHostedTxRecentlyCompleted(this.txId);
                if (!reply.isHostingTx) {
                    TXCommitMessage partialMessage = TXCommitMessage.getTracker().getTXCommitMessage(this.txId);
                    if (partialMessage != null) {
                        reply.txCommitMessage = partialMessage;
                        reply.isPartialCommitMessage = true;
                    }
                    mgr.removeHostedTXState(this.txId);
                }
            }
            reply.setRecipient(this.getSender());
            reply.setProcessorId(this.processorId);
            this.getReplySender(dm).putOutgoing(reply);
            sendReply = false;
            if (logger.isDebugEnabled()) {
                logger.debug("TX: FoundRemoteTXMessage: isHostingTx for txid:{}? {} isPartialCommit? {}", (Object)this.txId, (Object)reply.isHostingTx, (Object)reply.isPartialCommitMessage);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (sendReply) {
                thr = t;
            }
        }
        finally {
            ReplySender rs = this.getReplySender(dm);
            if (sendReply && (this.processorId != 0 || rs != dm)) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                ReplyMessage.send(this.getSender(), this.processorId, rex, this.getReplySender(dm));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(".cache.") + ".cache.".length()));
        buff.append("(txId=").append(this.txId).append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId);
        buff.append(")");
        return buff.toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.txId, out);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.txId = (TXId)DataSerializer.readObject(in);
        this.processorId = in.readInt();
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public static class FindRemoteTXMessageReply
    extends ReplyMessage {
        protected boolean isHostingTx;
        protected boolean isPartialCommitMessage;
        protected TXCommitMessage txCommitMessage;

        @Override
        public int getDSFID() {
            return -41;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.isHostingTx);
            boolean sendTXCommitMessage = this.txCommitMessage != null;
            out.writeBoolean(sendTXCommitMessage);
            if (sendTXCommitMessage) {
                out.writeBoolean(this.isPartialCommitMessage);
                this.txCommitMessage.setClientVersion(null);
                InternalDataSerializer.writeDSFID(this.txCommitMessage, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.isHostingTx = in.readBoolean();
            if (in.readBoolean()) {
                this.isPartialCommitMessage = in.readBoolean();
                this.txCommitMessage = (TXCommitMessage)InternalDataSerializer.readDSFID(in);
            }
        }
    }

    public static class FindRemoteTXMessageReplyProcessor
    extends ReplyProcessor21 {
        private InternalDistributedMember hostingMember;
        private TXCommitMessage txCommit;
        private TXId txId;
        private Set<TXCommitMessage> partialCommitMessages = new HashSet<TXCommitMessage>();

        public FindRemoteTXMessageReplyProcessor(DM dm, Collection initMembers, TXId txId) {
            super(dm, initMembers);
            this.txId = txId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof FindRemoteTXMessageReply) {
                FindRemoteTXMessageReply reply = (FindRemoteTXMessageReply)msg;
                if (reply.isHostingTx) {
                    this.hostingMember = msg.getSender();
                } else if (reply.isPartialCommitMessage) {
                    this.partialCommitMessages.add(reply.txCommitMessage);
                }
            }
            super.process(msg);
        }

        public InternalDistributedMember getHostingMember() {
            return this.hostingMember;
        }

        @Override
        public boolean stillWaiting() {
            return this.hostingMember == null && super.stillWaiting();
        }

        public TXCommitMessage getTxCommitMessage() {
            if (this.txCommit != null) {
                return this.txCommit;
            }
            if (!this.partialCommitMessages.isEmpty()) {
                TXCommitMessage localTXMessage = TXCommitMessage.getTracker().getTXCommitMessage(this.txId);
                if (localTXMessage != null) {
                    this.partialCommitMessages.add(localTXMessage);
                }
                this.txCommit = TXCommitMessage.combine(this.partialCommitMessages);
            }
            return this.txCommit;
        }
    }
}

