/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.EvictionAttributesMutator;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.eviction.CountLRUEviction;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.HeapLRUController;
import org.apache.geode.internal.cache.eviction.MemoryLRUController;

public class EvictionAttributesImpl
extends EvictionAttributes
implements EvictionAttributesMutator {
    private static final long serialVersionUID = -6404395520499379715L;
    private EvictionAlgorithm algorithm = EvictionAlgorithm.NONE;
    private ObjectSizer sizer;
    private volatile int maximum;
    private EvictionAction action = EvictionAction.NONE;
    private volatile EvictionController evictionController;

    public EvictionAttributesImpl() {
    }

    public EvictionAttributesImpl(EvictionAttributesImpl other) {
        this.algorithm = other.algorithm;
        this.sizer = other.sizer;
        this.maximum = other.maximum;
        this.action = other.action;
    }

    public EvictionAttributesImpl setAlgorithm(EvictionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public EvictionAttributesImpl setObjectSizer(ObjectSizer memorySizer) {
        this.sizer = memorySizer;
        return this;
    }

    @Override
    public ObjectSizer getObjectSizer() {
        return this.sizer;
    }

    @Override
    public EvictionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setMaximum(int maximum) {
        this.maximum = maximum;
        if (this.evictionController != null) {
            this.evictionController.setLimit(this.maximum);
        }
    }

    public EvictionAttributesImpl internalSetMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public int getMaximum() {
        if (this.algorithm.isLRUHeap()) {
            throw new UnsupportedOperationException("LRUHeap does not support a maximum");
        }
        return this.maximum;
    }

    public EvictionAttributesImpl setAction(EvictionAction action) {
        this.action = action != null ? action : EvictionAction.NONE;
        return this;
    }

    @Override
    public EvictionAction getAction() {
        return this.action;
    }

    public EvictionController createEvictionController(Region region, boolean isOffHeap) {
        this.evictionController = this.algorithm == EvictionAlgorithm.LRU_ENTRY ? new CountLRUEviction(this.maximum, this.action, region) : (this.algorithm == EvictionAlgorithm.LRU_HEAP ? new HeapLRUController(this.action, region, this.sizer) : (this.algorithm == EvictionAlgorithm.LRU_MEMORY ? new MemoryLRUController(this.maximum, this.sizer, this.action, region, isOffHeap) : (this.algorithm == EvictionAlgorithm.LIFO_ENTRY ? new CountLRUEviction(this.maximum, this.action, region) : (this.algorithm == EvictionAlgorithm.LIFO_MEMORY ? new MemoryLRUController(this.maximum, this.sizer, this.action, region, isOffHeap) : null))));
        return this.evictionController;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.maximum);
        DataSerializer.writeObject(this.action, out);
        DataSerializer.writeObject(this.algorithm, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.maximum = in.readInt();
        this.action = (EvictionAction)DataSerializer.readObject(in);
        this.algorithm = (EvictionAlgorithm)DataSerializer.readObject(in);
    }

    public static EvictionAttributesImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        EvictionAttributesImpl result = new EvictionAttributesImpl();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    public boolean isLIFO() {
        return this.algorithm.isLIFO();
    }

    public boolean isLIFOEntry() {
        return this.algorithm == EvictionAlgorithm.LIFO_ENTRY;
    }

    public boolean isLIFOMemory() {
        return this.algorithm == EvictionAlgorithm.LIFO_MEMORY;
    }
}

