/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;

public class EventStateHelper {
    public static void dataSerialize(DataOutput dop, Map eventState, boolean isHARegion) throws IOException {
        InternalDistributedMember myId = InternalDistributedSystem.getAnyInstance().getDistributedMember();
        Map<MemberIdentifier, Map<ThreadIdentifier, Object>> groupedThreadIds = EventStateHelper.groupThreadIds(eventState);
        LinkedList<MemberIdentifier> orderedIds = new LinkedList<MemberIdentifier>();
        HashMap<MemberIdentifier, Integer> seenIds = new HashMap<MemberIdentifier, Integer>();
        myId.writeEssentialData(dop);
        for (MemberIdentifier memberIdentifier : groupedThreadIds.keySet()) {
            if (seenIds.containsKey(memberIdentifier)) continue;
            orderedIds.add(memberIdentifier);
            seenIds.put(memberIdentifier, seenIds.size());
        }
        dop.writeInt(seenIds.size());
        for (MemberIdentifier memberIdentifier : orderedIds) {
            DataSerializer.writeByteArray(memberIdentifier.bytes, dop);
        }
        dop.writeInt(groupedThreadIds.size());
        for (Map.Entry entry : groupedThreadIds.entrySet()) {
            MemberIdentifier memberId = (MemberIdentifier)entry.getKey();
            dop.writeInt((Integer)seenIds.get(memberId));
            Map threadIdMap = (Map)entry.getValue();
            dop.writeInt(threadIdMap.size());
            Iterator iterator = threadIdMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Serializable value;
                Map.Entry next;
                Map.Entry entry2 = next = iterator.next();
                ThreadIdentifier key = (ThreadIdentifier)entry2.getKey();
                dop.writeLong(key.getThreadID());
                if (isHARegion) {
                    value = (HARegionQueue.DispatchedAndCurrentEvents)entry2.getValue();
                    InternalDataSerializer.invokeToData(value, dop);
                    continue;
                }
                value = (EventSequenceNumberHolder)entry2.getValue();
                InternalDataSerializer.invokeToData(value, dop);
            }
        }
    }

    public static Map deDataSerialize(DataInput dip, boolean isHARegion) throws IOException, ClassNotFoundException {
        InternalDistributedMember senderId = InternalDistributedMember.readEssentialData(dip);
        int numIds = dip.readInt();
        HashMap<Integer, byte[]> numberToMember = new HashMap<Integer, byte[]>();
        for (int i = 0; i < numIds; ++i) {
            numberToMember.put(i, DataSerializer.readByteArray(dip));
        }
        int size = dip.readInt();
        HashMap<ThreadIdentifier, Serializable> eventState = new HashMap<ThreadIdentifier, Serializable>(size);
        for (int i = 0; i < size; ++i) {
            int idNumber = dip.readInt();
            int subMapSize = dip.readInt();
            for (int j = 0; j < subMapSize; ++j) {
                Serializable value;
                long threadId = dip.readLong();
                ThreadIdentifier key = new ThreadIdentifier((byte[])numberToMember.get(idNumber), threadId);
                if (isHARegion) {
                    value = new HARegionQueue.DispatchedAndCurrentEvents();
                    InternalDataSerializer.invokeFromData(value, dip);
                    eventState.put(key, value);
                    continue;
                }
                value = new EventSequenceNumberHolder();
                InternalDataSerializer.invokeFromData(value, dip);
                eventState.put(key, value);
                if (((EventSequenceNumberHolder)value).getVersionTag() == null) continue;
                ((EventSequenceNumberHolder)value).getVersionTag().replaceNullIDs(senderId);
            }
        }
        return eventState;
    }

    private static Map<MemberIdentifier, Map<ThreadIdentifier, Object>> groupThreadIds(Map eventState) {
        HashMap<MemberIdentifier, Map<ThreadIdentifier, Object>> results = new HashMap<MemberIdentifier, Map<ThreadIdentifier, Object>>();
        Iterator iterator = eventState.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next;
            Map.Entry entry = next = iterator.next();
            ThreadIdentifier key = (ThreadIdentifier)entry.getKey();
            MemberIdentifier memberId = new MemberIdentifier(key.getMembershipID());
            Object value = entry.getValue();
            HashMap subMap = (HashMap)results.get(memberId);
            if (subMap == null) {
                subMap = new HashMap();
                results.put(memberId, subMap);
            }
            subMap.put(key, value);
        }
        return results;
    }

    private static class MemberIdentifier {
        private final byte[] bytes;

        public MemberIdentifier(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MemberIdentifier)) {
                return false;
            }
            MemberIdentifier other = (MemberIdentifier)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

