/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DistPeerTXStateStub;
import org.apache.geode.internal.cache.DistTXCommitMessage;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXPrecommitMessage;
import org.apache.geode.internal.cache.DistTXRollbackMessage;
import org.apache.geode.internal.cache.DistTXStateOnCoordinator;
import org.apache.geode.internal.cache.DistTXStateProxyImpl;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.DistClientTXStateStub;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.message.Message;

public class DistTXStateProxyImplOnCoordinator
extends DistTXStateProxyImpl {
    protected HashMap<DistributedMember, DistTXCoordinatorInterface> target2realDeals = new HashMap();
    private HashMap<LocalRegion, DistributedMember> rrTargets;
    private Set<DistributedMember> txRemoteParticpants = null;
    protected HashMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> txEntryEventMap = null;

    public DistTXStateProxyImplOnCoordinator(TXManagerImpl managerImpl, TXId id, InternalDistributedMember clientMember) {
        super(managerImpl, id, clientMember);
    }

    public DistTXStateProxyImplOnCoordinator(TXManagerImpl managerImpl, TXId id, boolean isjta) {
        super(managerImpl, id, isjta);
    }

    @Override
    public void commit() throws CommitConflictException {
        boolean preserveTx = false;
        boolean precommitResult = false;
        try {
            HashMap<DistributedMember, DistTXCoordinatorInterface> otherTargets2realDeals = this.getSecondariesAndReplicasForTxOps();
            this.target2realDeals.putAll(otherTargets2realDeals);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.commit target2realDeals = " + this.target2realDeals);
            }
            if (precommitResult = this.doPrecommit()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.commit Going for commit ");
                }
                boolean phase2commitDone = this.doCommit();
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.commit Commit " + (phase2commitDone ? "Done" : "Failed"));
                }
                if (!phase2commitDone) {
                    throw new TransactionInDoubtException(LocalizedStrings.ClientTXStateStub_COMMIT_FAILED_ON_SERVER.toLocalizedString());
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.commit precommitResult = " + precommitResult);
            }
        }
        catch (CommitConflictException e) {
            throw e;
        }
        catch (UnsupportedOperationInTransactionException e) {
            preserveTx = true;
            throw e;
        }
        finally {
            if (!precommitResult) {
                this.rollback();
            }
            this.inProgress = preserveTx;
            if (this.synchRunnable != null) {
                this.synchRunnable.abort();
            }
        }
    }

    private HashMap<DistributedMember, DistTXCoordinatorInterface> getSecondariesAndReplicasForTxOps() {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("getSecondariesAndReplicasForTxOps");
        InternalDistributedMember currentNode = cache.getInternalDistributedSystem().getDistributedMember();
        HashMap<DistributedMember, DistTXCoordinatorInterface> secondaryTarget2realDeals = new HashMap<DistributedMember, DistTXCoordinatorInterface>();
        for (Map.Entry<DistributedMember, DistTXCoordinatorInterface> e : this.target2realDeals.entrySet()) {
            DistributedMember originalTarget = e.getKey();
            DistTXCoordinatorInterface distPeerTxStateStub = e.getValue();
            ArrayList<DistTxEntryEvent> primaryTxOps = distPeerTxStateStub.getPrimaryTransactionalOperations();
            for (DistTxEntryEvent dtop : primaryTxOps) {
                LocalRegion lr = dtop.getRegion();
                Set<InternalDistributedMember> otherNodes = null;
                if (lr instanceof PartitionedRegion) {
                    Set<InternalDistributedMember> allNodes = ((PartitionedRegion)dtop.getRegion()).getRegionAdvisor().getBucketOwners(dtop.getKeyInfo().getBucketId());
                    allNodes.remove(originalTarget);
                    otherNodes = allNodes;
                } else if (lr instanceof DistributedRegion) {
                    otherNodes = ((DistributedRegion)lr).getCacheDistributionAdvisor().adviseInitializedReplicates();
                    otherNodes.remove(originalTarget);
                }
                if (otherNodes == null) continue;
                for (InternalDistributedMember dm : otherNodes) {
                    DistTXCoordinatorInterface existingDistPeerTXStateStub = this.target2realDeals.get(dm);
                    if (existingDistPeerTXStateStub == null) {
                        existingDistPeerTXStateStub = secondaryTarget2realDeals.get(dm);
                        if (existingDistPeerTXStateStub == null) {
                            DistTXCoordinatorInterface newTxStub = null;
                            newTxStub = currentNode.equals(dm) ? new DistTXStateOnCoordinator(this, false) : new DistPeerTXStateStub(this, dm, this.onBehalfOfClientMember);
                            newTxStub.addSecondaryTransactionalOperations(dtop);
                            secondaryTarget2realDeals.put(dm, newTxStub);
                            continue;
                        }
                        existingDistPeerTXStateStub.addSecondaryTransactionalOperations(dtop);
                        continue;
                    }
                    existingDistPeerTXStateStub.addSecondaryTransactionalOperations(dtop);
                }
            }
        }
        return secondaryTarget2realDeals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator.rollback Going for rollback ");
        }
        boolean finalResult = false;
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("Applying Dist TX Rollback");
        DM dm = cache.getDistributionManager();
        try {
            Set<DistributedMember> txRemoteParticpants = this.getTxRemoteParticpants(dm);
            DistTXRollbackMessage.DistTxRollbackReplyProcessor processor = new DistTXRollbackMessage.DistTxRollbackReplyProcessor(this.getTxId(), dm, txRemoteParticpants, this.target2realDeals);
            processor.enableSevereAlertProcessing();
            DistTXRollbackMessage rollbackMsg = new DistTXRollbackMessage(this.getTxId(), this.onBehalfOfClientMember, (ReplyProcessor21)processor);
            for (DistributedMember remoteNode : txRemoteParticpants) {
                DistTXCoordinatorInterface remoteTXStateStub = this.target2realDeals.get(remoteNode);
                if (remoteTXStateStub.isTxState()) {
                    throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistPeerTXStateStub", remoteTXStateStub.getClass().getSimpleName()));
                }
                try {
                    remoteTXStateStub.setRollbackMessage(rollbackMsg, dm);
                    remoteTXStateStub.rollback();
                }
                finally {
                    remoteTXStateStub.setRollbackMessage(null, null);
                    remoteTXStateStub.finalCleanup();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("DistTXStateProxyImplOnCoordinator.rollback target = " + remoteNode);
            }
            DistTXCoordinatorInterface localTXState = this.target2realDeals.get(dm.getId());
            if (localTXState != null) {
                if (!localTXState.isTxState()) {
                    throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateOnCoordinator", localTXState.getClass().getSimpleName()));
                }
                localTXState.rollback();
                boolean localResult = localTXState.getRollbackResponse();
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.rollback local = " + dm.getId() + " ,result= " + localResult + " ,finalResult-old= " + finalResult);
                }
                finalResult = finalResult && localResult;
            }
            dm.getCancelCriterion().checkCancelInProgress(null);
            processor.waitForPrecommitCompletion();
            Map<DistributedMember, Boolean> remoteResults = processor.getRollbackResponseMap();
            for (Map.Entry<DistributedMember, Boolean> e : remoteResults.entrySet()) {
                DistributedMember target = e.getKey();
                Boolean remoteResult = e.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.rollback target = " + target + " ,result= " + remoteResult + " ,finalResult-old= " + finalResult);
                }
                finalResult = finalResult && remoteResult != false;
            }
        }
        finally {
            this.inProgress = false;
            if (this.synchRunnable != null) {
                this.synchRunnable.abort();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator.rollback finalResult= " + finalResult);
        }
    }

    @Override
    public TXStateInterface getRealDeal(KeyInfo key, LocalRegion r) {
        if (r != null) {
            this.target = null;
            r.waitOnInitialization(r.initializationLatchBeforeGetInitialImage);
            this.target = r instanceof PartitionedRegion ? this.getOwnerForKey(r, key) : (r instanceof BucketRegion ? ((BucketRegion)r).getBucketAdvisor().getPrimary() : this.getRRTarget(key, r));
            this.realDeal = this.target2realDeals.get(this.target);
        }
        if (this.realDeal == null) {
            if (r == null) {
                this.realDeal = new DistTXStateOnCoordinator(this, false);
                this.target = this.txMgr.getDM().getId();
            } else if (r.hasServerProxy()) {
                this.realDeal = new DistClientTXStateStub(this, this.target, r);
                if (r.scope.isDistributed() && txDistributedClientWarningIssued.compareAndSet(false, true)) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TXStateProxyImpl_Distributed_Region_In_Client_TX, r.getFullPath()));
                }
            } else {
                this.realDeal = this.target == null || this.target.equals(this.txMgr.getDM().getId()) ? new DistTXStateOnCoordinator(this, false) : new DistPeerTXStateStub(this, this.target, this.onBehalfOfClientMember);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator::getRealDeal Built a new TXState: {} txMge:{} proxy {} target {}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId(), (Object)this, (Object)this.target);
            }
            this.target2realDeals.put(this.target, (DistTXCoordinatorInterface)this.realDeal);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.getRealDeal added TxState target2realDeals = " + this.target2realDeals);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator::getRealDeal Found TXState: {} proxy {} target {} target2realDeals {}", (Object)this.realDeal, (Object)this, (Object)this.target, this.target2realDeals);
        }
        return this.realDeal;
    }

    @Override
    public TXStateInterface getRealDeal(DistributedMember t) {
        assert (t != null);
        this.realDeal = this.target2realDeals.get(this.target);
        if (this.realDeal == null) {
            this.target = t;
            this.realDeal = new DistPeerTXStateStub(this, this.target, this.onBehalfOfClientMember);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator::getRealDeal(t) Built a new TXState: {} me:{}", (Object)this.realDeal, (Object)this.txMgr.getDM().getId());
            }
            if (!this.realDeal.isDistTx() || this.realDeal.isCreatedOnDistTxCoordinator() || !this.realDeal.isTxState()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistPeerTXStateStub", this.realDeal.getClass().getSimpleName()));
            }
            this.target2realDeals.put(this.target, (DistPeerTXStateStub)this.realDeal);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.getRealDeal(t) added TxState target2realDeals = " + this.target2realDeals);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator::getRealDeal(t) Found TXState: {} proxy {} target {} target2realDeals {}", (Object)this.realDeal, (Object)this, (Object)this.target, this.target2realDeals);
        }
        return this.realDeal;
    }

    private DistributedMember getRRTarget(KeyInfo key, LocalRegion r) {
        DistributedMember m;
        if (this.rrTargets == null) {
            this.rrTargets = new HashMap();
        }
        if ((m = this.rrTargets.get(r)) == null) {
            m = this.getOwnerForKey(r, key);
            this.rrTargets.put(r, m);
        }
        return m;
    }

    private Set<DistributedMember> getTxRemoteParticpants(DM dm) {
        if (this.txRemoteParticpants == null) {
            Set<DistributedMember> txParticpants = this.target2realDeals.keySet();
            this.txRemoteParticpants = new HashSet<DistributedMember>(txParticpants);
            this.txRemoteParticpants.remove(dm.getId());
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.doPrecommit txParticpants = " + txParticpants + " ,txRemoteParticpants=" + this.txRemoteParticpants + " ,originator=" + dm.getId());
            }
        }
        return this.txRemoteParticpants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPrecommit() {
        boolean finalResult = true;
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("Applying Dist TX Precommit");
        DM dm = cache.getDistributionManager();
        Set<DistributedMember> txRemoteParticpants = this.getTxRemoteParticpants(dm);
        DistTXPrecommitMessage.DistTxPrecommitReplyProcessor processor = new DistTXPrecommitMessage.DistTxPrecommitReplyProcessor(this.getTxId(), dm, txRemoteParticpants, this.target2realDeals);
        processor.enableSevereAlertProcessing();
        DistTXPrecommitMessage precommitMsg = new DistTXPrecommitMessage(this.getTxId(), this.onBehalfOfClientMember, (ReplyProcessor21)processor);
        for (DistributedMember remoteNode : txRemoteParticpants) {
            DistTXCoordinatorInterface remoteTXStateStub = this.target2realDeals.get(remoteNode);
            if (remoteTXStateStub.isTxState()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistPeerTXStateStub", remoteTXStateStub.getClass().getSimpleName()));
            }
            try {
                remoteTXStateStub.setPrecommitMessage(precommitMsg, dm);
                remoteTXStateStub.precommit();
            }
            finally {
                remoteTXStateStub.setPrecommitMessage(null, null);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("DistTXStateProxyImplOnCoordinator.doPrecommit Sent Message to target = " + remoteNode);
        }
        TreeSet<String> sortedRegionName = new TreeSet<String>();
        DistTXCoordinatorInterface localTXState = this.target2realDeals.get(dm.getId());
        if (localTXState != null) {
            if (!localTXState.isTxState()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateOnCoordinator", localTXState.getClass().getSimpleName()));
            }
            localTXState.precommit();
            boolean localResult = localTXState.getPreCommitResponse();
            TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> entryStateSortedMap = new TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>>();
            ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList = null;
            if (localResult && (localResult = ((DistTXStateOnCoordinator)localTXState).populateDistTxEntryStateList(entryStateSortedMap))) {
                entryEventList = new ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>>(entryStateSortedMap.values());
                this.populateEntryEventMap(dm.getId(), entryEventList, sortedRegionName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.doPrecommit local = " + dm.getId() + " ,entryEventList=" + DistTXStateProxyImplOnCoordinator.printEntryEventList(entryEventList) + " ,txRegionVersionsMap=" + DistTXStateProxyImplOnCoordinator.printEntryEventMap(this.txEntryEventMap) + " ,result= " + localResult + " ,finalResult-old= " + finalResult);
            }
            finalResult = finalResult && localResult;
        }
        dm.getCancelCriterion().checkCancelInProgress(null);
        processor.waitForPrecommitCompletion();
        Map<DistributedMember, DistTXPrecommitMessage.DistTxPrecommitResponse> remoteResults = processor.getCommitResponseMap();
        for (Map.Entry<DistributedMember, DistTXPrecommitMessage.DistTxPrecommitResponse> e : remoteResults.entrySet()) {
            DistributedMember target = e.getKey();
            DistTXPrecommitMessage.DistTxPrecommitResponse remoteResponse = e.getValue();
            ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList = remoteResponse.getDistTxEntryEventList();
            this.populateEntryEventMap(target, entryEventList, sortedRegionName);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.doPrecommit got reply from target = " + target + " ,sortedRegions" + sortedRegionName + " ,entryEventList=" + DistTXStateProxyImplOnCoordinator.printEntryEventList(entryEventList) + " ,txEntryEventMap=" + DistTXStateProxyImplOnCoordinator.printEntryEventMap(this.txEntryEventMap) + " ,result= " + remoteResponse.getCommitState() + " ,finalResult-old= " + finalResult);
            }
            finalResult = finalResult && remoteResponse.getCommitState() != false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator.doPrecommit finalResult= " + finalResult);
        }
        return finalResult;
    }

    private void populateEntryEventMap(DistributedMember target, ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList, TreeSet<String> sortedRegionName) {
        DistTXCoordinatorInterface distTxIface;
        if (this.txEntryEventMap == null) {
            this.txEntryEventMap = new HashMap();
        }
        if ((distTxIface = this.target2realDeals.get(target)).getPrimaryTransactionalOperations() != null && distTxIface.getPrimaryTransactionalOperations().size() > 0) {
            sortedRegionName.clear();
            distTxIface.gatherAffectedRegionsName(sortedRegionName, true, false);
            if (sortedRegionName.size() != entryEventList.size()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("size of " + sortedRegionName.size() + " {" + sortedRegionName + "} for target=" + target, entryEventList.size() + " {" + entryEventList + "}"));
            }
            int index = 0;
            for (String rName : sortedRegionName) {
                this.txEntryEventMap.put(rName, entryEventList.get(index++));
            }
        }
    }

    private void populateEntryEventList(DistributedMember target, ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList, TreeSet<String> sortedRegionMap) {
        DistTXCoordinatorInterface distTxItem = this.target2realDeals.get(target);
        sortedRegionMap.clear();
        distTxItem.gatherAffectedRegionsName(sortedRegionMap, false, true);
        entryEventList.clear();
        for (String rName : sortedRegionMap) {
            ArrayList<TXEntryState.DistTxThinEntryState> entryStates = this.txEntryEventMap.get(rName);
            if (entryStates == null) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("entryStates for " + rName + " at target " + target, "null"));
            }
            entryEventList.add(entryStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCommit() {
        boolean finalResult = true;
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("Applying Dist TX Commit");
        DM dm = cache.getDistributionManager();
        Set<DistributedMember> txRemoteParticpants = this.getTxRemoteParticpants(dm);
        DistTXCommitMessage.DistTxCommitReplyProcessor processor = new DistTXCommitMessage.DistTxCommitReplyProcessor(this.getTxId(), dm, txRemoteParticpants, this.target2realDeals);
        processor.enableSevereAlertProcessing();
        DistTXCommitMessage commitMsg = new DistTXCommitMessage(this.getTxId(), this.onBehalfOfClientMember, (ReplyProcessor21)processor);
        ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList = new ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>>();
        TreeSet<String> sortedRegionName = new TreeSet<String>();
        for (DistributedMember remoteNode : txRemoteParticpants) {
            DistTXCoordinatorInterface remoteTXStateStub = this.target2realDeals.get(remoteNode);
            if (remoteTXStateStub.isTxState()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistPeerTXStateStub", remoteTXStateStub.getClass().getSimpleName()));
            }
            try {
                this.populateEntryEventList(remoteNode, entryEventList, sortedRegionName);
                commitMsg.setEntryStateList(entryEventList);
                remoteTXStateStub.setCommitMessage(commitMsg, dm);
                remoteTXStateStub.commit();
            }
            finally {
                remoteTXStateStub.setCommitMessage(null, null);
                remoteTXStateStub.finalCleanup();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("DistTXStateProxyImplOnCoordinator.doCommit Sent Message target = " + remoteNode + " ,sortedRegions=" + sortedRegionName + " ,entryEventList=" + DistTXStateProxyImplOnCoordinator.printEntryEventList(entryEventList) + " ,txEntryEventMap=" + DistTXStateProxyImplOnCoordinator.printEntryEventMap(this.txEntryEventMap));
        }
        DistTXCoordinatorInterface localTXState = this.target2realDeals.get(dm.getId());
        if (localTXState != null) {
            if (!localTXState.isTxState()) {
                throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateOnCoordinator", localTXState.getClass().getSimpleName()));
            }
            this.populateEntryEventList(dm.getId(), entryEventList, sortedRegionName);
            ((DistTXStateOnCoordinator)localTXState).setDistTxEntryStates(entryEventList);
            localTXState.commit();
            TXCommitMessage localResultMsg = localTXState.getCommitMessage();
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.doCommit local = " + dm.getId() + " ,sortedRegions=" + sortedRegionName + " ,entryEventList=" + DistTXStateProxyImplOnCoordinator.printEntryEventList(entryEventList) + " ,txEntryEventMap=" + DistTXStateProxyImplOnCoordinator.printEntryEventMap(this.txEntryEventMap) + " ,result= " + (localResultMsg != null) + " ,finalResult-old= " + finalResult);
            }
            finalResult = finalResult && localResultMsg != null;
        }
        dm.getCancelCriterion().checkCancelInProgress(null);
        processor.waitForPrecommitCompletion();
        dm.getStats().incCommitWaits();
        Map<DistributedMember, TXCommitMessage> remoteResults = processor.getCommitResponseMap();
        for (Map.Entry<DistributedMember, TXCommitMessage> e : remoteResults.entrySet()) {
            DistributedMember target = e.getKey();
            TXCommitMessage remoteResultMsg = e.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.doCommit got results from target = " + target + " ,result= " + (remoteResultMsg != null) + " ,finalResult-old= " + finalResult);
            }
            finalResult = finalResult && remoteResultMsg != null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateProxyImplOnCoordinator.doCommit finalResult= " + finalResult);
        }
        return finalResult;
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        if (putallOp.putAllData.length == 0) {
            return;
        }
        if (region instanceof DistributedRegion) {
            super.postPutAll(putallOp, successfulPuts, region);
        } else {
            region.getCancelCriterion().checkCancelInProgress(null);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.postPutAll processing putAll op for region {}, size of putAllOp is {}", (Object)region, (Object)putallOp.putAllData.length);
            }
            HashMap<Integer, DistributedPutAllOperation> bucketToPutallMap = new HashMap<Integer, DistributedPutAllOperation>();
            HashMap<Integer, DistTXCoordinatorInterface> bucketToTxStateStubMap = new HashMap<Integer, DistTXCoordinatorInterface>();
            for (int i = 0; i < putallOp.putAllData.length; ++i) {
                assert (putallOp.putAllData[i] != null);
                Object key = putallOp.putAllData[i].key;
                int bucketId = putallOp.putAllData[i].getBucketId();
                DistributedPutAllOperation putAllForBucket = (DistributedPutAllOperation)bucketToPutallMap.get(bucketId);
                if (putAllForBucket == null) {
                    EntryEventImpl event = EntryEventImpl.createPutAllEvent(null, region, Operation.PUTALL_CREATE, key, putallOp.putAllData[i].getValue());
                    event.setEventId(putallOp.putAllData[i].getEventID());
                    putAllForBucket = new DistributedPutAllOperation(event, putallOp.putAllDataSize, putallOp.isBridgeOp);
                    bucketToPutallMap.put(bucketId, putAllForBucket);
                }
                putallOp.putAllData[i].setFakeEventID();
                putAllForBucket.addEntry(putallOp.putAllData[i]);
                KeyInfo ki = new KeyInfo(key, null, null);
                DistTXCoordinatorInterface tsi = (DistTXCoordinatorInterface)this.getRealDeal(ki, region);
                bucketToTxStateStubMap.put(bucketId, tsi);
            }
            for (Map.Entry e : bucketToTxStateStubMap.entrySet()) {
                Integer bucketId = (Integer)e.getKey();
                DistTXCoordinatorInterface dtsi = (DistTXCoordinatorInterface)e.getValue();
                DistributedPutAllOperation putAllForBucket = (DistributedPutAllOperation)bucketToPutallMap.get(bucketId);
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.postPutAll processing putAll for ##bucketId = {}, ##txStateStub = {}, ##putAllOp = {}", (Object)bucketId, (Object)dtsi, (Object)putAllForBucket);
                }
                dtsi.postPutAll(putAllForBucket, successfulPuts, region);
            }
        }
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
        if (op.removeAllData.length == 0) {
            return;
        }
        if (region instanceof DistributedRegion) {
            super.postRemoveAll(op, successfulOps, region);
        } else {
            region.getCancelCriterion().checkCancelInProgress(null);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateProxyImplOnCoordinator.postRemoveAll processing removeAll op for region {}, size of removeAll is {}", (Object)region, (Object)op.removeAllDataSize);
            }
            HashMap<Integer, DistributedRemoveAllOperation> bucketToRemoveAllMap = new HashMap<Integer, DistributedRemoveAllOperation>();
            HashMap<Integer, DistTXCoordinatorInterface> bucketToTxStateStubMap = new HashMap<Integer, DistTXCoordinatorInterface>();
            for (int i = 0; i < op.removeAllData.length; ++i) {
                assert (op.removeAllData[i] != null);
                Object key = op.removeAllData[i].key;
                int bucketId = op.removeAllData[i].getBucketId();
                DistributedRemoveAllOperation removeAllForBucket = (DistributedRemoveAllOperation)bucketToRemoveAllMap.get(bucketId);
                if (removeAllForBucket == null) {
                    EntryEventImpl event = EntryEventImpl.createRemoveAllEvent(op, region, key);
                    event.setEventId(op.removeAllData[i].getEventID());
                    removeAllForBucket = new DistributedRemoveAllOperation(event, op.removeAllDataSize, op.isBridgeOp);
                    bucketToRemoveAllMap.put(bucketId, removeAllForBucket);
                }
                op.removeAllData[i].setFakeEventID();
                removeAllForBucket.addEntry(op.removeAllData[i]);
                KeyInfo ki = new KeyInfo(key, null, null);
                DistTXCoordinatorInterface tsi = (DistTXCoordinatorInterface)this.getRealDeal(ki, region);
                bucketToTxStateStubMap.put(bucketId, tsi);
            }
            for (Map.Entry e : bucketToTxStateStubMap.entrySet()) {
                Integer bucketId = (Integer)e.getKey();
                DistTXCoordinatorInterface dtsi = (DistTXCoordinatorInterface)e.getValue();
                DistributedRemoveAllOperation removeAllForBucket = (DistributedRemoveAllOperation)bucketToRemoveAllMap.get(bucketId);
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXStateProxyImplOnCoordinator.postRemoveAll processing removeAll for ##bucketId = {}, ##txStateStub = {}, ##removeAllOp = {}", (Object)bucketId, (Object)dtsi, (Object)removeAllForBucket);
                }
                dtsi.postRemoveAll(removeAllForBucket, successfulOps, region);
            }
        }
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return true;
    }

    public static String printEntryEventMap(HashMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> txRegionVersionsMap) {
        StringBuilder str = new StringBuilder();
        str.append(" (");
        str.append(txRegionVersionsMap.size());
        str.append(")=[ ");
        for (Map.Entry<String, ArrayList<TXEntryState.DistTxThinEntryState>> entry : txRegionVersionsMap.entrySet()) {
            str.append(" {").append(entry.getKey());
            str.append(":").append("size(").append(entry.getValue().size()).append(")");
            str.append("=").append(entry.getValue()).append("}, ");
        }
        str.append(" } ");
        return str.toString();
    }

    public static String printEntryEventList(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList) {
        StringBuilder str = new StringBuilder();
        str.append(" (");
        str.append(entryEventList.size());
        str.append(")=[ ");
        for (ArrayList<TXEntryState.DistTxThinEntryState> entry : entryEventList) {
            str.append(" ( ");
            str.append(entry.size());
            str.append(" )={").append(entry);
            str.append(" } ");
        }
        str.append(" ] ");
        return str.toString();
    }

    public DistributedMember getOwnerForKey(LocalRegion r, KeyInfo key) {
        DistributedMember m = r.getOwnerForKey(key);
        if (m == null) {
            GemFireCacheImpl cache = GemFireCacheImpl.getExisting("getOwnerForKey");
            m = cache.getDistributedSystem().getDistributedMember();
        }
        return m;
    }
}

