/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelCriterion;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidValueException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.internal.LoadMonitor;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.admin.ClientHealthMonitoringRegion;
import org.apache.geode.internal.cache.AbstractCacheServer;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class CacheServerImpl
extends AbstractCacheServer
implements DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    private static final int FORCE_LOAD_UPDATE_FREQUENCY = Integer.getInteger("gemfire.BridgeServer.FORCE_LOAD_UPDATE_FREQUENCY", 10);
    private final SecurityService securityService;
    private final ServerConnectionFactory serverConnectionFactory = new ServerConnectionFactory();
    private volatile AcceptorImpl acceptor;
    private volatile CacheServerAdvisor advisor;
    private volatile LoadMonitor loadMonitor;
    private boolean isGatewayReceiver;
    private List<GatewayTransportFilter> gatewayTransportFilters = Collections.emptyList();
    private boolean isDefaultServer;
    private int serialNumber;
    public static final boolean ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE = Boolean.getBoolean("gemfire.cache-server.enable-notify-by-subscription-false");
    private static final AtomicInteger profileSN = new AtomicInteger();

    public CacheServerImpl(InternalCache cache, boolean isGatewayReceiver) {
        super(cache);
        this.isGatewayReceiver = isGatewayReceiver;
        this.securityService = cache.getSecurityService();
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    private void checkRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException(LocalizedStrings.CacheServerImpl_A_CACHE_SERVERS_CONFIGURATION_CANNOT_BE_CHANGED_ONCE_IT_IS_RUNNING.toLocalizedString());
        }
    }

    public boolean isGatewayReceiver() {
        return this.isGatewayReceiver;
    }

    @Override
    public int getPort() {
        if (this.acceptor != null) {
            return this.acceptor.getPort();
        }
        return super.getPort();
    }

    @Override
    public void setPort(int port) {
        this.checkRunning();
        super.setPort(port);
    }

    @Override
    public void setBindAddress(String address) {
        this.checkRunning();
        super.setBindAddress(address);
    }

    @Override
    public void setHostnameForClients(String name) {
        this.checkRunning();
        super.setHostnameForClients(name);
    }

    @Override
    public void setMaxConnections(int maxCon) {
        this.checkRunning();
        super.setMaxConnections(maxCon);
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.checkRunning();
        super.setMaxThreads(maxThreads);
    }

    @Override
    public void setNotifyBySubscription(boolean b) {
        this.checkRunning();
        if (ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE) {
            this.notifyBySubscription = b;
        }
    }

    @Override
    public void setMaximumMessageCount(int maximumMessageCount) {
        this.checkRunning();
        super.setMaximumMessageCount(maximumMessageCount);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @Override
    public void setLoadPollInterval(long loadPollInterval) {
        this.checkRunning();
        super.setLoadPollInterval(loadPollInterval);
    }

    @Override
    public int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @Override
    public void setLoadProbe(ServerLoadProbe loadProbe) {
        this.checkRunning();
        super.setLoadProbe(loadProbe);
    }

    public void setGatewayTransportFilter(List<GatewayTransportFilter> transportFilters) {
        this.gatewayTransportFilters = transportFilters;
    }

    @Override
    public int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    public boolean isDefaultServer() {
        return this.isDefaultServer;
    }

    public void setIsDefaultServer() {
        this.isDefaultServer = true;
    }

    public void configureFrom(CacheServer other) {
        this.setPort(other.getPort());
        this.setBindAddress(other.getBindAddress());
        this.setHostnameForClients(other.getHostnameForClients());
        this.setMaxConnections(other.getMaxConnections());
        this.setMaxThreads(other.getMaxThreads());
        this.setNotifyBySubscription(other.getNotifyBySubscription());
        this.setSocketBufferSize(other.getSocketBufferSize());
        this.setTcpNoDelay(other.getTcpNoDelay());
        this.setMaximumTimeBetweenPings(other.getMaximumTimeBetweenPings());
        this.setMaximumMessageCount(other.getMaximumMessageCount());
        this.setMessageTimeToLive(other.getMessageTimeToLive());
        this.setGroups(other.getGroups());
        this.setLoadProbe(other.getLoadProbe());
        this.setLoadPollInterval(other.getLoadPollInterval());
        ClientSubscriptionConfig cscOther = other.getClientSubscriptionConfig();
        ClientSubscriptionConfig cscThis = this.getClientSubscriptionConfig();
        cscThis.setEvictionPolicy(cscOther.getEvictionPolicy());
        cscThis.setCapacity(cscOther.getCapacity());
        String diskStoreName = cscOther.getDiskStoreName();
        if (diskStoreName != null) {
            cscThis.setDiskStoreName(diskStoreName);
        } else {
            cscThis.setOverflowDirectory(cscOther.getOverflowDirectory());
        }
    }

    @Override
    public synchronized void start() throws IOException {
        Assert.assertTrue(this.cache != null);
        this.serialNumber = CacheServerImpl.createSerialNumber();
        if (DynamicRegionFactory.get().isOpen() && !this.notifyBySubscription) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.CacheServerImpl_FORCING_NOTIFYBYSUBSCRIPTION_TO_SUPPORT_DYNAMIC_REGIONS));
            this.notifyBySubscription = true;
        }
        this.advisor = CacheServerAdvisor.createCacheServerAdvisor(this);
        this.loadMonitor = new LoadMonitor(this.loadProbe, this.maxConnections, this.loadPollInterval, FORCE_LOAD_UPDATE_FREQUENCY, this.advisor);
        LinkedList<Object> overflowAttributesList = new LinkedList<Object>();
        ClientSubscriptionConfig csc = this.getClientSubscriptionConfig();
        overflowAttributesList.add(0, csc.getEvictionPolicy());
        overflowAttributesList.add(1, csc.getCapacity());
        overflowAttributesList.add(2, this.port);
        String diskStoreName = csc.getDiskStoreName();
        if (diskStoreName != null) {
            overflowAttributesList.add(3, diskStoreName);
            overflowAttributesList.add(4, true);
        } else {
            overflowAttributesList.add(3, csc.getOverflowDirectory());
            overflowAttributesList.add(4, false);
        }
        this.acceptor = new AcceptorImpl(this.getPort(), this.getBindAddress(), this.getNotifyBySubscription(), this.getSocketBufferSize(), this.getMaximumTimeBetweenPings(), this.cache, this.getMaxConnections(), this.getMaxThreads(), this.getMaximumMessageCount(), this.getMessageTimeToLive(), this.loadMonitor, overflowAttributesList, this.isGatewayReceiver, this.gatewayTransportFilters, this.tcpNoDelay, this.serverConnectionFactory);
        this.acceptor.start();
        this.advisor.handshake();
        this.loadMonitor.start(new ServerLocation(this.getExternalAddress(), this.getPort()), this.acceptor.getStats());
        ClientHealthMonitoringRegion.getInstance(this.cache);
        this.cache.getLoggerI18n().config(LocalizedStrings.CacheServerImpl_CACHESERVER_CONFIGURATION___0, this.getConfig());
        ClientMembershipListener[] membershipListeners = ClientMembership.getClientMembershipListeners();
        boolean membershipListenerRegistered = false;
        for (ClientMembershipListener membershipListener : membershipListeners) {
            if (this.listener != membershipListener) continue;
            membershipListenerRegistered = true;
            break;
        }
        if (!membershipListenerRegistered) {
            ClientMembership.registerClientMembershipListener(this.listener);
        }
        if (!this.isGatewayReceiver) {
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.CACHE_SERVER_START, this);
        }
    }

    public String getExternalAddress() {
        return this.getExternalAddress(true);
    }

    public String getExternalAddress(boolean checkServerRunning) {
        if (checkServerRunning && !this.isRunning()) {
            String s = "A bridge server's bind address is only available if it has been started";
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            throw new IllegalStateException(s);
        }
        if (this.hostnameForClients == null || this.hostnameForClients.isEmpty()) {
            if (this.acceptor != null) {
                return this.acceptor.getExternalAddress();
            }
            return null;
        }
        return this.hostnameForClients;
    }

    @Override
    public boolean isRunning() {
        return this.acceptor != null && this.acceptor.isRunning();
    }

    @Override
    public synchronized void stop() {
        RuntimeException firstException;
        block12: {
            if (!this.isRunning()) {
                return;
            }
            firstException = null;
            try {
                if (this.loadMonitor != null) {
                    this.loadMonitor.stop();
                }
            }
            catch (RuntimeException e) {
                this.cache.getLoggerI18n().warning(LocalizedStrings.CacheServerImpl_CACHESERVER_ERROR_CLOSING_LOAD_MONITOR, e);
                firstException = e;
            }
            try {
                if (this.advisor != null) {
                    this.advisor.close();
                }
            }
            catch (RuntimeException e) {
                this.cache.getLoggerI18n().warning(LocalizedStrings.CacheServerImpl_CACHESERVER_ERROR_CLOSING_ADVISOR, e);
                firstException = e;
            }
            try {
                if (this.acceptor != null) {
                    this.acceptor.close();
                }
            }
            catch (RuntimeException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.CacheServerImpl_CACHESERVER_ERROR_CLOSING_ACCEPTOR_MONITOR), (Throwable)e);
                if (firstException == null) break block12;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        ClientMembership.unregisterClientMembershipListener(this.listener);
        TXManagerImpl txMgr = (TXManagerImpl)this.cache.getCacheTransactionManager();
        txMgr.removeHostedTXStatesForClients();
        if (!this.isGatewayReceiver) {
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.CACHE_SERVER_STOP, this);
        }
    }

    private String getConfig() {
        ClientSubscriptionConfig csc = this.getClientSubscriptionConfig();
        String str = "port=" + this.getPort() + " max-connections=" + this.getMaxConnections() + " max-threads=" + this.getMaxThreads() + " notify-by-subscription=" + this.getNotifyBySubscription() + " socket-buffer-size=" + this.getSocketBufferSize() + " maximum-time-between-pings=" + this.getMaximumTimeBetweenPings() + " maximum-message-count=" + this.getMaximumMessageCount() + " message-time-to-live=" + this.getMessageTimeToLive() + " eviction-policy=" + csc.getEvictionPolicy() + " capacity=" + csc.getCapacity() + " overflow directory=";
        str = csc.getDiskStoreName() != null ? str + csc.getDiskStoreName() : str + csc.getOverflowDirectory();
        str = str + " groups=" + Arrays.asList(this.getGroups()) + " loadProbe=" + this.loadProbe + " loadPollInterval=" + this.loadPollInterval + " tcpNoDelay=" + this.tcpNoDelay;
        return str;
    }

    public String toString() {
        ClientSubscriptionConfig csc = this.getClientSubscriptionConfig();
        String str = "CacheServer on port=" + this.getPort() + " client subscription config policy=" + csc.getEvictionPolicy() + " client subscription config capacity=" + csc.getCapacity();
        str = csc.getDiskStoreName() != null ? str + " client subscription config overflow disk store=" + csc.getDiskStoreName() : str + " client subscription config overflow directory=" + csc.getOverflowDirectory();
        return str;
    }

    @Override
    public AcceptorImpl getAcceptor() {
        return this.acceptor;
    }

    @Override
    public DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        return this.getCacheClientNotifier().getClientProxy(durableClientId);
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        return this.getCacheClientNotifier().getClientProxy(ClientProxyMembershipID.getClientId(member));
    }

    public Set getAllClientSessions() {
        return new HashSet<CacheClientProxy>(this.getCacheClientNotifier().getClientProxies());
    }

    public static String clientMessagesRegion(InternalCache cache, String ePolicy, int capacity, int port, String overFlowDir, boolean isDiskStore) {
        AttributesFactory factory = CacheServerImpl.getAttribFactoryForClientMessagesRegion(cache, ePolicy, capacity, overFlowDir, isDiskStore);
        RegionAttributes attr = factory.create();
        return CacheServerImpl.createClientMessagesRegion(attr, cache, capacity, port);
    }

    public static AttributesFactory getAttribFactoryForClientMessagesRegion(InternalCache cache, String ePolicy, int capacity, String overflowDir, boolean isDiskStore) throws InvalidValueException, GemFireIOException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        if (isDiskStore) {
            factory.setDiskStoreName(overflowDir);
            factory.setDiskSynchronous(true);
        } else if (overflowDir == null || overflowDir.equals(".")) {
            factory.setDiskStoreName(null);
            factory.setDiskSynchronous(true);
        } else {
            File dir = new File(overflowDir + File.separatorChar + CacheServerImpl.generateNameForClientMsgsRegion(OSProcess.getId()));
            dir.deleteOnExit();
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new GemFireIOException("Could not create client subscription overflow directory: " + dir.getAbsolutePath());
            }
            File[] dirs = new File[]{dir};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            dsf.setAutoCompact(true).setDiskDirsAndSizes(dirs, new int[]{Integer.MAX_VALUE}).create("bsi");
            factory.setDiskStoreName("bsi");
            factory.setDiskSynchronous(true);
        }
        factory.setDataPolicy(DataPolicy.NORMAL);
        factory.setStatisticsEnabled(true);
        if ("entry".equals(ePolicy)) {
            factory.setEvictionAttributes(EvictionAttributes.createLIFOEntryAttributes(capacity, EvictionAction.OVERFLOW_TO_DISK));
        } else if ("mem".equals(ePolicy)) {
            factory.setEvictionAttributes(EvictionAttributes.createLIFOMemoryAttributes(capacity, EvictionAction.OVERFLOW_TO_DISK));
        } else {
            throw new InvalidValueException(LocalizedStrings.CacheServerImpl__0_INVALID_EVICTION_POLICY.toLocalizedString(ePolicy));
        }
        return factory;
    }

    private static String createClientMessagesRegion(RegionAttributes attr, InternalCache cache, int capacity, int port) {
        String regionName = CacheServerImpl.generateNameForClientMsgsRegion(port);
        try {
            cache.createVMRegion(regionName, attr, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true));
        }
        catch (RegionExistsException ree) {
            InternalGemFireError assErr = new InternalGemFireError("unexpected exception");
            assErr.initCause(ree);
            throw assErr;
        }
        catch (IOException e) {
            InternalGemFireError assErr = new InternalGemFireError("unexpected exception");
            assErr.initCause(e);
            throw assErr;
        }
        catch (ClassNotFoundException e) {
            InternalGemFireError assErr = new InternalGemFireError("unexpected exception");
            assErr.initCause(e);
            throw assErr;
        }
        return regionName;
    }

    public static String generateNameForClientMsgsRegion(int id) {
        return "client_subscription_" + id;
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.advisor;
    }

    public CacheServerAdvisor getCacheServerAdvisor() {
        return this.advisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.getDistributionAdvisor().createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return (InternalDistributedSystem)this.cache.getDistributedSystem();
    }

    @Override
    public String getName() {
        return "CacheServer";
    }

    @Override
    public String getFullPath() {
        return this.getName();
    }

    private static int createSerialNumber() {
        return profileSN.incrementAndGet();
    }

    public String[] getCombinedGroups() {
        ArrayList<String> groupList = new ArrayList<String>();
        if (!this.isGatewayReceiver) {
            for (String g : MemberAttributes.parseGroups(null, this.getSystem().getConfig().getGroups())) {
                if (groupList.contains(g)) continue;
                groupList.add(g);
            }
        }
        for (String g : this.getGroups()) {
            if (groupList.contains(g)) continue;
            groupList.add(g);
        }
        String[] groups = new String[groupList.size()];
        return groupList.toArray(groups);
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof CacheServerAdvisor.CacheServerProfile);
        CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
        bp.setHost(this.getExternalAddress(false));
        bp.setPort(this.getPort());
        bp.setGroups(this.getCombinedGroups());
        bp.setMaxConnections(this.maxConnections);
        bp.setInitialLoad(this.loadMonitor.getLastLoad());
        bp.setLoadPollInterval(this.getLoadPollInterval());
        bp.serialNumber = this.getSerialNumber();
        bp.finishInit();
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    protected CacheClientNotifier getCacheClientNotifier() {
        return this.getAcceptor().getCacheClientNotifier();
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        if (!this.isRunning()) {
            throw new IllegalStateException(LocalizedStrings.CacheServerImpl_MUST_BE_RUNNING.toLocalizedString());
        }
        this.getCacheClientNotifier().registerInterestRegistrationListener(listener);
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        this.getCacheClientNotifier().unregisterInterestRegistrationListener(listener);
    }

    public Set getInterestRegistrationListeners() {
        return this.getCacheClientNotifier().getInterestRegistrationListeners();
    }
}

