/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.cache.AbstractBucketRegionQueue;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.persistence.query.mock.ByteComparator;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.parallel.BucketRegionQueueUnavailableException;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.concurrent.Atomics;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.logging.log4j.Logger;

public class BucketRegionQueue
extends AbstractBucketRegionQueue {
    private static final Logger logger = LogService.getLogger();
    private final Map indexes;
    private final BlockingDeque<Object> eventSeqNumDeque = new LinkedBlockingDeque<Object>();
    private long lastKeyRecovered;
    private final AtomicLong latestQueuedKey = new AtomicLong();
    private final AtomicLong latestAcknowledgedKey = new AtomicLong();

    public BucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.keySet();
        this.indexes = new ConcurrentHashMap();
    }

    @Override
    protected void cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus giiStatus) {
        this.loadEventsFromTempQueue();
        this.initializeEventSeqNumQueue();
        super.cleanUpDestroyedTokensAndMarkGIIComplete(giiStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEventSeqNumQueue() {
        this.getInitializationLock().writeLock().lock();
        try {
            if (!this.keySet().isEmpty()) {
                if (this.getPartitionedRegion().getColocatedWith() == null) {
                    ArrayList keys = new ArrayList(this.keySet());
                    Collections.sort(keys, new Comparator<EventID>(){

                        @Override
                        public int compare(EventID o1, EventID o2) {
                            int compareMem = new ByteComparator().compare(o1.getMembershipID(), o2.getMembershipID());
                            if (compareMem == 1) {
                                return 1;
                            }
                            if (compareMem == -1) {
                                return -1;
                            }
                            if (o1.getThreadID() > o2.getThreadID()) {
                                return 1;
                            }
                            if (o1.getThreadID() < o2.getThreadID()) {
                                return -1;
                            }
                            return o1.getSequenceID() < o2.getSequenceID() ? -1 : (o1.getSequenceID() == o2.getSequenceID() ? 0 : 1);
                        }
                    });
                    for (EventID eventID : keys) {
                        this.eventSeqNumDeque.addLast(eventID);
                    }
                } else {
                    TreeSet sortedKeys = new TreeSet(this.keySet());
                    if (!sortedKeys.isEmpty()) {
                        for (Long key : sortedKeys) {
                            this.eventSeqNumDeque.addLast(key);
                        }
                        this.lastKeyRecovered = (Long)sortedKeys.last();
                        if (this.getEventSeqNum() != null) {
                            Atomics.setIfGreater(this.getEventSeqNum(), this.lastKeyRecovered);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("For bucket {} ,total keys recovered are : {} last key recovered is : {} and the seqNo is ", (Object)this.getId(), (Object)this.eventSeqNumDeque.size(), (Object)this.lastKeyRecovered, (Object)this.getEventSeqNum());
                }
            }
            this.initialized = true;
            this.destroyFailedBatchRemovalMessageKeys();
        }
        finally {
            this.notifyEventProcessor();
            this.getInitializationLock().writeLock().unlock();
        }
    }

    private void destroyFailedBatchRemovalMessageKeys() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Iterator<Object> itr = this.getFailedBatchRemovalMessageKeys().iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            itr.remove();
            if (isDebugEnabled) {
                logger.debug("key from failedBatchRemovalMessageKeys is: {}", key);
            }
            if (!this.containsKey(key)) continue;
            try {
                this.destroyKey(key);
                if (!isDebugEnabled) continue;
                logger.debug("Destroyed {} from bucket: ", key, (Object)this.getId());
            }
            catch (ForceReattemptException fe) {
                if (!isDebugEnabled) continue;
                logger.debug("Bucket :{} moved to other member", (Object)this.getId());
            }
        }
    }

    @Override
    public void beforeAcquiringPrimaryState() {
        Iterator<Object> itr = this.eventSeqNumDeque.iterator();
        this.markEventsAsDuplicate(itr);
    }

    @Override
    public void closeEntries() {
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                BucketRegionQueue.super.closeEntries();
            }
        });
        this.indexes.clear();
        this.eventSeqNumDeque.clear();
    }

    @Override
    public Set<VersionSource> clearEntries(final RegionVersionVector rvv) {
        final AtomicReference result = new AtomicReference();
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                result.set(BucketRegionQueue.super.clearEntries(rvv));
            }
        });
        this.eventSeqNumDeque.clear();
        return (Set)result.get();
    }

    @Override
    public void forceSerialized(EntryEventImpl event) {
    }

    @Override
    protected void clearQueues() {
        this.getInitializationLock().writeLock().lock();
        try {
            this.indexes.clear();
            this.eventSeqNumDeque.clear();
        }
        finally {
            this.getInitializationLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        try {
            boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
            if (success) {
                if (this.getPartitionedRegion().getColocatedWith() == null) {
                    boolean bl = success;
                    return bl;
                }
                if (this.getPartitionedRegion().isConflationEnabled() && this.getBucketAdvisor().isPrimary()) {
                    Object object = event.getNewValue();
                    Long key = (Long)event.getKey();
                    if (object instanceof Conflatable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Key :{} , Object : {} is conflatable", (Object)key, object);
                        }
                        this.conflateOldEntry((Conflatable)object, key);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Object : {} is not conflatable", object);
                    }
                }
            } else {
                GatewaySenderEventImpl.release(event.getRawNewValue());
            }
            boolean bl = success;
            return bl;
        }
        finally {
            GatewaySenderEventImpl.release(event.getRawOldValue());
        }
    }

    private void conflateOldEntry(Conflatable object, Long tailKey) {
        PartitionedRegion region = this.getPartitionedRegion();
        Conflatable conflatableObject = object;
        if (region.isConflationEnabled() && conflatableObject.shouldBeConflated()) {
            Long previousTailKey;
            ConcurrentHashMap<Object, Long> latestIndexesForRegion;
            Object keyToConflate = conflatableObject.getKeyToConflate();
            String rName = object.getRegionToConflate();
            if (logger.isDebugEnabled()) {
                logger.debug(" The region name is : {}", (Object)rName);
            }
            if ((latestIndexesForRegion = (ConcurrentHashMap<Object, Long>)this.indexes.get(rName)) == null) {
                latestIndexesForRegion = new ConcurrentHashMap<Object, Long>();
                this.indexes.put(rName, latestIndexesForRegion);
            }
            if ((previousTailKey = latestIndexesForRegion.put(keyToConflate, tailKey)) != null) {
                AbstractGatewaySenderEventProcessor ep;
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Conflating {} at queue index={} and previousTailKey: ", (Object)this, (Object)object, (Object)tailKey, (Object)previousTailKey);
                }
                if ((ep = region.getParallelGatewaySender().getEventProcessor()) == null) {
                    return;
                }
                ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
                queue.conflateEvent(conflatableObject, this.getId(), previousTailKey);
            } else {
                region.getParallelGatewaySender().getStatistics().incConflationIndexesMapSize();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Not conflating {}", (Object)this, (Object)object);
        }
    }

    private void removeIndex(Long qkey) {
        Conflatable object;
        Object o = this.getNoLRU(qkey, true, false, false);
        if (o instanceof Conflatable && (object = (Conflatable)o).shouldBeConflated()) {
            Long index;
            String rName = object.getRegionToConflate();
            Object key = object.getKeyToConflate();
            Map latestIndexesForRegion = (Map)this.indexes.get(rName);
            if (latestIndexesForRegion != null && latestIndexesForRegion.get(key) == qkey && (index = (Long)latestIndexesForRegion.remove(key)) != null) {
                this.getPartitionedRegion().getParallelGatewaySender().getStatistics().decConflationIndexesMapSize();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Removed index {} for {}", (Object)this, (Object)index, (Object)object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        if (this.getPartitionedRegion().isConflationEnabled()) {
            this.removeIndex((Long)event.getKey());
        }
        try {
            super.basicDestroy(event, cacheWrite, expectedOldValue);
        }
        finally {
            GatewaySenderEventImpl.release(event.getRawOldValue());
        }
        if (!this.getBucketAdvisor().isPrimary()) {
            if (logger.isDebugEnabled()) {
                logger.debug(" removing the key {} from eventSeqNumQueue", event.getKey());
            }
            this.eventSeqNumDeque.remove(event.getKey());
        }
    }

    private Object optimalGet(Object k) {
        Object object = null;
        try {
            object = this.getValueInVMOrDiskWithoutFaultIn(k);
            if (object != null && object instanceof CachedDeserializable) {
                object = ((CachedDeserializable)object).getDeserializedValue(this, this.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        if (object == Token.TOMBSTONE) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object key = null;
        Object object = null;
        this.getInitializationLock().readLock().lock();
        try {
            if (this.getPartitionedRegion().isDestroyed()) {
                throw new BucketRegionQueueUnavailableException();
            }
            key = this.eventSeqNumDeque.peekFirst();
            if (key != null) {
                object = this.optimalGet(key);
                if (object == null && !this.getPartitionedRegion().isConflationEnabled() && logger.isDebugEnabled()) {
                    logger.debug("The value against key {} in the bucket region queue with id {} is NULL for the GatewaySender {}", key, (Object)this.getId(), (Object)this.getPartitionedRegion().getParallelGatewaySender());
                }
                this.eventSeqNumDeque.remove(key);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.getInitializationLock().readLock().unlock();
        }
    }

    @Override
    protected void addToEventQueue(Object key, boolean didPut, EntryEventImpl event) {
        if (didPut) {
            if (this.initialized) {
                this.eventSeqNumDeque.addLast(key);
                this.updateLargestQueuedKey((Long)key);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Put successfully in the queue : {} was initialized: {}", event.getRawNewValue(), (Object)this.initialized);
            }
        }
        if (this.getBucketAdvisor().isPrimary()) {
            this.incQueueSize(1);
        }
    }

    public void pushKeyIntoQueue(Object key) {
        this.eventSeqNumDeque.addFirst(key);
    }

    private void updateLargestQueuedKey(Long key) {
        Atomics.setIfGreater(this.latestQueuedKey, key);
    }

    private void setLatestAcknowledgedKey(Long key) {
        this.latestAcknowledgedKey.set(key);
    }

    public long getLatestQueuedKey() {
        return this.latestQueuedKey.get();
    }

    public boolean waitUntilFlushed(long latestQueuedKey, long timeout, TimeUnit unit) throws InterruptedException {
        long then = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("BucketRegionQueue: waitUntilFlushed bucket=" + this.getId() + "; latestQueuedKey=" + latestQueuedKey + "; timeout=" + timeout + "; unit=" + (Object)((Object)unit));
        }
        boolean result = false;
        if (this.initialized) {
            long nanosRemaining = unit.toNanos(timeout);
            long endTime = System.nanoTime() + nanosRemaining;
            while (nanosRemaining > 0L) {
                block7: {
                    try {
                        if (this.latestAcknowledgedKey.get() > latestQueuedKey || this.isEmpty()) {
                            result = true;
                            break;
                        }
                    }
                    catch (RegionDestroyedException e) {
                        if (!this.isBucketDestroyed()) break block7;
                        this.getCancelCriterion().checkCancelInProgress(e);
                        throw new BucketMovedException(this.getFullPath());
                    }
                }
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(nanosRemaining) + 1L, 100L));
                nanosRemaining = endTime - System.nanoTime();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("BucketRegionQueue: waitUntilFlushed completed bucket=" + this.getId() + "; duration=" + (System.currentTimeMillis() - then) + "; result=" + result);
        }
        return result;
    }

    public Object remove() throws ForceReattemptException {
        Object key = this.eventSeqNumDeque.removeFirst();
        if (key != null) {
            this.destroyKey(key);
        }
        return key;
    }

    public Object take() throws InterruptedException, ForceReattemptException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyKey(Object key) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug(" destroying primary key {}", key);
        }
        EntryEventImpl event = this.newDestroyEntryEvent(key, null);
        try {
            event.setEventId(new EventID(this.cache.getInternalDistributedSystem()));
            event.setRegion(this);
            this.basicDestroy(event, true, null);
            this.setLatestAcknowledgedKey((Long)key);
            this.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.getPartitionedRegion().isDestroyed()) {
                this.getPartitionedRegion().checkReadiness();
                if (this.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket moved", new RegionDestroyedException(LocalizedStrings.PartitionedRegionDataStore_REGION_HAS_BEEN_DESTROYED.toLocalizedString(), this.getPartitionedRegion().getFullPath()));
                }
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved while destroying key " + key, rde);
            }
        }
        finally {
            event.release();
        }
        this.notifyEntriesRemoved();
    }

    @Override
    public EntryEventImpl newDestroyEntryEvent(Object key, Object aCallbackArgument) {
        return this.getPartitionedRegion().newDestroyEntryEvent(key, aCallbackArgument);
    }

    public boolean isReadyForPeek() {
        return !this.getPartitionedRegion().isDestroyed() && !this.isEmpty() && !this.eventSeqNumDeque.isEmpty() && this.getBucketAdvisor().isPrimary();
    }
}

