/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.PartitionedRegionRedundancyTracker;

class BucketRedundancyTracker {
    private boolean redundancySatisfied = false;
    private boolean hasAnyCopies = false;
    private boolean redundancyEverSatisfied = false;
    private boolean hasEverHadCopies = false;
    private volatile int currentRedundancy = -1;
    private final int targetRedundancy;
    private final PartitionedRegionRedundancyTracker regionRedundancyTracker;

    BucketRedundancyTracker(int redundantCopies, PartitionedRegionRedundancyTracker regionRedundancyTracker) {
        this.targetRedundancy = redundantCopies;
        this.regionRedundancyTracker = regionRedundancyTracker;
    }

    synchronized void closeBucket() {
        if (!this.redundancySatisfied) {
            this.regionRedundancyTracker.decrementLowRedundancyBucketCount();
            this.redundancySatisfied = true;
        }
        if (this.hasEverHadCopies && !this.hasAnyCopies) {
            this.regionRedundancyTracker.decrementNoCopiesBucketCount();
            this.hasAnyCopies = true;
        }
    }

    synchronized void updateStatistics(int currentBucketHosts) {
        this.updateRedundancyStatistics(currentBucketHosts);
        this.updateNoCopiesStatistics(currentBucketHosts);
    }

    int getCurrentRedundancy() {
        return this.currentRedundancy;
    }

    private void updateNoCopiesStatistics(int currentBucketHosts) {
        if (this.hasAnyCopies && currentBucketHosts == 0) {
            this.hasAnyCopies = false;
            this.regionRedundancyTracker.incrementNoCopiesBucketCount();
        } else if (!this.hasAnyCopies && currentBucketHosts > 0) {
            if (this.hasEverHadCopies) {
                this.regionRedundancyTracker.decrementNoCopiesBucketCount();
            }
            this.hasEverHadCopies = true;
            this.hasAnyCopies = true;
        }
    }

    private void updateRedundancyStatistics(int updatedBucketHosts) {
        int updatedRedundancy = updatedBucketHosts - 1;
        this.updateCurrentRedundancy(updatedRedundancy);
        if (updatedRedundancy < this.targetRedundancy) {
            this.reportUpdatedBucketCount(updatedBucketHosts);
            if (this.redundancySatisfied) {
                this.regionRedundancyTracker.incrementLowRedundancyBucketCount();
                this.redundancySatisfied = false;
            } else if (!this.hasAnyCopies && updatedRedundancy >= 0) {
                this.regionRedundancyTracker.incrementLowRedundancyBucketCount();
            }
        } else if (!this.redundancySatisfied && updatedRedundancy == this.targetRedundancy) {
            this.regionRedundancyTracker.decrementLowRedundancyBucketCount();
            this.redundancySatisfied = true;
            this.redundancyEverSatisfied = true;
        }
    }

    private void updateCurrentRedundancy(int updatedRedundancy) {
        if (updatedRedundancy != this.currentRedundancy) {
            this.regionRedundancyTracker.setActualRedundancy(updatedRedundancy);
            this.currentRedundancy = updatedRedundancy;
        }
    }

    private void reportUpdatedBucketCount(int updatedBucketHosts) {
        if (this.redundancyEverSatisfied) {
            this.regionRedundancyTracker.reportBucketCount(updatedBucketHosts);
        }
    }
}

