/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.eviction.CachedDeserializableValueWrapper;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.eviction.EvictionListBuilder;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.eviction.HeapLRUController;
import org.apache.geode.internal.cache.eviction.MemoryLRUController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractLRURegionMap
extends AbstractRegionMap {
    private static final Logger logger = LogService.getLogger();
    private EvictionController evictionController;
    private final ThreadLocal lruDelta = new ThreadLocal();
    private final ThreadLocal mustRemove = new ThreadLocal();
    private final ThreadLocal callbackDisabled = new ThreadLocal();

    protected AbstractLRURegionMap(InternalRegionArguments internalRegionArgs) {
        super(internalRegionArgs);
    }

    protected abstract void setEvictionList(EvictionList var1);

    public abstract EvictionList getEvictionList();

    protected EvictionController getEvictionController() {
        return this.evictionController;
    }

    protected void initialize(Object owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        super.initialize(owner, attr, internalRegionArgs, true);
        this.createEvictionController(owner, internalRegionArgs);
    }

    private void createEvictionController(Object owner, InternalRegionArguments internalRegionArgs) {
        EvictionController evictionController;
        EvictionAlgorithm evictionAlgorithm;
        if (owner instanceof LocalRegion) {
            evictionAlgorithm = ((LocalRegion)owner).getEvictionAttributes().getAlgorithm();
            evictionController = ((LocalRegion)owner).getEvictionController();
        } else if (owner instanceof PlaceHolderDiskRegion) {
            PlaceHolderDiskRegion phdr = (PlaceHolderDiskRegion)owner;
            evictionAlgorithm = phdr.getActualLruAlgorithm();
            evictionController = ((EvictionAttributesImpl)phdr.getEvictionAttributes()).createEvictionController(null, phdr.getOffHeap());
        } else {
            throw new IllegalStateException("expected LocalRegion or PlaceHolderDiskRegion");
        }
        if (evictionAlgorithm.isLRUMemory()) {
            ((MemoryLRUController)evictionController).setEntryOverHead(this.getEntryOverHead());
        }
        if (evictionAlgorithm.isLRUHeap()) {
            ((HeapLRUController)evictionController).setEntryOverHead(this.getEntryOverHead());
        }
        this.evictionController = evictionController;
        this.setEvictionList(new EvictionListBuilder(evictionAlgorithm).withArgs(internalRegionArgs).withRegion(owner).withEvictionController(this.getEvictionController()).create());
    }

    @Override
    public void changeOwner(LocalRegion r) {
        super.changeOwner(r);
        this.getEvictionList().setBucketRegion(r);
        this.evictionController.setBucketRegion(r);
    }

    private int getDelta() {
        Object d = this.lruDelta.get();
        this.lruDelta.set(null);
        if (d == null) {
            return 0;
        }
        return (Integer)d;
    }

    private void setDelta(int delta) {
        Integer delt;
        if (!this.getCallbackDisabled()) {
            if (this.getMustRemove()) {
                this.lruUpdateCallback();
            }
            this.setMustRemove(true);
        }
        if ((delt = (Integer)this.lruDelta.get()) != null) {
            delta += delt.intValue();
        }
        this.lruDelta.set(delta);
    }

    public boolean beginChangeValueForm(EvictableEntry le, CachedDeserializable cd, Object v) {
        if (this.getEvictionController().getEvictionAlgorithm().isLRUEntry()) {
            return false;
        }
        Object curVal = le.getValue();
        if (curVal != cd) {
            if (cd instanceof StoredObject) {
                if (!cd.equals(curVal)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        boolean result = false;
        int delta = le.updateEntrySize(this.getEvictionController(), new CachedDeserializableValueWrapper(v));
        if (delta != 0) {
            result = true;
            boolean disabledLURCallbacks = this.disableLruUpdateCallback();
            this.setDelta(delta);
            if (disabledLURCallbacks) {
                this.enableLruUpdateCallback();
            }
        }
        if (this.getEvictionController().getEvictionAlgorithm().isLRUHeap() && this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion && HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
            result = false;
        }
        return result;
    }

    public void finishChangeValueForm() {
        this.lruUpdateCallback();
    }

    private boolean getMustRemove() {
        Object d = this.mustRemove.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setMustRemove(boolean b) {
        this.mustRemove.set(b ? Boolean.TRUE : null);
    }

    private boolean getCallbackDisabled() {
        Object d = this.callbackDisabled.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setCallbackDisabled(boolean b) {
        this.callbackDisabled.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getEntryOverHead() {
        RegionEntryFactory f = this.getEntryFactory();
        if (f == null) {
            return 0;
        }
        return (int)ReflectionSingleObjectSizer.sizeof(f.getEntryClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int evictEntry(EvictableEntry entry, EvictionStatistics stats) throws RegionClearedException {
        EvictionAction action = this.getEvictionController().getEvictionAction();
        LocalRegion region = this._getOwner();
        if (action.isLocalDestroy()) {
            int size = entry.getEntrySize();
            if (region.evictDestroy(entry)) {
                stats.incDestroys();
                return size;
            }
            return 0;
        }
        if (action.isOverflowToDisk()) {
            boolean result;
            Assert.assertTrue(entry instanceof DiskEntry);
            int change = 0;
            EvictableEntry evictableEntry = entry;
            synchronized (evictableEntry) {
                if (entry.isInUseByTransaction()) {
                    entry.unsetEvicted();
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "No eviction of transactional entry for key={}", entry.getKey());
                    }
                    return 0;
                }
                Token entryVal = entry.getValueAsToken();
                if (entryVal == null) {
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "no need to evict already evicted key={}", entry.getKey());
                    }
                    return 0;
                }
                if (Token.isInvalidOrRemoved(entryVal)) {
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "no need to evict {} token for key={}", (Object)entryVal, entry.getKey());
                    }
                    return 0;
                }
                entry.setEvicted();
                change = DiskEntry.Helper.overflowToDisk((DiskEntry)((Object)entry), region, this.getEvictionController());
            }
            boolean bl = result = change < 0;
            if (result) {
                if (this._getOwner() instanceof BucketRegion) {
                    BucketRegion bucketRegion = (BucketRegion)this._getOwner();
                    bucketRegion.updateCounter(change);
                    stats.updateCounter(change);
                } else {
                    stats.updateCounter(change);
                }
            } else if (logger.isTraceEnabled(LogMarker.LRU)) {
                logger.trace(LogMarker.LRU, "no need to evict token for key={} because moving its value to disk resulted in a net change of {} bytes.", entry.getKey(), (Object)change);
            }
            return change * -1;
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractLRURegionMap_UNKNOWN_EVICTION_ACTION_0.toLocalizedString(action));
    }

    protected void changeTotalEntrySize(int delta) {
        if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            bucketRegion.updateCounter(delta);
        }
        this.getEvictionList().getStatistics().updateCounter(delta);
        if (delta > 0 && logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "total lru size is now: {}", (Object)this.getTotalEntrySize());
        }
    }

    @Override
    public void evictValue(Object key) {
        throw new IllegalStateException("The evictValue is not supported on regions with eviction attributes.");
    }

    protected long getLimit() {
        if (this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getLimit();
        }
        return this.getEvictionController().getStatistics().getLimit();
    }

    public EvictionStatistics getLRUStatistics() {
        return this.getEvictionController().getStatistics();
    }

    protected long getTotalEntrySize() {
        if (this._getOwnerObject() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getCounter();
        }
        return this.getEvictionController().getStatistics().getCounter();
    }

    @Override
    public void lruUpdateCallback() {
        boolean isDebugEnabled_LRU;
        block28: {
            int delta;
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            if (this.getCallbackDisabled()) {
                return;
            }
            int bytesToEvict = delta = this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU && this._isOwnerALocalRegion()) {
                logger.trace(LogMarker.LRU, "lruUpdateCallback; list size is: {}; actual size is: {}; map size is: {}; delta is: {}; limit is: {}; tombstone count={}", (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)delta, (Object)this.getLimit(), (Object)this._getOwner().getTombstoneCount());
            }
            EvictionStatistics stats = this.getEvictionList().getStatistics();
            if (!this._isOwnerALocalRegion()) {
                this.changeTotalEntrySize(delta);
            } else {
                if (this.getEvictionController().getEvictionAlgorithm().isLRUHeap()) {
                    this.changeTotalEntrySize(delta);
                    try {
                        while (bytesToEvict > 0 && this.getEvictionController().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                            boolean evictFromThisRegion = true;
                            if (HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST && this._getOwner() instanceof BucketRegion) {
                                long bytesEvicted = 0L;
                                long totalBytesEvicted = 0L;
                                List<BucketRegion> regions = ((BucketRegion)this._getOwner()).getPartitionedRegion().getSortedBuckets();
                                Iterator<BucketRegion> iter = regions.iterator();
                                while (iter.hasNext()) {
                                    BucketRegion region = iter.next();
                                    if (region.getBucketAdvisor().isPrimary()) continue;
                                    try {
                                        bytesEvicted = ((AbstractLRURegionMap)region.entries).centralizedLruUpdateCallback();
                                        if (bytesEvicted == 0L) {
                                            iter.remove();
                                        } else {
                                            evictFromThisRegion = false;
                                        }
                                        totalBytesEvicted += bytesEvicted;
                                        bytesToEvict = (int)((long)bytesToEvict - bytesEvicted);
                                        if (bytesEvicted > (long)bytesToEvict) {
                                            bytesToEvict = 0;
                                            break;
                                        }
                                        if (totalBytesEvicted <= (long)bytesToEvict) continue;
                                        break;
                                    }
                                    catch (RegionDestroyedException rd) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(rd);
                                    }
                                    catch (Exception e) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(e);
                                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.Eviction_EVICTOR_TASK_EXCEPTION, new Object[]{e.getMessage()}), (Throwable)e);
                                    }
                                }
                            }
                            if (!evictFromThisRegion) continue;
                            EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                            if (removalEntry != null) {
                                int sizeOfValue = this.evictEntry(removalEntry, stats);
                                if (sizeOfValue == 0) continue;
                                bytesToEvict -= sizeOfValue;
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU, "evicted entry key={} total entry size is now: {} bytesToEvict :{}", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                                }
                                stats.incEvictions();
                                if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                    ((BucketRegion)this._getOwner()).incEvictions(1L);
                                }
                                if (!isDebugEnabled_LRU) continue;
                                logger.trace(LogMarker.LRU, "evictions={}", (Object)stats.getEvictions());
                                continue;
                            }
                            if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "leaving evict loop early");
                            }
                            break block28;
                        }
                        break block28;
                    }
                    catch (RegionClearedException e) {
                        if (isDebugEnabled_LRU) {
                            logger.trace(LogMarker.LRU, "exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
                        }
                        break block28;
                    }
                }
                try {
                    while (bytesToEvict > 0 && this.getEvictionController().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                        EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                        if (removalEntry != null) {
                            if (this.evictEntry(removalEntry, stats) == 0) continue;
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "evicted entry key(2)={} total entry size is now: {} bytesToEvict: {}", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                            }
                            stats.incEvictions();
                            if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                ((BucketRegion)this._getOwner()).incEvictions(1L);
                            }
                            if (!isDebugEnabled_LRU) continue;
                            logger.trace(LogMarker.LRU, "evictions={}", (Object)stats.getEvictions());
                            continue;
                        }
                        if (this.getTotalEntrySize() == 0L || !isDebugEnabled_LRU) break;
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                        break;
                    }
                    this.changeTotalEntrySize(delta);
                }
                catch (RegionClearedException e) {
                    if (!isDebugEnabled_LRU) break block28;
                    logger.debug("exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
                }
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete.  LRU size is now {}", (Object)this.getEvictionController().getStatistics().getCounter());
        }
    }

    private boolean mustEvict() {
        boolean offheap;
        LocalRegion owner = this._getOwner();
        InternalResourceManager resourceManager = owner.getCache().getInternalResourceManager();
        return resourceManager.getMemoryMonitor(offheap = owner.getAttributes().getOffHeap()).getState().isEviction() && this.sizeInVM() > 0;
    }

    public int centralizedLruUpdateCallback() {
        int evictedBytes;
        boolean isDebugEnabled_LRU;
        block9: {
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            evictedBytes = 0;
            if (this.getCallbackDisabled()) {
                return evictedBytes;
            }
            this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU) {
                logger.trace(LogMarker.LRU, "centralLruUpdateCallback: lru size is now {}, limit is: {}", (Object)this.getTotalEntrySize(), (Object)this.getLimit());
            }
            EvictionStatistics stats = this.getEvictionList().getStatistics();
            try {
                while (this.mustEvict() && evictedBytes == 0) {
                    EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                    if (removalEntry != null) {
                        evictedBytes = this.evictEntry(removalEntry, stats);
                        if (evictedBytes == 0) continue;
                        if (this._getOwner() instanceof BucketRegion) {
                            ((BucketRegion)this._getOwner()).incEvictions(1L);
                        }
                        stats.incEvictions();
                        if (!isDebugEnabled_LRU) continue;
                        logger.debug("evictions={}", (Object)stats.getEvictions());
                        continue;
                    }
                    if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                    }
                    break;
                }
            }
            catch (RegionClearedException e) {
                if (!isDebugEnabled_LRU) break block9;
                logger.trace(LogMarker.LRU, "exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete");
        }
        return evictedBytes;
    }

    public void updateStats() {
        int delta = this.getDelta();
        this.resetThreadLocals();
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "updateStats - delta is: {} total is: {} limit is: {}", (Object)delta, (Object)this.getTotalEntrySize(), (Object)this.getLimit());
        }
        if (delta != 0) {
            this.changeTotalEntrySize(delta);
        }
    }

    @Override
    public boolean disableLruUpdateCallback() {
        if (this.getCallbackDisabled()) {
            return false;
        }
        this.setCallbackDisabled(true);
        return true;
    }

    @Override
    public void enableLruUpdateCallback() {
        this.setCallbackDisabled(false);
    }

    @Override
    public void resetThreadLocals() {
        this.mustRemove.set(null);
        this.lruDelta.set(null);
        this.callbackDisabled.set(null);
    }

    @Override
    public Set<VersionSource> clear(RegionVersionVector rvv) {
        this.getEvictionList().clear(rvv);
        return super.clear(rvv);
    }

    @Override
    protected void lruEntryCreate(RegionEntry re) {
        boolean possibleClear;
        EvictableEntry e = (EvictableEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryCreate for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.isEvicted() ? 1 : 0));
        }
        e.unsetEvicted();
        EvictionList lruList = this.getEvictionList();
        DiskRegion disk = this._getOwner().getDiskRegion();
        boolean bl = possibleClear = disk != null && disk.didClearCountChange();
        if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
            lruList.appendEntry(e);
            this.lruEntryUpdate(e);
        }
    }

    @Override
    protected void lruEntryUpdate(RegionEntry re) {
        EvictableEntry e = (EvictableEntry)re;
        this.setDelta(e.updateEntrySize(this.getEvictionController()));
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryUpdate for key={} size={}", re.getKey(), (Object)e.getEntrySize());
        }
        EvictionList lruList = this.getEvictionList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
                if (e instanceof DiskEntry && !e.isEvicted()) {
                    lruList.appendEntry(e);
                }
                e.resetRefCount(lruList);
            }
        } else if (!e.isEvicted()) {
            lruList.appendEntry(e);
        }
    }

    @Override
    protected void lruEntryDestroy(RegionEntry re) {
        EvictableEntry e = (EvictableEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryDestroy for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.isEvicted() ? 1 : 0));
        }
        this.getEvictionList().destroyEntry(e);
        this.changeTotalEntrySize(-1 * e.getEntrySize());
        Token vTok = re.getValueAsToken();
        if (vTok == Token.DESTROYED || vTok == Token.TOMBSTONE) {
            e.updateEntrySize(this.getEvictionController());
        }
    }

    @Override
    public void lruEntryFaultIn(EvictableEntry e) {
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryFaultIn for key={} size={}", e.getKey(), (Object)e.getEntrySize());
        }
        EvictionList lruList = this.getEvictionList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(e.getKey()) == e) {
                this.lruEntryUpdate(e);
                e.unsetEvicted();
                lruList.appendEntry(e);
            }
        } else {
            this.lruEntryUpdate(e);
            lruList.appendEntry(e);
        }
    }

    @Override
    public void decTxRefCount(RegionEntry re) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        re.decRefCount(this.getEvictionList(), lr);
    }

    @Override
    public boolean lruLimitExceeded(DiskRegionView diskRegionView) {
        return this.getEvictionController().lruLimitExceeded(this.getEvictionController().getStatistics(), diskRegionView);
    }

    @Override
    public void lruCloseStats() {
        this.getEvictionList().closeStats();
    }

    @Override
    boolean confirmEvictionDestroy(RegionEntry re) {
        EvictableEntry lruRe = (EvictableEntry)re;
        if (lruRe.isInUseByTransaction() || lruRe.isDestroyed()) {
            lruRe.unsetEvicted();
            return false;
        }
        return true;
    }

    @Override
    public long getEvictions() {
        return this.getEvictionController().getStatistics().getEvictions();
    }

    @Override
    public void incRecentlyUsed() {
        this.getEvictionList().incrementRecentlyUsed();
    }
}

