/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.ClientMembershipMessage;
import org.apache.geode.internal.cache.ClientSubscriptionConfigImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;

public abstract class AbstractCacheServer
implements InternalCacheServer {
    public static final String TEST_OVERRIDE_DEFAULT_PORT_PROPERTY = "gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT";
    protected final InternalCache cache;
    protected int port;
    protected int maxConnections;
    protected int maxThreads;
    protected boolean notifyBySubscription = true;
    protected int socketBufferSize;
    protected boolean tcpNoDelay;
    protected int maximumTimeBetweenPings;
    protected int maximumMessageCount;
    protected int messageTimeToLive;
    protected String[] groups;
    protected ServerLoadProbe loadProbe;
    protected String bindAddress;
    protected String hostnameForClients;
    protected long loadPollInterval;
    protected ClientSubscriptionConfig clientSubscriptionConfig;
    protected final ClientMembershipListener listener;

    public AbstractCacheServer(InternalCache cache) {
        this(cache, true);
    }

    public AbstractCacheServer(InternalCache cache, boolean attachListener) {
        this.cache = cache;
        this.port = Integer.getInteger(TEST_OVERRIDE_DEFAULT_PORT_PROPERTY, 40404);
        this.maxConnections = 800;
        this.maxThreads = 0;
        this.socketBufferSize = 32768;
        this.tcpNoDelay = true;
        this.maximumTimeBetweenPings = 60000;
        this.maximumMessageCount = 230000;
        this.messageTimeToLive = 180;
        this.groups = CacheServer.DEFAULT_GROUPS;
        this.bindAddress = "";
        this.hostnameForClients = "";
        this.loadProbe = CacheServer.DEFAULT_LOAD_PROBE;
        this.loadPollInterval = 5000L;
        this.clientSubscriptionConfig = new ClientSubscriptionConfigImpl();
        if (!attachListener) {
            this.listener = null;
            return;
        }
        this.listener = new ClientMembershipListener(){

            @Override
            public void memberJoined(ClientMembershipEvent event) {
                if (event.isClient()) {
                    this.createAndSendMessage(event, 0);
                }
            }

            @Override
            public void memberLeft(ClientMembershipEvent event) {
                if (event.isClient()) {
                    this.createAndSendMessage(event, 1);
                }
            }

            @Override
            public void memberCrashed(ClientMembershipEvent event) {
                if (event.isClient()) {
                    this.createAndSendMessage(event, 2);
                }
            }

            private void createAndSendMessage(ClientMembershipEvent event, int type) {
                DM dm;
                Set<InternalDistributedMember> adminMemberSet;
                InternalDistributedSystem ds = null;
                InternalCache cacheInstance = AbstractCacheServer.this.cache;
                ds = cacheInstance != null && !(cacheInstance instanceof CacheCreation) ? (InternalDistributedSystem)cacheInstance.getDistributedSystem() : InternalDistributedSystem.getAnyInstance();
                if (ds != null && ds.isConnected() && !(adminMemberSet = (dm = ds.getDistributionManager()).getAdminMemberSet()).isEmpty()) {
                    DistributedMember member = event.getMember();
                    ClientMembershipMessage msg = new ClientMembershipMessage(event.getMemberId(), member == null ? null : member.getHost(), type);
                    msg.setRecipients(adminMemberSet);
                    dm.putOutgoing(msg);
                }
            }
        };
        ClientMembership.registerClientMembershipListener(this.listener);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    @Override
    public String getHostnameForClients() {
        return this.hostnameForClients;
    }

    @Override
    public void setHostnameForClients(String name) {
        this.hostnameForClients = name;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxCon) {
        this.maxConnections = maxCon;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void setNotifyBySubscription(boolean b) {
    }

    @Override
    public boolean getNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @Override
    public void setMaximumMessageCount(int maximumMessageCount) {
        this.maximumMessageCount = maximumMessageCount;
    }

    @Override
    public int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @Override
    public void setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    @Override
    public void setGroups(String[] groups) {
        if (groups == null) {
            this.groups = CacheServer.DEFAULT_GROUPS;
        } else if (groups.length > 0) {
            String[] copy = new String[groups.length];
            System.arraycopy(groups, 0, copy, 0, groups.length);
            this.groups = copy;
        } else {
            this.groups = CacheServer.DEFAULT_GROUPS;
        }
    }

    @Override
    public String[] getGroups() {
        String[] result = this.groups;
        if (result.length > 0) {
            String[] copy = new String[result.length];
            System.arraycopy(result, 0, copy, 0, result.length);
            result = copy;
        }
        return result;
    }

    @Override
    public ServerLoadProbe getLoadProbe() {
        return this.loadProbe;
    }

    @Override
    public void setLoadProbe(ServerLoadProbe loadProbe) {
        this.loadProbe = loadProbe;
    }

    @Override
    public long getLoadPollInterval() {
        return this.loadPollInterval;
    }

    @Override
    public void setLoadPollInterval(long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    @Override
    public void setTcpNoDelay(boolean setting) {
        this.tcpNoDelay = setting;
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public Cache getCache() {
        return this.cache;
    }

    private static boolean eq(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public boolean sameAs(CacheServer other) {
        return this.getPort() == other.getPort() && AbstractCacheServer.eq(this.getBindAddress(), other.getBindAddress()) && this.getSocketBufferSize() == other.getSocketBufferSize() && this.getMaximumTimeBetweenPings() == other.getMaximumTimeBetweenPings() && this.getNotifyBySubscription() == other.getNotifyBySubscription() && this.getMaxConnections() == other.getMaxConnections() && this.getMaxThreads() == other.getMaxThreads() && this.getMaximumMessageCount() == other.getMaximumMessageCount() && this.getMessageTimeToLive() == other.getMessageTimeToLive() && Arrays.equals(this.getGroups(), other.getGroups()) && this.getLoadProbe().equals(other.getLoadProbe()) && this.getLoadPollInterval() == other.getLoadPollInterval() && this.getTcpNoDelay() == other.getTcpNoDelay();
    }
}

