/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.cache.AbstractLRURegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.concurrent.ConcurrentHashSet;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBucketRegionQueue
extends BucketRegion {
    protected static final Logger logger = LogService.getLogger();
    private final long maximumSize = 0x100000L * Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_SIZE_MB", -1L);
    private final long throttleTime = Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_TIME_MS", 100L);
    private final EvictionStatistics stats;
    private final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    private final GatewaySenderStats gatewaySenderStats;
    protected volatile boolean initialized = false;
    private final ConcurrentHashSet<Object> failedBatchRemovalMessageKeys = new ConcurrentHashSet();

    AbstractBucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.stats = ((AbstractLRURegionMap)this.getRegionMap()).getLRUStatistics();
        this.gatewaySenderStats = this.getPartitionedRegion().getParallelGatewaySender().getStatistics();
    }

    @Override
    public boolean supportsConcurrencyChecks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitIfQueueFull() {
        if (this.maximumSize <= 0L) {
            return;
        }
        if (this.stats.getCounter() > this.maximumSize) {
            try {
                EvictionStatistics evictionStatistics = this.stats;
                synchronized (evictionStatistics) {
                    this.stats.wait(this.throttleTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEntriesRemoved() {
        if (this.maximumSize > 0L) {
            EvictionStatistics evictionStatistics = this.stats;
            synchronized (evictionStatistics) {
                this.stats.notifyAll();
            }
        }
    }

    @Override
    protected void distributeUpdateOperation(EntryEventImpl event, long lastModified) {
    }

    @Override
    protected boolean needWriteLock(EntryEventImpl event) {
        return false;
    }

    @Override
    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        return System.currentTimeMillis();
    }

    @Override
    protected void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
        if (logger.isDebugEnabled()) {
            logger.debug("For Key {}, BasicDestroyBeforeRemoval: no need to send destroy operation to remote nodes. This will be done using BatchRemoval Message.", event.getKey());
        }
    }

    @Override
    protected void distributeDestroyOperation(EntryEventImpl event) {
    }

    @Override
    protected void updateSizeOnClearRegion(int sizeBeforeClear) {
    }

    public ReentrantReadWriteLock getInitializationLock() {
        return this.initializationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKey(Object key) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug(" destroying primary key {}", key);
        }
        EntryEventImpl event = this.getPartitionedRegion().newDestroyEntryEvent(key, null);
        event.setEventId(new EventID(this.cache.getInternalDistributedSystem()));
        try {
            event.setRegion(this);
            this.basicDestroy(event, true, null);
            this.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.getPartitionedRegion().isDestroyed()) {
                this.getPartitionedRegion().checkReadiness();
                if (this.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket moved", new RegionDestroyedException(LocalizedStrings.PartitionedRegionDataStore_REGION_HAS_BEEN_DESTROYED.toLocalizedString(), this.getPartitionedRegion().getFullPath()));
                }
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved while destroying key " + key, rde);
            }
        }
        finally {
            event.release();
        }
        this.notifyEntriesRemoved();
    }

    public void decQueueSize(int size) {
        this.gatewaySenderStats.decQueueSize(size);
    }

    public void decQueueSize() {
        this.gatewaySenderStats.decQueueSize();
    }

    public void incQueueSize(int size) {
        this.gatewaySenderStats.incQueueSize(size);
    }

    public void incQueueSize() {
        this.gatewaySenderStats.incQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEventsFromTempQueue() {
        ConcurrentParallelGatewaySenderQueue prq;
        BlockingQueue<GatewaySenderEventImpl> tempQueue;
        Set<RegionQueue> queues;
        if (logger.isDebugEnabled()) {
            logger.debug("For bucket {} about to load events from the temp queue...", (Object)this.getId());
        }
        if ((queues = this.getPartitionedRegion().getParallelGatewaySender().getQueues()) != null && (tempQueue = (prq = (ConcurrentParallelGatewaySenderQueue)queues.toArray()[0]).getBucketTmpQueue(this.getId())) != null && !tempQueue.isEmpty()) {
            BlockingQueue<GatewaySenderEventImpl> blockingQueue = tempQueue;
            synchronized (blockingQueue) {
                try {
                    GatewaySenderEventImpl event;
                    this.getInitializationLock().writeLock().lock();
                    while ((event = (GatewaySenderEventImpl)tempQueue.poll()) != null) {
                        try {
                            event.setPossibleDuplicate(true);
                            if (!this.addToQueue(event.getShadowKey(), event)) continue;
                            event = null;
                        }
                        catch (ForceReattemptException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("For bucket {} , enqueing event {} caused exception", (Object)this.getId(), (Object)event, (Object)e);
                        }
                        finally {
                            if (event == null) continue;
                            event.release();
                        }
                    }
                }
                finally {
                    if (!tempQueue.isEmpty()) {
                        for (GatewaySenderEventImpl e : tempQueue) {
                            e.release();
                        }
                        tempQueue.clear();
                    }
                    this.getInitializationLock().writeLock().unlock();
                }
            }
        }
    }

    protected void markEventsAsDuplicate(Iterator itr) {
        int i = 0;
        while (itr.hasNext()) {
            Object key = itr.next();
            Object senderEvent = this.getNoLRU(key, true, false, false);
            if (senderEvent != null) {
                ((GatewaySenderEventImpl)senderEvent).setPossibleDuplicate(true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Set possibleDuplicate to true on event: {}", senderEvent);
                }
            }
            ++i;
        }
    }

    @Override
    public void forceSerialized(EntryEventImpl event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        try {
            boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
            if (success) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Key : ----> {}", event.getKey());
                }
            } else {
                GatewaySenderEventImpl.release(event.getRawNewValue());
            }
            boolean bl = success;
            return bl;
        }
        finally {
            GatewaySenderEventImpl.release(event.getRawOldValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        try {
            super.basicDestroy(event, cacheWrite, expectedOldValue);
        }
        finally {
            GatewaySenderEventImpl.release(event.getRawOldValue());
        }
    }

    public Collection<BucketRegion> getCorrespondingUserPRBuckets() {
        ArrayList<BucketRegion> userPRBuckets = new ArrayList<BucketRegion>(4);
        Map<String, PartitionedRegion> colocatedPRs = ColocationHelper.getAllColocationRegions(this.getPartitionedRegion());
        for (PartitionedRegion colocatedPR : colocatedPRs.values()) {
            BucketRegion parentBucket;
            if (colocatedPR.isShadowPR() || !this.isThisSenderAttached(colocatedPR) || (parentBucket = colocatedPR.getDataStore().getLocalBucketById(this.getId())) == null) continue;
            userPRBuckets.add(parentBucket);
        }
        return userPRBuckets;
    }

    private boolean isThisSenderAttached(PartitionedRegion pr) {
        return pr.getParallelGatewaySenderIds().contains(this.getPartitionedRegion().getParallelGatewaySender().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToQueue(Object key, Object value) throws ForceReattemptException {
        if (this.failedBatchRemovalMessageKeys.remove(key)) {
            return false;
        }
        boolean didPut = false;
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = EntryEventImpl.create((LocalRegion)this, Operation.UPDATE, key, value, null, false, this.getMyId());
        event.copyOffHeapToHeap();
        if (logger.isDebugEnabled()) {
            logger.debug("Value : {}", event.getRawNewValue());
        }
        this.waitIfQueueFull();
        try {
            didPut = this.virtualPut(event, false, false, null, false, startPut, true);
            this.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved", rde);
            }
        }
        finally {
            if (!didPut) {
                GatewaySenderEventImpl.release(value);
            }
        }
        if (this.failedBatchRemovalMessageKeys.remove(key) && didPut) {
            this.destroyKey(key);
            didPut = false;
        } else {
            this.addToEventQueue(key, didPut, event);
        }
        return didPut;
    }

    @Override
    public void closeEntries() {
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                AbstractBucketRegionQueue.super.closeEntries();
            }
        });
        this.clearQueues();
    }

    @Override
    public Set<VersionSource> clearEntries(final RegionVersionVector rvv) {
        final AtomicReference result = new AtomicReference();
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                result.set(AbstractBucketRegionQueue.super.clearEntries(rvv));
            }
        });
        this.clearQueues();
        return (Set)result.get();
    }

    protected abstract void clearQueues();

    protected abstract void addToEventQueue(Object var1, boolean var2, EntryEventImpl var3);

    @Override
    public void afterAcquiringPrimaryState() {
        super.afterAcquiringPrimaryState();
        this.notifyEventProcessor();
    }

    protected void notifyEventProcessor() {
        AbstractGatewaySenderEventProcessor ep;
        AbstractGatewaySender sender = this.getPartitionedRegion().getParallelGatewaySender();
        if (sender != null && (ep = sender.getEventProcessor()) != null) {
            ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
            if (logger.isDebugEnabled()) {
                logger.debug("notifyEventProcessor : {} event processor {} queue {}", (Object)sender, (Object)ep, (Object)queue);
            }
            queue.notifyEventProcessorIfRequired(this.getId());
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void addToFailedBatchRemovalMessageKeys(Object key) {
        this.failedBatchRemovalMessageKeys.add(key);
    }

    public ConcurrentHashSet<Object> getFailedBatchRemovalMessageKeys() {
        return this.failedBatchRemovalMessageKeys;
    }
}

