/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.StoreSysCfgResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class StoreSysCfgRequest
extends AdminRequest {
    Config sc;

    public static StoreSysCfgRequest create(Config sc) {
        StoreSysCfgRequest m = new StoreSysCfgRequest();
        m.sc = sc;
        return m;
    }

    public StoreSysCfgRequest() {
        this.friendlyName = LocalizedStrings.StoreSysCfgRequest_APPLY_CONFIGURATION_PARAMETERS.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        return StoreSysCfgResponse.create(dm, this.getSender(), this.sc);
    }

    @Override
    public int getDSFID() {
        return 1057;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.sc, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.sc = (Config)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "StoreSysCfgRequest from " + this.getRecipient() + " syscfg=" + this.sc;
    }
}

