/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.CancellationRegistry;
import org.apache.geode.internal.admin.remote.RegionSubRegionsSizeResponse;

public class RegionSubRegionSizeRequest
extends AdminRequest
implements Cancellable {
    private transient boolean cancelled = false;
    private transient RegionSubRegionsSizeResponse resp = null;

    public RegionSubRegionSizeRequest() {
        this.friendlyName = "Refresh the Member's Regions' Statuses";
    }

    public static RegionSubRegionSizeRequest create() {
        RegionSubRegionSizeRequest m = new RegionSubRegionSizeRequest();
        return m;
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = RegionSubRegionsSizeResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.populateSnapshot(dm);
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public int getDSFID() {
        return 1069;
    }

    @Override
    public String toString() {
        return "RegionSubRegionSizeRequest sent to " + this.getRecipient() + " from " + this.getSender();
    }
}

