/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteCacheStatistics;

public class RegionStatisticsResponse
extends AdminResponse {
    RemoteCacheStatistics regionStatistics;

    public static RegionStatisticsResponse create(DM dm, InternalDistributedMember recipient, Region r) {
        RegionStatisticsResponse m = new RegionStatisticsResponse();
        m.setRecipient(recipient);
        m.regionStatistics = new RemoteCacheStatistics(r.getStatistics());
        return m;
    }

    public CacheStatistics getRegionStatistics() {
        return this.regionStatistics;
    }

    @Override
    public int getDSFID() {
        return 1048;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.regionStatistics, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionStatistics = (RemoteCacheStatistics)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RegionStatisticsResponse from " + this.getRecipient();
    }
}

