/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteRegionAttributes;

public class RegionAttributesResponse
extends AdminResponse {
    private RemoteRegionAttributes attributes;

    public static RegionAttributesResponse create(DM dm, InternalDistributedMember recipient, Region r) {
        RegionAttributesResponse m = new RegionAttributesResponse();
        m.setRecipient(recipient);
        m.attributes = new RemoteRegionAttributes(r.getAttributes());
        return m;
    }

    public RegionAttributes getRegionAttributes() {
        return this.attributes;
    }

    @Override
    public int getDSFID() {
        return 1042;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.attributes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.attributes = (RemoteRegionAttributes)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RegionAttributesResponse from " + this.getRecipient();
    }
}

