/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.CancellationRegistry;
import org.apache.geode.internal.admin.remote.ObjectDetailsResponse;
import org.apache.geode.internal.admin.remote.RegionAdminRequest;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ObjectDetailsRequest
extends RegionAdminRequest
implements Cancellable {
    private Object objName;
    private int inspectionType;
    private transient boolean cancelled;
    private ObjectDetailsResponse resp;

    public static ObjectDetailsRequest create(Object objName, int inspectionType) {
        ObjectDetailsRequest m = new ObjectDetailsRequest();
        m.objName = objName;
        m.inspectionType = inspectionType;
        return m;
    }

    public ObjectDetailsRequest() {
        this.friendlyName = LocalizedStrings.ObjectDetailsRequest_INSPECT_CACHED_OBJECT.toLocalizedString();
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = ObjectDetailsResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.buildDetails(this.getRegion(dm.getSystem()), this.objName, this.inspectionType);
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    @Override
    public int getDSFID() {
        return 1037;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.objName, out);
        out.writeInt(this.inspectionType);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.objName = DataSerializer.readObject(in);
        this.inspectionType = in.readInt();
    }

    @Override
    public String toString() {
        return "ObjectDetailsRequest from " + this.getRecipient() + " region=" + this.getRegionName() + " object=" + this.objName;
    }
}

