/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.FetchStatsResponse;

public class FetchStatsRequest
extends AdminRequest {
    private String statisticsTypeName;

    public static FetchStatsRequest create(String statisticsTypeName) {
        FetchStatsRequest m = new FetchStatsRequest();
        m.statisticsTypeName = statisticsTypeName;
        return m;
    }

    public FetchStatsRequest() {
        this.friendlyName = "List statistic resources";
        this.statisticsTypeName = null;
    }

    @Override
    public AdminResponse createResponse(DM dm) {
        return FetchStatsResponse.create(dm, this.getSender(), this.statisticsTypeName);
    }

    @Override
    public int getDSFID() {
        return 1029;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.statisticsTypeName, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.statisticsTypeName = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "FetchStatsRequest from " + this.getRecipient();
    }
}

