/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.FetchResourceAttributesResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class FetchResourceAttributesRequest
extends AdminRequest {
    private long resourceUniqueId;

    public static FetchResourceAttributesRequest create(long id) {
        FetchResourceAttributesRequest m = new FetchResourceAttributesRequest();
        m.resourceUniqueId = id;
        return m;
    }

    public FetchResourceAttributesRequest() {
        this.friendlyName = LocalizedStrings.FetchResourceAttributesRequest_FETCH_STATISTICS_FOR_RESOURCE.toLocalizedString();
    }

    @Override
    public AdminResponse createResponse(DM dm) {
        return FetchResourceAttributesResponse.create(dm, this.getSender(), this.resourceUniqueId);
    }

    @Override
    public int getDSFID() {
        return 1027;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.resourceUniqueId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.resourceUniqueId = in.readLong();
    }

    @Override
    public String toString() {
        return LocalizedStrings.FetchResourceAttributesRequest_FETCHRESOURCEATTRIBUTESREQUEST_FOR_0.toLocalizedString(this.getRecipient());
    }
}

