/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.DurableClientInfoRequest;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;

public class DurableClientInfoResponse
extends AdminResponse {
    private boolean returnVal = false;

    public static DurableClientInfoResponse create(DM dm, InternalDistributedMember recipient, DurableClientInfoRequest request) {
        DurableClientInfoResponse m = new DurableClientInfoResponse();
        m.setRecipient(recipient);
        try {
            InternalCache c = (InternalCache)CacheFactory.getInstanceCloseOk(dm.getSystem());
            if (!c.getCacheServers().isEmpty()) {
                CacheServerImpl server = (CacheServerImpl)c.getCacheServers().iterator().next();
                switch (request.action) {
                    case 10: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasDurableClient(request.durableId);
                        break;
                    }
                    case 11: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasPrimaryForDurableClient(request.durableId);
                    }
                }
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        return m;
    }

    boolean getResultBoolean() {
        return this.returnVal;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.returnVal);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.returnVal = in.readBoolean();
    }

    @Override
    public String toString() {
        return "DurableClientInfoResponse from " + this.getSender();
    }

    @Override
    public int getDSFID() {
        return -23;
    }
}

