/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.RegionAdminMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DestroyEntryMessage
extends RegionAdminMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private ExpirationAction action;

    public static DestroyEntryMessage create(Object key, ExpirationAction action) {
        DestroyEntryMessage m = new DestroyEntryMessage();
        m.action = action;
        m.key = key;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                if (this.action == ExpirationAction.LOCAL_DESTROY) {
                    r.localDestroy(this.key);
                } else if (this.action == ExpirationAction.DESTROY) {
                    r.destroy(this.key);
                } else if (this.action == ExpirationAction.INVALIDATE) {
                    r.invalidate(this.key);
                } else if (this.action == ExpirationAction.LOCAL_INVALIDATE) {
                    r.localInvalidate(this.key);
                }
            }
            catch (Exception e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DestroEntryMessage_FAILED_ATTEMPT_TO_DESTROY_OR_INVALIDATE_ENTRY_0_1_FROM_CONSOLE_AT_2, new Object[]{r.getFullPath(), this.key, this.getSender()}));
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1019;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.action, out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.action = (ExpirationAction)DataSerializer.readObject(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.DestroyEntryMessage_DESTROYENTRYMESSAGE_FROM_0.toLocalizedString(this.getSender());
    }
}

