/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CancelStatListenerResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CancelStatListenerRequest
extends AdminRequest {
    private int listenerId;

    public static CancelStatListenerRequest create(int listenerId) {
        CancelStatListenerRequest m = new CancelStatListenerRequest();
        m.listenerId = listenerId;
        return m;
    }

    public CancelStatListenerRequest() {
        this.friendlyName = LocalizedStrings.CancelStatListenerRequest_REMOVE_STATISTIC_RESOURCE_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        return CancelStatListenerResponse.create(dm, this.getSender(), this.listenerId);
    }

    @Override
    public int getDSFID() {
        return 1017;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return LocalizedStrings.CancelStatListenerRequest_CANCELSTATLISTENERREQUEST_FROM_0_FOR_1.toLocalizedString(this.getRecipient(), this.listenerId);
    }
}

