/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.BridgeServerResponse;
import org.apache.geode.internal.admin.remote.RemoteBridgeServer;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class BridgeServerRequest
extends AdminRequest {
    static final int ADD_OPERATION = 10;
    static final int INFO_OPERATION = 11;
    static final int START_OPERATION = 12;
    static final int STOP_OPERATION = 13;
    private int cacheId;
    private int operation;
    private RemoteBridgeServer bridgeInfo;
    private int bridgeId;

    public static BridgeServerRequest createForAdd(CacheInfo cache) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 10;
        request.friendlyName = LocalizedStrings.BridgeServerRequest_ADD_BRIDGE_SERVER.toLocalizedString();
        request.bridgeInfo = null;
        return request;
    }

    public static BridgeServerRequest createForInfo(CacheInfo cache, int id) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 11;
        request.friendlyName = LocalizedStrings.BridgeServerRequest_GET_INFO_ABOUT_BRIDGE_SERVER_0.toLocalizedString(id);
        request.bridgeId = id;
        request.bridgeInfo = null;
        return request;
    }

    public static BridgeServerRequest createForStart(CacheInfo cache, RemoteBridgeServer bridge) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 12;
        request.friendlyName = LocalizedStrings.BridgeServerRequest_START_BRIDGE_SERVER_0.toLocalizedString(bridge);
        request.bridgeInfo = bridge;
        return request;
    }

    public static BridgeServerRequest createForStop(CacheInfo cache, RemoteBridgeServer bridge) {
        BridgeServerRequest request = new BridgeServerRequest();
        request.cacheId = cache.getId();
        request.operation = 13;
        request.friendlyName = LocalizedStrings.BridgeServerRequest_STOP_BRIDGE_SERVER_0.toLocalizedString(bridge);
        request.bridgeInfo = bridge;
        return request;
    }

    private static String getOperationDescription(int op) {
        switch (op) {
            case 10: {
                return LocalizedStrings.BridgeServerRequest_ADD_BRIDGE_SERVER.toLocalizedString();
            }
            case 11: {
                return LocalizedStrings.BridgeServerRequest_GET_INFO_ABOUT_BRIDGE_SERVER_0.toLocalizedString();
            }
        }
        return LocalizedStrings.BridgeServerRequest_UNKNOWN_OPERATION_0.toLocalizedString(op);
    }

    @Override
    protected AdminResponse createResponse(DM dm) {
        return BridgeServerResponse.create(dm, this);
    }

    int getCacheId() {
        return this.cacheId;
    }

    int getOperation() {
        return this.operation;
    }

    int getBridgeId() {
        return this.bridgeId;
    }

    RemoteBridgeServer getBridgeInfo() {
        return this.bridgeInfo;
    }

    @Override
    public int getDSFID() {
        return 1010;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.cacheId);
        out.writeInt(this.operation);
        DataSerializer.writeObject(this.bridgeInfo, out);
        out.writeInt(this.bridgeId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cacheId = in.readInt();
        this.operation = in.readInt();
        this.bridgeInfo = (RemoteBridgeServer)DataSerializer.readObject(in);
        this.bridgeId = in.readInt();
    }

    @Override
    public String toString() {
        return "BridgeServerRequest: " + BridgeServerRequest.getOperationDescription(this.operation);
    }
}

