/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.SmHelper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.net.SocketCreator;

public class VersionDescription {
    public static final String RESOURCE_NAME = "GemFireVersion.properties";
    public static final String PRODUCT_NAME = "Product-Name";
    public static final String PRODUCT_VERSION = "Product-Version";
    public static final String SOURCE_DATE = "Source-Date";
    public static final String SOURCE_REVISION = "Source-Revision";
    public static final String SOURCE_REPOSITORY = "Source-Repository";
    public static final String BUILD_DATE = "Build-Date";
    public static final String BUILD_ID = "Build-Id";
    public static final String BUILD_PLATFORM = "Build-Platform";
    public static final String BUILD_JAVA_VERSION = "Build-Java-Version";
    private final Properties description;
    private final Optional<String> error;

    public VersionDescription(String name) {
        InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), name);
        if (is == null) {
            this.error = Optional.of(LocalizedStrings.GemFireVersion_COULD_NOT_FIND_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0.toLocalizedString(name));
            this.description = null;
            return;
        }
        this.description = new Properties();
        try {
            this.description.load(is);
        }
        catch (Exception ex) {
            this.error = Optional.of(LocalizedStrings.GemFireVersion_COULD_NOT_READ_PROPERTIES_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0_BECAUSE_1.toLocalizedString(name, ex));
            return;
        }
        this.error = this.validate(this.description);
    }

    public String getProperty(String key) {
        return this.error.orElseGet(() -> this.description.getProperty(key));
    }

    private String getNativeCodeVersion() {
        return SmHelper.getNativeVersion();
    }

    void print(PrintWriter pw) {
        if (this.error.isPresent()) {
            pw.println(this.error.get());
        } else {
            for (Map.Entry<Object, Object> props : new TreeMap<Object, Object>(this.description).entrySet()) {
                pw.println(props.getKey() + ": " + props.getValue());
            }
        }
        pw.println("Native version: " + this.getNativeCodeVersion());
        this.printHostInfo(pw);
    }

    private void printHostInfo(PrintWriter pw) throws Error {
        try {
            String sb = SocketCreator.getLocalHost().toString() + ", " + Runtime.getRuntime().availableProcessors() + " cpu(s), " + SystemUtils.getOsArchitecture() + ' ' + SystemUtils.getOsName() + ' ' + SystemUtils.getOsVersion() + ' ';
            pw.println(LocalizedStrings.GemFireVersion_RUNNING_ON_0.toLocalizedString(sb));
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
    }

    private Optional<String> validate(Properties props) {
        if (props.get(PRODUCT_NAME) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_NAME, RESOURCE_NAME));
        }
        if (props.get(PRODUCT_VERSION) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_VERSION, RESOURCE_NAME));
        }
        if (props.get(SOURCE_DATE) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_DATE, RESOURCE_NAME));
        }
        if (props.get(SOURCE_REVISION) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REVISION, RESOURCE_NAME));
        }
        if (props.get(SOURCE_REPOSITORY) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REPOSITORY, RESOURCE_NAME));
        }
        if (props.get(BUILD_DATE) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_DATE, RESOURCE_NAME));
        }
        if (props.get(BUILD_ID) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_ID, RESOURCE_NAME));
        }
        if (props.get(BUILD_PLATFORM) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_PLATFORM, RESOURCE_NAME));
        }
        if (props.get(BUILD_JAVA_VERSION) == null) {
            return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_JAVA_VERSION, RESOURCE_NAME));
        }
        return Optional.empty();
    }
}

