/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.internal.DistributedSystemService;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InputStreamFilter;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import sun.misc.ObjectInputFilter;

public class ObjectInputStreamFilterWrapper
implements InputStreamFilter {
    private static final Logger logger = LogService.getLogger();
    private final ObjectInputFilter serializationFilter;

    public ObjectInputStreamFilterWrapper(String serializationFilterSpec, Collection<DistributedSystemService> services) {
        HashSet<String> sanctionedClasses = new HashSet<String>(500);
        for (DistributedSystemService service : services) {
            try {
                Collection<String> classNames = service.getSerializationWhitelist();
                logger.info("loaded {} sanctioned serializables from {}", (Object)classNames.size(), (Object)service.getClass().getSimpleName());
                sanctionedClasses.addAll(classNames);
            }
            catch (IOException e) {
                throw new InternalGemFireException("error initializing serialization filter for " + service, e);
            }
        }
        try {
            URL sanctionedSerializables = ClassPathLoader.getLatest().getResource(InternalDataSerializer.class, "sanctioned-geode-core-serializables.txt");
            Collection<String> coreClassNames = InternalDataSerializer.loadClassNames(sanctionedSerializables);
            sanctionedClasses.addAll(coreClassNames);
        }
        catch (IOException e) {
            throw new InternalGemFireException("unable to read sanctionedSerializables.txt to form a serialization white-list", e);
        }
        logger.info("setting a serialization filter containing {}", (Object)serializationFilterSpec);
        ObjectInputFilter userFilter = ObjectInputFilter.Config.createFilter((String)serializationFilterSpec);
        this.serializationFilter = filterInfo -> {
            if (filterInfo.serialClass() == null) {
                return userFilter.checkInput(filterInfo);
            }
            String className = filterInfo.serialClass().getName();
            if (filterInfo.serialClass().isArray()) {
                className = filterInfo.serialClass().getComponentType().getName();
            }
            if (sanctionedClasses.contains(className)) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            ObjectInputFilter.Status status = userFilter.checkInput(filterInfo);
            if (status == ObjectInputFilter.Status.REJECTED) {
                logger.fatal("Serialization filter is rejecting class {}", (Object)className, (Object)new Exception(""));
            }
            return status;
        };
    }

    @Override
    public void setFilterOn(ObjectInputStream objectInputStream) {
        ObjectInputFilter.Config.setObjectInputFilter((ObjectInputStream)objectInputStream, (ObjectInputFilter)this.serializationFilter);
    }
}

