/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Version;

public class HeartbeatRequestMessage
extends HighPriorityDistributionMessage {
    int requestId;
    InternalDistributedMember target;

    public HeartbeatRequestMessage(InternalDistributedMember neighbour, int id) {
        this.requestId = id;
        this.target = neighbour;
    }

    public HeartbeatRequestMessage() {
    }

    public InternalDistributedMember getTarget() {
        return this.target;
    }

    public void clearRequestId() {
        this.requestId = -1;
    }

    @Override
    public int getDSFID() {
        return -154;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [requestId=" + this.requestId + "]";
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.requestId);
        DataSerializer.writeObject(this.target, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.requestId = in.readInt();
        this.target = (InternalDistributedMember)DataSerializer.readObject(in);
    }
}

