/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersResponse;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListResponse;
import org.apache.geode.cache.client.internal.locator.LocatorStatusResponse;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LocatorLoadSnapshot;
import org.apache.geode.distributed.internal.LocatorStats;
import org.apache.geode.distributed.internal.ProductUseLog;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.ControllerAdvisor;
import org.apache.geode.internal.cache.FindDurableQueueProcessor;
import org.apache.geode.internal.cache.GridAdvisor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

public class ServerLocator
implements TcpHandler,
DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    private final int port;
    private final String hostNameForClients;
    private InternalDistributedSystem ds;
    private ControllerAdvisor advisor;
    private final int serialNumber = ServerLocator.createSerialNumber();
    private final LocatorStats stats;
    private LocatorLoadSnapshot loadSnapshot = new LocatorLoadSnapshot();
    private Map<ServerLocation, DistributedMember> ownerMap = new HashMap<ServerLocation, DistributedMember>();
    private volatile List<ServerLocation> cachedLocators;
    private final Object cachedLocatorsLock = new Object();
    private static final AtomicInteger profileSN = new AtomicInteger();
    private static final long SERVER_LOAD_LOG_INTERVAL = 3600000L;
    private final String logFile;
    private final String hostName;
    private final String memberName;
    private ProductUseLog productUseLog;
    private volatile long lastLogTime;

    ServerLocator() throws IOException {
        this.port = 10334;
        this.hostNameForClients = this.hostName = SocketCreator.getLocalHost().getCanonicalHostName();
        this.logFile = null;
        this.memberName = null;
        this.ds = null;
        this.advisor = null;
        this.stats = null;
    }

    public LocatorLoadSnapshot getLoadSnapshot() {
        return this.loadSnapshot;
    }

    public ServerLocator(int port, InetAddress bindAddress, String hostNameForClients, File logFile, ProductUseLog productUseLogWriter, String memberName, InternalDistributedSystem ds, LocatorStats stats) throws IOException {
        this.port = port;
        this.hostName = bindAddress == null ? SocketCreator.getLocalHost().getCanonicalHostName() : bindAddress.getHostAddress();
        this.hostNameForClients = hostNameForClients != null && !hostNameForClients.equals("") ? hostNameForClients : this.hostName;
        this.logFile = logFile != null ? logFile.getCanonicalPath() : null;
        this.memberName = memberName;
        this.productUseLog = productUseLogWriter;
        this.ds = ds;
        this.advisor = ControllerAdvisor.createControllerAdvisor(this);
        this.stats = stats;
    }

    public String getHostName() {
        return this.hostNameForClients;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.ds.getCancelCriterion();
    }

    @Override
    public void init(TcpServer tcpServer) {
        if (this.ds != null && !this.ds.isReconnecting()) {
            this.advisor.handshake();
        }
    }

    protected boolean readyToProcessRequests() {
        return this.ds != null;
    }

    @Override
    public Object processRequest(Object request) {
        Object response;
        if (!this.readyToProcessRequests()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ServerLocator: Received request {}", request);
        }
        if (!(request instanceof ServerLocationRequest)) {
            throw new InternalGemFireException("Expected ServerLocationRequest, got " + request.getClass());
        }
        int id = ((DataSerializableFixedID)request).getDSFID();
        switch (id) {
            case 2155: {
                response = new LocatorStatusResponse().initialize(this.port, this.hostName, this.logFile, this.memberName);
                break;
            }
            case -54: {
                response = this.getLocatorListResponse((LocatorListRequest)request);
                break;
            }
            case -48: {
                response = this.pickReplacementServer((ClientReplacementRequest)request);
                break;
            }
            case -43: {
                response = this.pickAllServers((GetAllServersRequest)request);
                break;
            }
            case -53: {
                response = this.pickServer((ClientConnectionRequest)request);
                break;
            }
            case -52: {
                response = this.pickQueueServers((QueueConnectionRequest)request);
                break;
            }
            default: {
                throw new InternalGemFireException("Unknown ServerLocationRequest: " + request.getClass());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ServerLocator: Sending response {}", response);
        }
        return response;
    }

    private ClientConnectionResponse pickServer(ClientConnectionRequest clientRequest) {
        ServerLocation location = this.loadSnapshot.getServerForConnection(clientRequest.getServerGroup(), clientRequest.getExcludedServers());
        return new ClientConnectionResponse(location);
    }

    private ClientConnectionResponse pickReplacementServer(ClientReplacementRequest clientRequest) {
        ServerLocation location = this.loadSnapshot.getReplacementServerForConnection(clientRequest.getCurrentServer(), clientRequest.getServerGroup(), clientRequest.getExcludedServers());
        return new ClientConnectionResponse(location);
    }

    private GetAllServersResponse pickAllServers(GetAllServersRequest clientRequest) {
        ArrayList servers = this.loadSnapshot.getServers(clientRequest.getServerGroup());
        return new GetAllServersResponse(servers);
    }

    private Object getLocatorListResponse(LocatorListRequest request) {
        List<ServerLocation> controllers = this.getLocators();
        boolean balanced = this.loadSnapshot.hasBalancedConnections(request.getServerGroup());
        return new LocatorListResponse(controllers, balanced);
    }

    private Object pickQueueServers(QueueConnectionRequest clientRequest) {
        List candidates;
        HashSet excludedServers = new HashSet(clientRequest.getExcludedServers());
        ArrayList servers = new ArrayList();
        boolean durableQueueFound = false;
        if (clientRequest.isFindDurable() && clientRequest.getProxyId().isDurable()) {
            servers = FindDurableQueueProcessor.sendAndFind(this, clientRequest.getProxyId(), this.getDistributionManager());
            excludedServers.addAll(servers);
            boolean bl = durableQueueFound = servers.size() > 0;
        }
        if (clientRequest.getRedundantCopies() == -1) {
            candidates = this.loadSnapshot.getServersForQueue(clientRequest.getProxyId(), clientRequest.getServerGroup(), excludedServers, -1);
        } else if (clientRequest.getRedundantCopies() > servers.size()) {
            int count = clientRequest.getRedundantCopies() - servers.size();
            candidates = this.loadSnapshot.getServersForQueue(clientRequest.getProxyId(), clientRequest.getServerGroup(), excludedServers, count);
        } else {
            candidates = Collections.EMPTY_LIST;
        }
        if (candidates.size() > 1) {
            Collections.shuffle(candidates);
        }
        servers.addAll(candidates);
        return new QueueConnectionResponse(durableQueueFound, servers);
    }

    @Override
    public void shutDown() {
        this.advisor.close();
        this.loadSnapshot.shutDown();
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, ClusterConfigurationService sharedConfig) {
        if (ds != null) {
            this.loadSnapshot = new LocatorLoadSnapshot();
            this.ds = (InternalDistributedSystem)ds;
            this.advisor = ControllerAdvisor.createControllerAdvisor(this);
            if (ds.isConnected()) {
                this.advisor.handshake();
            }
        }
    }

    @Override
    public DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.advisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.getDistributionAdvisor().createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.ds;
    }

    @Override
    public String getName() {
        return "ServerLocator";
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getFullPath() {
        return this.getName();
    }

    public InternalDistributedSystem getDs() {
        return this.ds;
    }

    private static int createSerialNumber() {
        return profileSN.incrementAndGet();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof ControllerAdvisor.ControllerProfile);
        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)profile;
        cp.setHost(this.hostNameForClients);
        cp.setPort(this.port);
        cp.serialNumber = this.getSerialNumber();
        cp.finishInit();
    }

    public void setLocatorCount(int count) {
        this.stats.setLocatorCount(count);
    }

    public void setServerCount(int count) {
        this.stats.setServerCount(count);
    }

    @Override
    public void endRequest(Object request, long startTime) {
        this.stats.endLocatorRequest(startTime);
    }

    @Override
    public void endResponse(Object request, long startTime) {
        this.stats.endLocatorResponse(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServerLocation> getLocators() {
        if (this.cachedLocators != null) {
            return this.cachedLocators;
        }
        Object object = this.cachedLocatorsLock;
        synchronized (object) {
            List profiles = this.advisor.fetchControllers();
            ArrayList<ServerLocation> result = new ArrayList<ServerLocation>(profiles.size() + 1);
            for (ControllerAdvisor.ControllerProfile profile : profiles) {
                result.add(ServerLocator.buildServerLocation(profile));
            }
            result.add(new ServerLocation(this.hostNameForClients, this.port));
            this.cachedLocators = result;
            return result;
        }
    }

    protected static ServerLocation buildServerLocation(GridAdvisor.GridProfile p) {
        return new ServerLocation(p.getHost(), p.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileCreated(DistributionAdvisor.Profile profile) {
        if (profile instanceof CacheServerAdvisor.CacheServerProfile) {
            CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
            ServerLocation location = ServerLocator.buildServerLocation(bp);
            String[] groups = bp.getGroups();
            this.loadSnapshot.addServer(location, groups, bp.getInitialLoad(), bp.getLoadPollInterval());
            if (logger.isDebugEnabled()) {
                logger.debug("ServerLocator: Received load from a new server {}, {}", (Object)location, (Object)bp.getInitialLoad());
            }
            Map<ServerLocation, DistributedMember> map = this.ownerMap;
            synchronized (map) {
                this.ownerMap.put(location, profile.getDistributedMember());
            }
        } else {
            this.cachedLocators = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile instanceof CacheServerAdvisor.CacheServerProfile) {
            CacheServerAdvisor.CacheServerProfile bp = (CacheServerAdvisor.CacheServerProfile)profile;
            ServerLocation location = ServerLocator.buildServerLocation(bp);
            this.loadSnapshot.removeServer(location);
            if (logger.isDebugEnabled()) {
                logger.debug("ServerLocator: server departed {}", (Object)location);
            }
            Map<ServerLocation, DistributedMember> map = this.ownerMap;
            synchronized (map) {
                this.ownerMap.remove(location);
            }
        } else {
            this.cachedLocators = null;
        }
    }

    public void profileUpdated(DistributionAdvisor.Profile profile) {
        this.cachedLocators = null;
        this.getLogWriterI18n().warning(LocalizedStrings.ServerLocator_SERVERLOCATOR_UNEXPECTED_PROFILE_UPDATE);
    }

    public void updateLoad(ServerLocation location, ServerLoad load, List clientIds) {
        if (this.getLogWriterI18n().fineEnabled()) {
            this.getLogWriterI18n().fine("ServerLocator: Received a load update from " + location + ", " + load);
        }
        this.loadSnapshot.updateLoad(location, load, clientIds);
        this.stats.incServerLoadUpdates();
        this.logServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logServers() {
        if (this.productUseLog != null) {
            HashSet<DistributedMember> servers;
            Object l2;
            long lastLogTime;
            Map loadMap = this.getLoadMap();
            if (loadMap.size() == 0) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now < (lastLogTime = this.lastLogTime) + 3600000L) {
                return;
            }
            this.lastLogTime = now;
            int queues = 0;
            int connections = 0;
            for (Object l2 : loadMap.values()) {
                queues = (int)((float)queues + ((ServerLoad)l2).getSubscriptionConnectionLoad());
                connections = (int)Math.ceil(((ServerLoad)l2).getConnectionLoad() / ((ServerLoad)l2).getLoadPerConnection());
            }
            l2 = this.ownerMap;
            synchronized (l2) {
                servers = new HashSet<DistributedMember>(this.ownerMap.values());
            }
            StringBuilder sb = new StringBuilder(1000);
            sb.append("server count: ").append(servers.size()).append(" connected client count: ").append(connections).append(" client subscription queue count: ").append(queues).append(System.lineSeparator()).append("current servers : ");
            Object[] ids = new String[servers.size()];
            int i = 0;
            for (DistributedMember id : servers) {
                ids[i++] = id.toString();
            }
            Arrays.sort(ids);
            for (i = 0; i < ids.length; ++i) {
                sb.append((String)ids[i]).append(' ');
            }
            this.productUseLog.log(sb.toString());
        }
    }

    public Map getLoadMap() {
        return this.loadSnapshot.getLoadMap();
    }

    LogWriterI18n getLogWriterI18n() {
        return this.ds.getLogWriter().convertToLogWriterI18n();
    }
}

