/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HealthMonitor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.locks.ElderState;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.net.SocketCreator;

public class LonerDistributionManager
implements DM {
    private final InternalDistributedSystem system;
    private final InternalLogWriter logger;
    private ElderState elderState;
    private final InternalDistributedMember id;
    private final Set<InternalDistributedMember> allIds;
    private final List<InternalDistributedMember> viewMembers;
    private ConcurrentMap<InternalDistributedMember, InternalDistributedMember> canonicalIds = new ConcurrentHashMap<InternalDistributedMember, InternalDistributedMember>();
    private static final DummyDMStats stats = new DummyDMStats();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private int lonerPort = 0;
    private final Stopper stopper = new Stopper();
    private volatile InternalCache cache;

    public LonerDistributionManager(InternalDistributedSystem system, InternalLogWriter logger) {
        this.system = system;
        this.logger = logger;
        this.id = this.generateMemberId();
        this.allIds = Collections.singleton(this.id);
        this.viewMembers = new ArrayList<InternalDistributedMember>(this.allIds);
        DistributionStats.enableClockStats = this.system.getConfig().getEnableTimeStatistics();
    }

    protected void startThreads() {
    }

    protected void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError("Interrupted while waiting for DM shutdown");
        }
    }

    @Override
    public long cacheTimeMillis() {
        return this.system.getClock().cacheTimeMillis();
    }

    @Override
    public InternalDistributedMember getDistributionManagerId() {
        return this.id;
    }

    @Override
    public Set getDistributionManagerIds() {
        return this.allIds;
    }

    @Override
    public Set getDistributionManagerIdsIncludingAdmin() {
        return this.allIds;
    }

    public Serializable[] getDirectChannels(InternalDistributedMember[] ids) {
        return ids;
    }

    @Override
    public InternalDistributedMember getCanonicalId(DistributedMember dmid) {
        InternalDistributedMember iid = (InternalDistributedMember)dmid;
        InternalDistributedMember result = this.canonicalIds.putIfAbsent(iid, iid);
        if (result != null) {
            return result;
        }
        return iid;
    }

    @Override
    public Set getOtherDistributionManagerIds() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set getOtherNormalDistributionManagerIds() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set getAllOtherMembers() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void retainMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        Iterator<InternalDistributedMember> it = members.iterator();
        while (it.hasNext()) {
            InternalDistributedMember id = it.next();
            if (id.getVersionObject().compareTo(version) >= 0) continue;
            it.remove();
        }
    }

    @Override
    public void removeMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        Iterator<InternalDistributedMember> it = members.iterator();
        while (it.hasNext()) {
            InternalDistributedMember id = it.next();
            if (id.getVersionObject().compareTo(version) < 0) continue;
            it.remove();
        }
    }

    @Override
    public Set addMembershipListenerAndGetDistributionManagerIds(MembershipListener l) {
        return this.allIds;
    }

    @Override
    public Set addAllMembershipListenerAndGetAllIds(MembershipListener l) {
        return this.allIds;
    }

    public int getDistributionManagerCount() {
        return 0;
    }

    @Override
    public InternalDistributedMember getId() {
        return this.getDistributionManagerId();
    }

    @Override
    public boolean isAdam() {
        return true;
    }

    @Override
    public InternalDistributedMember getElderId() {
        return this.getId();
    }

    @Override
    public boolean isElder() {
        return true;
    }

    @Override
    public boolean isLoner() {
        return true;
    }

    @Override
    public synchronized ElderState getElderState(boolean force, boolean useTryLock) {
        if (this.elderState == null) {
            this.elderState = new ElderState(this);
        }
        return this.elderState;
    }

    @Override
    public long getMembershipPort() {
        return 0L;
    }

    public Set putOutgoingUserData(DistributionMessage message) {
        if (message.forAll() || message.getRecipients().length == 0) {
            return null;
        }
        throw new RuntimeException(LocalizedStrings.LonerDistributionManager_LONER_TRIED_TO_SEND_MESSAGE_TO_0.toLocalizedString(message.getRecipientsDescription()));
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    @Override
    public void addMembershipListener(MembershipListener l) {
    }

    @Override
    public void removeMembershipListener(MembershipListener l) {
    }

    @Override
    public void removeAllMembershipListener(MembershipListener l) {
    }

    @Override
    public void addAdminConsole(InternalDistributedMember p_id) {
    }

    @Override
    public DMStats getStats() {
        return stats;
    }

    @Override
    public DistributionConfig getConfig() {
        DistributionConfig result = null;
        if (this.getSystem() != null) {
            result = this.getSystem().getConfig();
        }
        return result;
    }

    @Override
    public void handleManagerDeparture(InternalDistributedMember p_id, boolean crashed, String reason) {
    }

    public LogWriterI18n getLoggerI18n() {
        return this.logger;
    }

    public InternalLogWriter getInternalLogWriter() {
        return this.logger;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.executor;
    }

    @Override
    public ExecutorService getHighPriorityThreadPool() {
        return this.executor;
    }

    @Override
    public ExecutorService getWaitingThreadPool() {
        return this.executor;
    }

    @Override
    public ExecutorService getPrMetaDataCleanupThreadPool() {
        return this.executor;
    }

    @Override
    public Executor getFunctionExcecutor() {
        return this.executor;
    }

    public Map getChannelMap() {
        return null;
    }

    public Map getMemberMap() {
        return null;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void restartCommunications() {
    }

    @Override
    public List<InternalDistributedMember> getViewMembers() {
        return this.viewMembers;
    }

    @Override
    public DistributedMember getOldestMember(Collection members) throws NoSuchElementException {
        DistributedMember member;
        if (members.size() == 1 && (member = (DistributedMember)members.iterator().next()).equals(this.viewMembers.get(0))) {
            return member;
        }
        throw new NoSuchElementException(LocalizedStrings.LonerDistributionManager_MEMBER_NOT_FOUND_IN_MEMBERSHIP_SET.toLocalizedString());
    }

    public Set getAdminMemberSet() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void throwIfDistributionStopped() {
        this.stopper.checkCancelInProgress(null);
    }

    @Override
    public int getRoleCount(Role role) {
        return this.id.getRoles().contains(role) ? 1 : 0;
    }

    @Override
    public boolean isRolePresent(Role role) {
        return this.id.getRoles().contains(role);
    }

    @Override
    public Set getAllRoles() {
        return this.id.getRoles();
    }

    private InternalDistributedMember generateMemberId() {
        InternalDistributedMember result = null;
        try {
            StringBuffer sb = new StringBuffer();
            long time = System.currentTimeMillis() & 0xFFFFFFFFL;
            for (int i = 0; i < 4; ++i) {
                String hex = Integer.toHexString((int)(time & 0xFFL));
                if (hex.length() < 2) {
                    sb.append('0');
                }
                sb.append(hex);
                time /= 256L;
            }
            String uniqueString = sb.toString();
            String name = this.system.getName();
            InetAddress hostAddr = SocketCreator.getLocalHost();
            String host = SocketCreator.use_client_host_name ? hostAddr.getCanonicalHostName() : hostAddr.getHostAddress();
            DistributionConfig config = this.system.getConfig();
            DurableClientAttributes dac = null;
            if (config.getDurableClientId() != null) {
                dac = new DurableClientAttributes(config.getDurableClientId(), config.getDurableClientTimeout());
            }
            result = new InternalDistributedMember(host, this.lonerPort, name, uniqueString, 13, MemberAttributes.parseGroups(config.getRoles(), config.getGroups()), dac);
        }
        catch (UnknownHostException ex) {
            throw new InternalGemFireError(LocalizedStrings.LonerDistributionManager_CANNOT_RESOLVE_LOCAL_HOST_NAME_TO_AN_IP_ADDRESS.toLocalizedString());
        }
        return result;
    }

    public void updateLonerPort(int newPort) {
        this.logger.config(LocalizedStrings.LonerDistributionmanager_CHANGING_PORT_FROM_TO, new Object[]{this.lonerPort, newPort, this.getId()});
        this.lonerPort = newPort;
        this.getId().setPort(this.lonerPort);
    }

    @Override
    public boolean isCurrentMember(InternalDistributedMember p_id) {
        return this.getId().equals(p_id);
    }

    @Override
    public Set putOutgoing(DistributionMessage msg) {
        return null;
    }

    @Override
    public boolean shutdownInProgress() {
        return false;
    }

    @Override
    public void removeUnfinishedStartup(InternalDistributedMember m, boolean departed) {
    }

    @Override
    public void setUnfinishedStartups(Collection s) {
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    @Override
    public MembershipManager getMembershipManager() {
        return null;
    }

    @Override
    public Throwable getRootCause() {
        return null;
    }

    @Override
    public void setRootCause(Throwable t) {
    }

    @Override
    public Set<InternalDistributedMember> getMembersInThisZone() {
        return this.allIds;
    }

    @Override
    public void acquireGIIPermitUninterruptibly() {
    }

    @Override
    public void releaseGIIPermit() {
    }

    @Override
    public int getDistributedSystemId() {
        return this.getSystem().getConfig().getDistributedSystemId();
    }

    @Override
    public boolean enforceUniqueZone() {
        return this.system.getConfig().getEnforceUniqueHost() || this.system.getConfig().getRedundancyZone() != null;
    }

    @Override
    public boolean areInSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
        return false;
    }

    @Override
    public boolean areOnEquivalentHost(InternalDistributedMember member1, InternalDistributedMember member2) {
        return member1 == member2;
    }

    @Override
    public Set<InternalDistributedMember> getMembersInSameZone(InternalDistributedMember acceptedMember) {
        return Collections.singleton(acceptedMember);
    }

    @Override
    public Set<InetAddress> getEquivalents(InetAddress in) {
        HashSet<InetAddress> value = new HashSet<InetAddress>();
        value.add(this.getId().getInetAddress());
        return value;
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        if (this.getDistributionManagerId().getGroups().contains(group)) {
            return Collections.singleton(this.getDistributionManagerId());
        }
        return Collections.emptySet();
    }

    @Override
    public void addHostedLocators(InternalDistributedMember member, Collection<String> locators, boolean isSharedConfigurationEnabled) {
    }

    @Override
    public Collection<String> getHostedLocators(InternalDistributedMember member) {
        return Collections.emptyList();
    }

    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocators() {
        return Collections.emptyMap();
    }

    @Override
    public Set getNormalDistributionManagerIds() {
        return this.getDistributionManagerIds();
    }

    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocatorsWithSharedConfiguration() {
        return Collections.emptyMap();
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
    }

    @Override
    public int getDMType() {
        return 0;
    }

    @Override
    public void setCache(InternalCache instance) {
        this.cache = instance;
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public InternalCache getExistingCache() {
        InternalCache result = this.cache;
        if (result == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        result.getCancelCriterion().checkCancelInProgress(null);
        if (result.isClosed()) {
            throw result.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        return result;
    }

    @Override
    public HealthMonitor getHealthMonitor(InternalDistributedMember owner) {
        throw new UnsupportedOperationException("getHealthMonitor is not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public void removeHealthMonitor(InternalDistributedMember owner, int theId) {
        throw new UnsupportedOperationException("removeHealthMonitor is not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public void createHealthMonitor(InternalDistributedMember owner, GemFireHealthConfig cfg) {
        throw new UnsupportedOperationException("createHealthMonitor is not supported by " + this.getClass().getSimpleName());
    }

    protected static class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            return null;
        }
    }

    private static class CompletedFuture<T>
    implements Future<T> {
        private final T result;
        private final Exception ex;

        public CompletedFuture(T result, Exception ex) {
            this.result = result;
            this.ex = ex;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.ex != null) {
                throw new ExecutionException(this.ex);
            }
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    protected static class DummyExecutor
    implements ExecutorService {
        protected DummyExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            Exception ex = null;
            Object result = null;
            try {
                result = task.call();
            }
            catch (Exception e) {
                ex = e;
            }
            return new CompletedFuture<Object>(result, ex);
        }

        @Override
        public <T> Future<T> submit(final Runnable task, final T result) {
            return this.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    task.run();
                    return result;
                }
            });
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.submit(task, null);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            ArrayList<Future<T>> results = new ArrayList<Future<T>>();
            for (Callable<T> task : tasks) {
                results.add(this.submit(task));
            }
            return results;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.invokeAll(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Throwable ex = null;
            for (Callable<T> task : tasks) {
                try {
                    return this.submit(task).get();
                }
                catch (ExecutionException e) {
                    ex = e;
                }
            }
            throw (ExecutionException)ex.fillInStackTrace();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.invokeAny(tasks);
        }
    }

    public static class DummyDMStats
    implements DMStats {
        @Override
        public long getSentMessages() {
            return 0L;
        }

        @Override
        public void incSentMessages(long messages) {
        }

        @Override
        public void incTOSentMsg() {
        }

        @Override
        public long getSentCommitMessages() {
            return 0L;
        }

        @Override
        public void incSentCommitMessages(long messages) {
        }

        @Override
        public long getCommitWaits() {
            return 0L;
        }

        @Override
        public void incCommitWaits() {
        }

        @Override
        public long getSentMessagesTime() {
            return 0L;
        }

        @Override
        public void incSentMessagesTime(long nanos) {
        }

        @Override
        public long getBroadcastMessages() {
            return 0L;
        }

        @Override
        public void incBroadcastMessages(long messages) {
        }

        @Override
        public long getBroadcastMessagesTime() {
            return 0L;
        }

        @Override
        public void incBroadcastMessagesTime(long nanos) {
        }

        @Override
        public long getReceivedMessages() {
            return 0L;
        }

        @Override
        public void incReceivedMessages(long messages) {
        }

        @Override
        public long getReceivedBytes() {
            return 0L;
        }

        @Override
        public void incReceivedBytes(long bytes) {
        }

        @Override
        public void incSentBytes(long bytes) {
        }

        @Override
        public long getProcessedMessages() {
            return 0L;
        }

        @Override
        public void incProcessedMessages(long messages) {
        }

        @Override
        public long getProcessedMessagesTime() {
            return 0L;
        }

        @Override
        public void incProcessedMessagesTime(long nanos) {
        }

        @Override
        public long getMessageProcessingScheduleTime() {
            return 0L;
        }

        @Override
        public void incMessageProcessingScheduleTime(long nanos) {
        }

        @Override
        public int getOverflowQueueSize() {
            return 0;
        }

        @Override
        public void incOverflowQueueSize(int messages) {
        }

        @Override
        public int getNumProcessingThreads() {
            return 0;
        }

        @Override
        public void incNumProcessingThreads(int threads) {
        }

        @Override
        public int getNumSerialThreads() {
            return 0;
        }

        @Override
        public void incNumSerialThreads(int threads) {
        }

        @Override
        public void incMessageChannelTime(long val) {
        }

        @Override
        public void incUDPDispatchRequestTime(long val) {
        }

        @Override
        public long getUDPDispatchRequestTime() {
            return 0L;
        }

        @Override
        public long getReplyMessageTime() {
            return 0L;
        }

        @Override
        public void incReplyMessageTime(long val) {
        }

        @Override
        public long getDistributeMessageTime() {
            return 0L;
        }

        @Override
        public void incDistributeMessageTime(long val) {
        }

        @Override
        public int getNodes() {
            return 0;
        }

        @Override
        public void setNodes(int val) {
        }

        @Override
        public void incNodes(int val) {
        }

        @Override
        public int getReplyWaitsInProgress() {
            return 0;
        }

        @Override
        public int getReplyWaitsCompleted() {
            return 0;
        }

        @Override
        public long getReplyWaitTime() {
            return 0L;
        }

        @Override
        public long startReplyWait() {
            return 0L;
        }

        @Override
        public void endReplyWait(long startNanos, long startMillis) {
        }

        @Override
        public void incReplyTimeouts() {
        }

        @Override
        public long getReplyTimeouts() {
            return 0L;
        }

        @Override
        public void incReceivers() {
        }

        @Override
        public void decReceivers() {
        }

        @Override
        public void incFailedAccept() {
        }

        @Override
        public void incFailedConnect() {
        }

        @Override
        public void incReconnectAttempts() {
        }

        @Override
        public void incLostLease() {
        }

        @Override
        public void incSenders(boolean shared, boolean preserveOrder) {
        }

        @Override
        public void decSenders(boolean shared, boolean preserveOrder) {
        }

        @Override
        public int getSendersSU() {
            return 0;
        }

        @Override
        public long startSocketWrite(boolean sync) {
            return 0L;
        }

        @Override
        public void endSocketWrite(boolean sync, long start, int bytesWritten, int retries) {
        }

        @Override
        public long startSerialization() {
            return 0L;
        }

        @Override
        public void endSerialization(long start, int bytes) {
        }

        @Override
        public long startDeserialization() {
            return 0L;
        }

        @Override
        public void endDeserialization(long start, int bytes) {
        }

        @Override
        public long startMsgSerialization() {
            return 0L;
        }

        @Override
        public void endMsgSerialization(long start) {
        }

        @Override
        public long startMsgDeserialization() {
            return 0L;
        }

        @Override
        public void endMsgDeserialization(long start) {
        }

        @Override
        public void incBatchSendTime(long start) {
        }

        @Override
        public void incBatchCopyTime(long start) {
        }

        @Override
        public void incBatchWaitTime(long start) {
        }

        @Override
        public void incBatchFlushTime(long start) {
        }

        @Override
        public void incUcastWriteBytes(int bytesWritten) {
        }

        @Override
        public void incMcastWriteBytes(int bytesWritten) {
        }

        @Override
        public void incUcastRetransmits() {
        }

        @Override
        public void incMcastRetransmits() {
        }

        @Override
        public void incMcastRetransmitRequests() {
        }

        @Override
        public int getMcastRetransmits() {
            return 0;
        }

        @Override
        public int getMcastWrites() {
            return 0;
        }

        @Override
        public int getMcastReads() {
            return 0;
        }

        @Override
        public void incUcastReadBytes(int amount) {
        }

        @Override
        public void incMcastReadBytes(int amount) {
        }

        @Override
        public int getAsyncSocketWritesInProgress() {
            return 0;
        }

        @Override
        public int getAsyncSocketWrites() {
            return 0;
        }

        @Override
        public int getAsyncSocketWriteRetries() {
            return 0;
        }

        @Override
        public long getAsyncSocketWriteBytes() {
            return 0L;
        }

        @Override
        public long getAsyncSocketWriteTime() {
            return 0L;
        }

        @Override
        public int getAsyncQueues() {
            return 0;
        }

        @Override
        public void incAsyncQueues(int inc) {
        }

        @Override
        public int getAsyncQueueFlushesInProgress() {
            return 0;
        }

        @Override
        public int getAsyncQueueFlushesCompleted() {
            return 0;
        }

        @Override
        public long getAsyncQueueFlushTime() {
            return 0L;
        }

        @Override
        public long startAsyncQueueFlush() {
            return 0L;
        }

        @Override
        public void endAsyncQueueFlush(long start) {
        }

        @Override
        public int getAsyncQueueTimeouts() {
            return 0;
        }

        @Override
        public void incAsyncQueueTimeouts(int inc) {
        }

        @Override
        public int getAsyncQueueSizeExceeded() {
            return 0;
        }

        @Override
        public void incAsyncQueueSizeExceeded(int inc) {
        }

        @Override
        public int getAsyncDistributionTimeoutExceeded() {
            return 0;
        }

        @Override
        public void incAsyncDistributionTimeoutExceeded() {
        }

        @Override
        public long getAsyncQueueSize() {
            return 0L;
        }

        @Override
        public void incAsyncQueueSize(long inc) {
        }

        @Override
        public long getAsyncQueuedMsgs() {
            return 0L;
        }

        @Override
        public void incAsyncQueuedMsgs() {
        }

        @Override
        public long getAsyncDequeuedMsgs() {
            return 0L;
        }

        @Override
        public void incAsyncDequeuedMsgs() {
        }

        @Override
        public long getAsyncConflatedMsgs() {
            return 0L;
        }

        @Override
        public void incAsyncConflatedMsgs() {
        }

        @Override
        public int getAsyncThreads() {
            return 0;
        }

        @Override
        public void incAsyncThreads(int inc) {
        }

        @Override
        public int getAsyncThreadInProgress() {
            return 0;
        }

        @Override
        public int getAsyncThreadCompleted() {
            return 0;
        }

        @Override
        public long getAsyncThreadTime() {
            return 0L;
        }

        @Override
        public long startAsyncThread() {
            return 0L;
        }

        @Override
        public void endAsyncThread(long start) {
        }

        @Override
        public long getAsyncQueueAddTime() {
            return 0L;
        }

        @Override
        public void incAsyncQueueAddTime(long inc) {
        }

        @Override
        public long getAsyncQueueRemoveTime() {
            return 0L;
        }

        @Override
        public void incAsyncQueueRemoveTime(long inc) {
        }

        @Override
        public void incReceiverBufferSize(int inc, boolean direct) {
        }

        @Override
        public void incSenderBufferSize(int inc, boolean direct) {
        }

        @Override
        public long startSocketLock() {
            return 0L;
        }

        @Override
        public void endSocketLock(long start) {
        }

        @Override
        public long startBufferAcquire() {
            return 0L;
        }

        @Override
        public void endBufferAcquire(long start) {
        }

        @Override
        public void incMessagesBeingReceived(boolean newMsg, int bytes) {
        }

        @Override
        public void decMessagesBeingReceived(int bytes) {
        }

        @Override
        public void incReplyHandOffTime(long start) {
        }

        @Override
        public int getElders() {
            return 0;
        }

        @Override
        public void incElders(int val) {
        }

        @Override
        public int getInitialImageMessagesInFlight() {
            return 0;
        }

        @Override
        public void incInitialImageMessagesInFlight(int val) {
        }

        @Override
        public int getInitialImageRequestsInProgress() {
            return 0;
        }

        @Override
        public void incInitialImageRequestsInProgress(int val) {
        }

        @Override
        public void incPdxSerialization(int bytesWritten) {
        }

        @Override
        public void incPdxDeserialization(int i) {
        }

        @Override
        public long startPdxInstanceDeserialization() {
            return 0L;
        }

        @Override
        public void endPdxInstanceDeserialization(long start) {
        }

        @Override
        public void incPdxInstanceCreations() {
        }

        @Override
        public void incThreadOwnedReceivers(long value, int dominoCount) {
        }

        @Override
        public long getHeartbeatRequestsSent() {
            return 0L;
        }

        @Override
        public void incHeartbeatRequestsSent() {
        }

        @Override
        public long getHeartbeatRequestsReceived() {
            return 0L;
        }

        @Override
        public void incHeartbeatRequestsReceived() {
        }

        @Override
        public long getHeartbeatsSent() {
            return 0L;
        }

        @Override
        public void incHeartbeatsSent() {
        }

        @Override
        public long getHeartbeatsReceived() {
            return 0L;
        }

        @Override
        public void incHeartbeatsReceived() {
        }

        @Override
        public long getSuspectsSent() {
            return 0L;
        }

        @Override
        public void incSuspectsSent() {
        }

        @Override
        public long getSuspectsReceived() {
            return 0L;
        }

        @Override
        public void incSuspectsReceived() {
        }

        @Override
        public long getFinalCheckRequestsSent() {
            return 0L;
        }

        @Override
        public void incFinalCheckRequestsSent() {
        }

        @Override
        public long getFinalCheckRequestsReceived() {
            return 0L;
        }

        @Override
        public void incFinalCheckRequestsReceived() {
        }

        @Override
        public long getFinalCheckResponsesSent() {
            return 0L;
        }

        @Override
        public void incFinalCheckResponsesSent() {
        }

        @Override
        public long getFinalCheckResponsesReceived() {
            return 0L;
        }

        @Override
        public void incFinalCheckResponsesReceived() {
        }

        @Override
        public long getTcpFinalCheckRequestsSent() {
            return 0L;
        }

        @Override
        public void incTcpFinalCheckRequestsSent() {
        }

        @Override
        public long getTcpFinalCheckRequestsReceived() {
            return 0L;
        }

        @Override
        public void incTcpFinalCheckRequestsReceived() {
        }

        @Override
        public long getTcpFinalCheckResponsesSent() {
            return 0L;
        }

        @Override
        public void incTcpFinalCheckResponsesSent() {
        }

        @Override
        public long getTcpFinalCheckResponsesReceived() {
            return 0L;
        }

        @Override
        public void incTcpFinalCheckResponsesReceived() {
        }

        @Override
        public long getUdpFinalCheckRequestsSent() {
            return 0L;
        }

        @Override
        public void incUdpFinalCheckRequestsSent() {
        }

        @Override
        public long getUdpFinalCheckResponsesReceived() {
            return 0L;
        }

        @Override
        public void incUdpFinalCheckResponsesReceived() {
        }

        @Override
        public long startUDPMsgEncryption() {
            return 0L;
        }

        @Override
        public void endUDPMsgEncryption(long start) {
        }

        @Override
        public long startUDPMsgDecryption() {
            return 0L;
        }

        @Override
        public void endUDPMsgDecryption(long start) {
        }

        @Override
        public long getUDPMsgEncryptionTiime() {
            return 0L;
        }

        @Override
        public long getUDPMsgDecryptionTime() {
            return 0L;
        }
    }
}

