/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorStatusRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LocatorStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.ProductUseLog;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.membership.MemberFactory;
import org.apache.geode.distributed.internal.membership.QuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.NetLocator;
import org.apache.geode.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import org.apache.geode.distributed.internal.tcpserver.LocatorCancelException;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.TcpServerFactory;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogWriterAppenders;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.management.internal.JmxManagerLocator;
import org.apache.geode.management.internal.JmxManagerLocatorRequest;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.handlers.SharedConfigurationStatusRequestHandler;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusRequest;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class InternalLocator
extends Locator
implements InternalDistributedSystem.ConnectListener {
    private static final Logger logger = LogService.getLogger();
    public static final String FORCE_LOCATOR_DM_TYPE = "Locator.forceLocatorDMType";
    public static final String INHIBIT_DM_BANNER = "Locator.inhibitDMBanner";
    public static final String LOCATORS_PREFERRED_AS_COORDINATORS = "gemfire.disable-floating-coordinator";
    private final TcpServer server;
    private final PrimaryHandler handler;
    private InternalDistributedSystem myDs;
    private InternalCache myCache;
    private ProductUseLog productUseLog;
    private boolean peerLocator;
    private ServerLocator serverLocator;
    protected volatile LocatorStats stats;
    private Properties env;
    private NetLocator locatorImpl;
    private DistributionConfigImpl config;
    private final LocatorMembershipListener locatorListener;
    private WanLocatorDiscoverer locatorDiscoverer;
    private volatile boolean stoppedForReconnect;
    private volatile boolean forcedDisconnect;
    private final AtomicBoolean shutdownHandled = new AtomicBoolean(false);
    private ClusterConfigurationService sharedConfig;
    private volatile boolean isSharedConfigurationStarted = false;
    private volatile Thread restartThread;
    private static InternalLocator locator;
    private static final Object locatorLock;

    boolean isSharedConfigurationEnabled() {
        return this.config.getEnableClusterConfiguration();
    }

    private boolean loadFromSharedConfigDir() {
        return this.config.getLoadClusterConfigFromDir();
    }

    public boolean isSharedConfigurationRunning() {
        return this.sharedConfig != null && this.sharedConfig.getStatus() == SharedConfigurationStatus.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator getLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLocator(InternalLocator locator) {
        if (locator == null) {
            return;
        }
        Object object = locatorLock;
        synchronized (object) {
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.SECURITY);
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.SECURITY);
            if (locator.equals(InternalLocator.locator)) {
                InternalLocator.locator = null;
            }
        }
    }

    public LocatorMembershipListener getlocatorMembershipListener() {
        return this.locatorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator createLocator(int port, File logFile, InternalLogWriter logger, InternalLogWriter securityLogger, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, boolean startDistributedSystem) {
        Object object = locatorLock;
        synchronized (object) {
            InternalLocator locator;
            if (InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            InternalLocator.locator = locator = new InternalLocator(port, logFile, logger, securityLogger, bindAddress, hostnameForClients, distributedSystemProperties, null, startDistributedSystem);
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLocator(InternalLocator locator) {
        Object object = locatorLock;
        synchronized (object) {
            if (InternalLocator.locator != null && InternalLocator.locator != locator) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            InternalLocator.locator = locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator startLocator(int port, File logFile, InternalLogWriter logger, InternalLogWriter securityLogger, InetAddress bindAddress, boolean startDistributedSystem, Properties dsProperties, String hostnameForClients) throws IOException {
        System.setProperty(FORCE_LOCATOR_DM_TYPE, "true");
        InternalLocator newLocator = null;
        boolean startedLocator = false;
        try {
            block12: {
                newLocator = InternalLocator.createLocator(port, logFile, logger, securityLogger, bindAddress, hostnameForClients, dsProperties, startDistributedSystem);
                try {
                    newLocator.startPeerLocation();
                    if (!startDistributedSystem) break block12;
                    try {
                        newLocator.startDistributedSystem();
                    }
                    catch (RuntimeException e) {
                        newLocator.stop();
                        throw e;
                    }
                    InternalDistributedSystem ids = newLocator.myDs;
                    if (ids != null) {
                        ids.getDistributionManager().addHostedLocators(ids.getDistributedMember(), InternalLocator.getLocatorStrings(), newLocator.isSharedConfigurationEnabled());
                    }
                }
                catch (LocatorCancelException ignored) {
                    newLocator.stop();
                }
            }
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            if (sys != null) {
                try {
                    newLocator.startServerLocation(sys);
                }
                catch (RuntimeException e) {
                    newLocator.stop();
                    throw e;
                }
            }
            newLocator.endStartLocator(null);
            startedLocator = true;
            InternalLocator internalLocator = newLocator;
            return internalLocator;
        }
        finally {
            System.getProperties().remove(FORCE_LOCATOR_DM_TYPE);
            if (!startedLocator) {
                InternalLocator.removeLocator(newLocator);
            }
        }
    }

    public static boolean isDedicatedLocator() {
        InternalLocator internalLocator = InternalLocator.getLocator();
        if (internalLocator == null) {
            return false;
        }
        InternalDistributedSystem ids = internalLocator.myDs;
        if (ids == null) {
            return false;
        }
        DM dm = ids.getDistributionManager();
        if (dm.isLoner()) {
            return false;
        }
        DistributionManager distMgr = (DistributionManager)ids.getDistributionManager();
        return distMgr.getDMType() == 11;
    }

    private InternalLocator(int port, File logF, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, DistributionConfigImpl cfg, boolean startDistributedSystem) {
        boolean hasLogFileButConfigDoesNot;
        this.logFile = logF;
        this.bindAddress = bindAddress;
        this.hostnameForClients = hostnameForClients;
        this.config = cfg;
        this.env = new Properties();
        if (bindAddress != null && !bindAddress.isAnyLocalAddress()) {
            this.env.setProperty("bind-address", bindAddress.getHostAddress());
        }
        if (distributedSystemProperties != null) {
            this.env.putAll((Map<?, ?>)distributedSystemProperties);
        }
        this.env.setProperty("cache-xml-file", "");
        if (this.config == null) {
            this.config = new DistributionConfigImpl(this.env);
            this.env.clear();
            this.env.putAll((Map<?, ?>)this.config.getProps());
        }
        boolean bl = hasLogFileButConfigDoesNot = this.logFile != null && this.config.getLogFile().toString().equals(DistributionConfig.DEFAULT_LOG_FILE.toString());
        if (logWriter == null && hasLogFileButConfigDoesNot) {
            this.config.unsafeSetLogFile(this.logFile);
        }
        boolean hasLogFile = this.config.getLogFile() != null && !this.config.getLogFile().equals(new File(""));
        boolean hasSecurityLogFile = this.config.getSecurityLogFile() != null && !this.config.getSecurityLogFile().equals(new File(""));
        LogService.configureLoggers(hasLogFile, hasSecurityLogFile);
        if (hasLogFile || hasSecurityLogFile) {
            if (hasLogFile) {
                LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.MAIN, true, false, this.config, !startDistributedSystem);
            }
            if (hasSecurityLogFile) {
                LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.SECURITY, true, false, this.config, false);
            }
        }
        if (logWriter == null) {
            logWriter = LogWriterFactory.createLogWriterLogger(false, false, this.config, false);
            if (logger.isDebugEnabled()) {
                logger.debug("LogWriter for locator is created.");
            }
        }
        if (securityLogWriter == null) {
            securityLogWriter = LogWriterFactory.createLogWriterLogger(false, true, this.config, false);
            logWriter.setLogWriterLevel(this.config.getSecurityLogLevel());
            securityLogWriter.fine("SecurityLogWriter for locator is created.");
        }
        SocketCreatorFactory.setDistributionConfig(this.config);
        this.locatorListener = WANServiceProvider.createLocatorMembershipListener();
        if (this.locatorListener != null) {
            this.locatorListener.setConfig(this.getConfig());
        }
        this.handler = new PrimaryHandler(this, this.locatorListener);
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Distribution locators", logger);
        this.stats = new LocatorStats();
        this.server = new TcpServerFactory().makeTcpServer(port, this.bindAddress, null, this.config, this.handler, new DelayedPoolStatHelper(), group, this.toString(), this);
    }

    private void startTcpServer() throws IOException {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_0, this));
        this.server.start();
    }

    public ClusterConfigurationService getSharedConfiguration() {
        return this.sharedConfig;
    }

    public DistributionConfigImpl getConfig() {
        return this.config;
    }

    public InternalCache getCache() {
        if (this.myCache == null) {
            return GemFireCacheImpl.getInstance();
        }
        return this.myCache;
    }

    int startPeerLocation() throws IOException {
        boolean locatorsAreCoordinators;
        if (this.isPeerLocator()) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_PEER_LOCATION_IS_ALREADY_RUNNING_FOR_0.toLocalizedString(this));
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_PEER_LOCATION_FOR_0, this));
        String locatorsProp = this.config.getLocators();
        boolean networkPartitionDetectionEnabled = this.config.getEnableNetworkPartitionDetection();
        String securityUDPDHAlgo = this.config.getSecurityUDPDHAlgo();
        if (networkPartitionDetectionEnabled) {
            locatorsAreCoordinators = true;
        } else {
            String prop = this.config.getSecurityPeerAuthInit();
            boolean bl = locatorsAreCoordinators = prop != null && !prop.isEmpty();
            if (!locatorsAreCoordinators) {
                locatorsAreCoordinators = Boolean.getBoolean(LOCATORS_PREFERRED_AS_COORDINATORS);
            }
        }
        this.locatorImpl = MemberFactory.newLocatorHandler(this.bindAddress, locatorsProp, locatorsAreCoordinators, networkPartitionDetectionEnabled, this.stats, securityUDPDHAlgo);
        this.handler.addHandler(PeerLocatorRequest.class, this.locatorImpl);
        this.peerLocator = true;
        if (!this.server.isAlive()) {
            this.startTcpServer();
        }
        int boundPort = this.server.getPort();
        File productUseFile = new File("locator" + boundPort + "views.log");
        this.productUseLog = new ProductUseLog(productUseFile);
        return boundPort;
    }

    public NetLocator getLocatorHandler() {
        return this.locatorImpl;
    }

    @Deprecated
    public static InternalLocator startLocator(int locatorPort, File logFile, InternalLogWriter logger, InternalLogWriter logger1, InetAddress addr, Properties dsProperties, boolean peerLocator, boolean serverLocator, String s, boolean b1) throws IOException {
        return InternalLocator.startLocator(locatorPort, logFile, logger, logger1, addr, true, dsProperties, s);
    }

    private void startDistributedSystem() throws UnknownHostException {
        InternalDistributedSystem existing = InternalDistributedSystem.getConnectedInstance();
        if (existing != null) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_USING_EXISTING_DISTRIBUTED_SYSTEM__0, existing));
            this.startCache(existing);
        } else {
            StringBuilder sb = new StringBuilder(100);
            if (this.bindAddress != null) {
                sb.append(this.bindAddress.getHostAddress());
            } else {
                sb.append(SocketCreator.getLocalHost().getHostAddress());
            }
            sb.append('[').append(this.getPort()).append(']');
            String thisLocator = sb.toString();
            if (this.peerLocator) {
                boolean setLocatorsProp = false;
                String locatorsProp = this.config.getLocators();
                if (StringUtils.isNotBlank((String)locatorsProp)) {
                    if (!locatorsProp.contains(thisLocator)) {
                        locatorsProp = locatorsProp + ',' + thisLocator;
                        setLocatorsProp = true;
                    }
                } else {
                    locatorsProp = thisLocator;
                    setLocatorsProp = true;
                }
                if (setLocatorsProp) {
                    Properties updateEnv = new Properties();
                    updateEnv.setProperty("locators", locatorsProp);
                    this.config.setApiProps(updateEnv);
                    String propName = "gemfire.locators";
                    if (System.getProperty(propName) != null) {
                        System.setProperty(propName, locatorsProp);
                    }
                }
            }
            Properties connectEnv = new Properties();
            connectEnv.put("ds-config", this.config);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_DISTRIBUTED_SYSTEM));
            this.myDs = (InternalDistributedSystem)DistributedSystem.connect(connectEnv);
            if (this.peerLocator) {
                this.locatorImpl.setMembershipManager(this.myDs.getDM().getMembershipManager());
            }
            this.myDs.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                @Override
                public void onDisconnect(InternalDistributedSystem sys) {
                    InternalLocator.this.stop(false, false, false);
                }
            });
            this.startCache(this.myDs);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_LOCATOR_STARTED_ON__0, thisLocator));
            this.myDs.setDependentLocator(this);
        }
    }

    private void startCache(DistributedSystem ds) {
        InternalCache internalCache = GemFireCacheImpl.getInstance();
        if (internalCache == null) {
            logger.info("Creating cache for locator.");
            this.myCache = (InternalCache)new CacheFactory(ds.getProperties()).create();
            internalCache = this.myCache;
        } else {
            logger.info("Using existing cache for locator.");
            ((InternalDistributedSystem)ds).handleResourceEvent(ResourceEvent.LOCATOR_START, this);
        }
        this.startJmxManagerLocationService(internalCache);
        this.startSharedConfigurationService();
    }

    void endStartLocator(InternalDistributedSystem distributedSystem) {
        this.env = null;
        if (distributedSystem == null) {
            distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        if (distributedSystem != null) {
            this.onConnect(distributedSystem);
        } else {
            InternalDistributedSystem.addConnectListener(this);
        }
        this.locatorDiscoverer = WANServiceProvider.createLocatorDiscoverer();
        if (this.locatorDiscoverer != null) {
            this.locatorDiscoverer.discover(this.getPort(), this.config, this.locatorListener, this.hostnameForClients);
        }
    }

    void startServerLocation(InternalDistributedSystem distributedSystem) throws IOException {
        if (this.isServerLocator()) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_SERVER_LOCATION_IS_ALREADY_RUNNING_FOR_0.toLocalizedString(this));
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_SERVER_LOCATION_FOR_0, this));
        if (distributedSystem == null && (distributedSystem = InternalDistributedSystem.getConnectedInstance()) == null) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_SINCE_SERVER_LOCATION_IS_ENABLED_THE_DISTRIBUTED_SYSTEM_MUST_BE_CONNECTED.toLocalizedString());
        }
        ServerLocator serverLocator = new ServerLocator(this.getPort(), this.bindAddress, this.hostnameForClients, this.logFile, this.productUseLog, this.getConfig().getName(), distributedSystem, this.stats);
        this.handler.addHandler(LocatorListRequest.class, serverLocator);
        this.handler.addHandler(ClientConnectionRequest.class, serverLocator);
        this.handler.addHandler(QueueConnectionRequest.class, serverLocator);
        this.handler.addHandler(ClientReplacementRequest.class, serverLocator);
        this.handler.addHandler(GetAllServersRequest.class, serverLocator);
        this.handler.addHandler(LocatorStatusRequest.class, serverLocator);
        this.serverLocator = serverLocator;
        if (!this.server.isAlive()) {
            this.startTcpServer();
        }
        this.productUseLog.monitorUse(distributedSystem);
    }

    @Override
    public void stop() {
        this.stop(false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean forcedDisconnect, boolean stopForReconnect, boolean waitForDisconnect) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        this.stoppedForReconnect = stopForReconnect;
        this.forcedDisconnect = forcedDisconnect;
        if (this.server.isShuttingDown()) {
            if (!stopForReconnect && waitForDisconnect) {
                long endOfWait = System.currentTimeMillis() + 60000L;
                if (isDebugEnabled && this.server.isAlive()) {
                    logger.debug("sleeping to wait for the locator server to shut down...");
                }
                while (this.server.isAlive() && System.currentTimeMillis() < endOfWait) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                if (isDebugEnabled) {
                    if (this.server.isAlive()) {
                        logger.debug("60 seconds have elapsed waiting for the locator server to shut down - terminating wait and returning");
                    } else {
                        logger.debug("the locator server has shut down");
                    }
                }
            }
            return;
        }
        if (this.locatorDiscoverer != null) {
            this.locatorDiscoverer.stop();
            this.locatorDiscoverer = null;
        }
        if (this.server.isAlive()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_STOPPING__0, this));
            try {
                new TcpClient().stop(this.bindAddress, this.getPort());
            }
            catch (ConnectException endOfWait) {
                // empty catch block
            }
            boolean interrupted = Thread.interrupted();
            try {
                this.server.join(60010000L);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_INTERRUPTED_WHILE_STOPPING__0, this), (Throwable)ex);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.server.isAlive()) {
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_COULD_NOT_STOP__0__IN_60_SECONDS, this));
            }
        }
        InternalLocator.removeLocator(this);
        this.handleShutdown();
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_0__IS_STOPPED, this));
        if (this.stoppedForReconnect && this.myDs != null) {
            this.launchRestartThread();
        }
    }

    public boolean isStopped() {
        return this.server == null || !this.server.isAlive();
    }

    private void handleShutdown() {
        if (!this.shutdownHandled.compareAndSet(false, true)) {
            return;
        }
        if (this.productUseLog != null) {
            this.productUseLog.close();
        }
        if (this.myDs != null) {
            this.myDs.setDependentLocator(null);
        }
        if (this.myCache != null && !this.stoppedForReconnect && !this.forcedDisconnect) {
            logger.info("Closing locator's cache");
            try {
                this.myCache.close();
            }
            catch (RuntimeException ex) {
                logger.info("Could not close locator's cache because: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        if (this.stats != null) {
            this.stats.close();
        }
        if (this.locatorListener != null) {
            this.locatorListener.clearLocatorInfo();
        }
        this.isSharedConfigurationStarted = false;
        if (this.myDs != null && !this.forcedDisconnect && this.myDs.isConnected()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.InternalLocator_DISCONNECTING_DISTRIBUTED_SYSTEM_FOR_0, this));
            this.myDs.disconnect();
        }
    }

    public void waitToStop() throws InterruptedException {
        boolean restarted;
        do {
            InternalDistributedSystem ds = this.myDs;
            restarted = false;
            this.server.join();
            if (!this.stoppedForReconnect) continue;
            logger.info("waiting for distributed system to disconnect...");
            while (((DistributedSystem)ds).isConnected()) {
                Thread.sleep(5000L);
            }
            logger.info("waiting for distributed system to reconnect...");
            restarted = ((DistributedSystem)ds).waitUntilReconnected(-1L, TimeUnit.SECONDS);
            if (restarted) {
                logger.info("system restarted");
            } else {
                logger.info("system was not restarted");
            }
            Thread restartThread = this.restartThread;
            if (restartThread == null) continue;
            logger.info("waiting for services to restart...");
            restartThread.join();
            this.restartThread = null;
            logger.info("done waiting for services to restart");
        } while (restarted);
    }

    private void launchRestartThread() {
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Locator restart thread group");
        this.restartThread = new Thread(group, "Location services restart thread"){

            @Override
            public void run() {
                boolean restarted = false;
                try {
                    restarted = InternalLocator.this.attemptReconnect();
                    logger.info("attemptReconnect returned {}", (Object)restarted);
                }
                catch (InterruptedException e) {
                    logger.info("attempt to restart location services was interrupted", (Throwable)e);
                }
                catch (IOException e) {
                    logger.info("attempt to restart location services terminated", (Throwable)e);
                }
                finally {
                    if (!restarted) {
                        InternalLocator.this.stoppedForReconnect = false;
                    }
                }
                InternalLocator.this.restartThread = null;
            }
        };
        this.restartThread.setDaemon(true);
        this.restartThread.start();
    }

    private boolean attemptReconnect() throws InterruptedException, IOException {
        boolean restarted = false;
        if (this.stoppedForReconnect) {
            logger.info("attempting to restart locator");
            boolean tcpServerStarted = false;
            InternalDistributedSystem ds = this.myDs;
            long waitTime = ds.getConfig().getMaxWaitTimeForReconnect() / 2;
            QuorumChecker checker = null;
            while (ds.getReconnectedSystem() == null && !ds.isReconnectCancelled()) {
                boolean start;
                if (checker == null && (checker = this.myDs.getQuorumChecker()) != null) {
                    logger.info("The distributed system returned this quorum checker: {}", (Object)checker);
                }
                if (checker != null && !tcpServerStarted && (start = checker.checkForQuorum(3 * this.myDs.getConfig().getMemberTimeout()))) {
                    logger.info("starting peer location");
                    if (this.locatorListener != null) {
                        this.locatorListener.clearLocatorInfo();
                    }
                    this.stoppedForReconnect = false;
                    this.myDs = null;
                    this.myCache = null;
                    this.restartWithoutDS();
                    tcpServerStarted = true;
                    InternalLocator.setLocator(this);
                }
                ds.waitUntilReconnected(waitTime, TimeUnit.MILLISECONDS);
            }
            InternalDistributedSystem newSystem = (InternalDistributedSystem)ds.getReconnectedSystem();
            if (newSystem != null) {
                if (!tcpServerStarted) {
                    if (this.locatorListener != null) {
                        this.locatorListener.clearLocatorInfo();
                    }
                    this.stoppedForReconnect = false;
                }
                this.restartWithDS(newSystem, GemFireCacheImpl.getInstance());
                InternalLocator.setLocator(this);
                restarted = true;
            }
        }
        logger.info("restart thread exiting.  Service was {}restarted", (Object)(restarted ? "" : "not "));
        return restarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithoutDS() throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            this.myDs = null;
            this.myCache = null;
            logger.info("Locator restart: initializing TcpServer peer location services");
            this.server.restarting(null, null, null);
            if (this.productUseLog.isClosed()) {
                this.productUseLog.reopen();
            }
            if (!this.server.isAlive()) {
                logger.info("Locator restart: starting TcpServer");
                this.startTcpServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithDS(InternalDistributedSystem newSystem, InternalCache newCache) throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            this.myDs = newSystem;
            this.myCache = newCache;
            this.myDs.setDependentLocator(this);
            logger.info("Locator restart: initializing TcpServer");
            this.server.restarting(newSystem, newCache, this.sharedConfig);
            if (this.productUseLog.isClosed()) {
                this.productUseLog.reopen();
            }
            this.productUseLog.monitorUse(newSystem);
            this.startSharedConfigurationService();
            if (!this.server.isAlive()) {
                logger.info("Locator restart: starting TcpServer");
                this.startTcpServer();
            }
            logger.info("Locator restart: initializing JMX manager");
            this.startJmxManagerLocationService(newCache);
            this.endStartLocator(this.myDs);
            logger.info("Locator restart completed");
        }
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        if (this.myDs == null) {
            return InternalDistributedSystem.getAnyInstance();
        }
        return this.myDs;
    }

    @Override
    public boolean isPeerLocator() {
        return this.peerLocator;
    }

    @Override
    public boolean isServerLocator() {
        return this.serverLocator != null;
    }

    public ServerLocator getServerLocatorAdvisee() {
        return this.serverLocator;
    }

    @Override
    public Integer getPort() {
        if (this.server != null) {
            return this.server.getPort();
        }
        return null;
    }

    public SharedConfigurationStatusResponse getSharedConfigurationStatus() {
        SharedConfigurationStatusResponse response;
        ExecutorService es = this.myCache.getDistributionManager().getWaitingThreadPool();
        Future<SharedConfigurationStatusResponse> statusFuture = es.submit(new FetchSharedConfigStatus());
        try {
            response = statusFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("Exception occurred while fetching the status {}", (Object)CliUtil.stackTraceAsString(e));
            response = new SharedConfigurationStatusResponse();
            response.setStatus(SharedConfigurationStatus.UNDETERMINED);
        }
        return response;
    }

    @Override
    public void onConnect(InternalDistributedSystem sys) {
        try {
            this.stats.hookupStats(sys, SocketCreator.getLocalHost().getCanonicalHostName() + '-' + this.server.getBindAddress());
        }
        catch (UnknownHostException e) {
            logger.warn((Object)e);
        }
    }

    public static Collection<String> getLocatorStrings() {
        Collection<String> locatorStrings;
        try {
            Collection<DistributionLocatorId> locatorIds = DistributionLocatorId.asDistributionLocatorIds(InternalLocator.getLocators());
            locatorStrings = DistributionLocatorId.asStrings(locatorIds);
        }
        catch (UnknownHostException ignored) {
            locatorStrings = null;
        }
        if (locatorStrings == null || locatorStrings.isEmpty()) {
            return null;
        }
        return locatorStrings;
    }

    private void startSharedConfigurationService() {
        this.installSharedConfigHandler();
        if (!this.config.getEnableClusterConfiguration()) {
            logger.info("Cluster configuration service is disabled");
            return;
        }
        if (this.isSharedConfigurationStarted) {
            logger.info("Cluster configuration service is already started.");
            return;
        }
        if (!InternalLocator.isDedicatedLocator()) {
            logger.info("Cluster configuration service not enabled as it is only supported in dedicated locators");
            return;
        }
        try {
            if (InternalLocator.locator.sharedConfig == null) {
                InternalLocator.locator.sharedConfig = new ClusterConfigurationService(InternalLocator.locator.myCache);
            }
            InternalLocator.locator.sharedConfig.initSharedConfiguration(locator.loadFromSharedConfigDir());
            logger.info("Cluster configuration service start up completed successfully and is now running ....");
            this.isSharedConfigurationStarted = true;
        }
        catch (CancelException | LockServiceDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cluster configuration start up was cancelled", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void startJmxManagerLocationService(InternalCache internalCache) {
        if (internalCache.getJmxManagerAdvisor() != null && !this.handler.isHandled(JmxManagerLocatorRequest.class)) {
            this.handler.addHandler(JmxManagerLocatorRequest.class, new JmxManagerLocator(internalCache));
        }
    }

    private void installSharedConfigHandler() {
        if (!this.handler.isHandled(SharedConfigurationStatusRequest.class)) {
            this.handler.addHandler(SharedConfigurationStatusRequest.class, new SharedConfigurationStatusRequestHandler());
            logger.info("SharedConfigStatusRequestHandler installed");
        }
    }

    public boolean hasHandlerForClass(Class messageClass) {
        return this.handler.isHandled(messageClass);
    }

    static {
        locatorLock = new Object();
    }

    protected class DelayedPoolStatHelper
    implements PoolStatHelper {
        protected DelayedPoolStatHelper() {
        }

        @Override
        public void startJob() {
            InternalLocator.this.stats.incRequestInProgress(1);
        }

        @Override
        public void endJob() {
            InternalLocator.this.stats.incRequestInProgress(-1);
        }
    }

    public static class PrimaryHandler
    implements TcpHandler {
        private volatile HashMap<Class, TcpHandler> handlerMapping = new HashMap();
        private volatile HashSet<TcpHandler> allHandlers = new HashSet();
        private TcpServer tcpServer;
        private final LocatorMembershipListener locatorListener;
        private final InternalLocator internalLocator;

        PrimaryHandler(InternalLocator locator, LocatorMembershipListener listener) {
            this.locatorListener = listener;
            this.internalLocator = locator;
        }

        @Override
        public synchronized void init(TcpServer tcpServer) {
            if (this.locatorListener != null) {
                this.locatorListener.setPort(this.internalLocator.getPort());
            }
            this.tcpServer = tcpServer;
            for (TcpHandler handler : this.allHandlers) {
                handler.init(tcpServer);
            }
        }

        @Override
        public void restarting(DistributedSystem ds, GemFireCache cache, ClusterConfigurationService sharedConfig) {
            if (ds != null) {
                for (TcpHandler handler : this.allHandlers) {
                    handler.restarting(ds, cache, sharedConfig);
                }
            }
        }

        @Override
        public Object processRequest(Object request) throws IOException {
            long giveup = 0L;
            while (giveup == 0L || System.currentTimeMillis() < giveup) {
                TcpHandler handler = request instanceof PeerLocatorRequest ? this.handlerMapping.get(PeerLocatorRequest.class) : this.handlerMapping.get(request.getClass());
                if (handler != null) {
                    return handler.processRequest(request);
                }
                if (this.locatorListener != null) {
                    return this.locatorListener.handleRequest(request);
                }
                if (giveup != 0L) continue;
                int locatorWaitTime = this.internalLocator.getConfig().getLocatorWaitTime();
                if (locatorWaitTime <= 0) {
                    locatorWaitTime = 30;
                }
                giveup = System.currentTimeMillis() + (long)(locatorWaitTime * 1000);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    return null;
                }
            }
            logger.info("Received a location request of class {} but the handler for this is either not enabled or is not ready to process requests", (Object)request.getClass().getSimpleName());
            return null;
        }

        @Override
        public void shutDown() {
            try {
                for (TcpHandler handler : this.allHandlers) {
                    handler.shutDown();
                }
            }
            finally {
                this.internalLocator.handleShutdown();
            }
        }

        synchronized boolean isHandled(Class clazz) {
            return this.handlerMapping.containsKey(clazz);
        }

        public synchronized void addHandler(Class clazz, TcpHandler handler) {
            HashMap<Class, TcpHandler> tmpHandlerMapping = new HashMap<Class, TcpHandler>(this.handlerMapping);
            HashSet<TcpHandler> tmpAllHandlers = new HashSet<TcpHandler>(this.allHandlers);
            tmpHandlerMapping.put(clazz, handler);
            if (tmpAllHandlers.add(handler) && this.tcpServer != null) {
                handler.init(this.tcpServer);
            }
            this.handlerMapping = tmpHandlerMapping;
            this.allHandlers = tmpAllHandlers;
        }

        @Override
        public void endRequest(Object request, long startTime) {
            TcpHandler handler = this.handlerMapping.get(request.getClass());
            if (handler != null) {
                handler.endRequest(request, startTime);
            }
        }

        @Override
        public void endResponse(Object request, long startTime) {
            TcpHandler handler = this.handlerMapping.get(request.getClass());
            if (handler != null) {
                handler.endResponse(request, startTime);
            }
        }
    }

    class FetchSharedConfigStatus
    implements Callable<SharedConfigurationStatusResponse> {
        static final int SLEEPTIME = 1000;
        static final byte MAX_RETRIES = 5;

        FetchSharedConfigStatus() {
        }

        @Override
        public SharedConfigurationStatusResponse call() throws InterruptedException {
            SharedConfigurationStatusResponse response;
            InternalLocator locator = InternalLocator.this;
            if (locator.sharedConfig != null) {
                response = locator.sharedConfig.createStatusResponse();
            } else {
                response = new SharedConfigurationStatusResponse();
                response.setStatus(SharedConfigurationStatus.UNDETERMINED);
            }
            return response;
        }
    }
}

