/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.NameNotFoundException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.internal.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class MethodDispatch {
    private Class _targetClass;
    private String _methodName;
    private Class[] _argTypes;
    private Method _method;
    private MethodInvocationAuthorizer _methodInvocationAuthorizer;

    public MethodDispatch(MethodInvocationAuthorizer methodInvocationAuthorizer, Class targetClass, String methodName, List argTypes) throws NameResolutionException {
        this._targetClass = targetClass;
        this._methodName = methodName;
        this._argTypes = argTypes.toArray(new Class[argTypes.size()]);
        this._methodInvocationAuthorizer = methodInvocationAuthorizer;
        this.resolve();
        this._method.setAccessible(true);
    }

    public Object invoke(Object target, List args) throws NameNotFoundException, QueryInvocationTargetException {
        Object[] argsArray = args.toArray();
        try {
            this._methodInvocationAuthorizer.authorizeMethodInvocation(this._method, target);
            return this._method.invoke(target, argsArray);
        }
        catch (IllegalAccessException e) {
            throw new NameNotFoundException(LocalizedStrings.MethodDispatch_METHOD_0_IN_CLASS_1_IS_NOT_ACCESSIBLE_TO_THE_QUERY_PROCESSOR.toLocalizedString(this._method.getName(), target.getClass().getName()), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw new QueryInvocationTargetException(t);
            }
            throw new QueryInvocationTargetException(e);
        }
    }

    private void resolve() throws NameResolutionException {
        for (int i = 0; i < this._argTypes.length; ++i) {
            if (this._argTypes[i] != null) continue;
            this.resolveGeneral();
            return;
        }
        try {
            this._method = this._targetClass.getMethod(this._methodName, this._argTypes);
        }
        catch (NoSuchMethodException e) {
            this.resolveGeneral();
        }
    }

    private void resolveGeneral() throws NameResolutionException {
        Method[] allMethods = this._targetClass.getMethods();
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method meth = allMethods[i];
            if (!meth.getName().equals(this._methodName) || meth.getParameterTypes().length != this._argTypes.length || !TypeUtils.areTypesConvertible(this._argTypes, meth.getParameterTypes())) continue;
            candidates.add(meth);
        }
        if (candidates.isEmpty()) {
            throw new NameNotFoundException(LocalizedStrings.MethodDispatch_NO_APPLICABLE_AND_ACCESSIBLE_METHOD_NAMED_0_WAS_FOUND_IN_CLASS_1_FOR_THE_ARGUMENT_TYPES_2.toLocalizedString(this._methodName, this._targetClass.getName(), Arrays.asList(this._argTypes)));
        }
        if (candidates.size() == 1) {
            this._method = (Method)candidates.get(0);
            return;
        }
        this.sortByDecreasingSpecificity(candidates);
        Method meth1 = (Method)candidates.get(0);
        Method meth2 = (Method)candidates.get(1);
        if (this.equalSpecificity(meth1, meth2, this._argTypes)) {
            throw new AmbiguousNameException(LocalizedStrings.MethodDispatch_TWO_OR_MORE_MAXIMALLY_SPECIFIC_METHODS_WERE_FOUND_FOR_THE_METHOD_NAMED_0_IN_CLASS_1_FOR_THE_ARGUMENT_TYPES_2.toLocalizedString(meth1.getName(), this._targetClass.getName(), Arrays.asList(this._argTypes)));
        }
        this._method = meth1;
    }

    private void sortByDecreasingSpecificity(List methods) {
        Collections.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean convertible2;
                Method m1 = (Method)o1;
                Method m2 = (Method)o2;
                if (m1.equals(m2)) {
                    return 0;
                }
                boolean convertible1 = MethodDispatch.this.methodConvertible(m1, m2);
                if (convertible1 == (convertible2 = MethodDispatch.this.methodConvertible(m2, m1))) {
                    return 0;
                }
                return convertible1 ? -1 : 1;
            }
        });
    }

    protected boolean methodConvertible(Method m1, Method m2) {
        boolean declaringClassesConvertible = TypeUtils.isTypeConvertible(m1.getDeclaringClass(), m2.getDeclaringClass());
        boolean paramsConvertible = true;
        Class<?>[] p1 = m1.getParameterTypes();
        Class<?>[] p2 = m2.getParameterTypes();
        for (int i = 0; i < p1.length; ++i) {
            if (TypeUtils.isTypeConvertible(p1[i], p2[i])) continue;
            paramsConvertible = false;
            break;
        }
        return declaringClassesConvertible && paramsConvertible;
    }

    private boolean equalSpecificity(Method m1, Method m2, Class[] argTypes) {
        if (!this.methodConvertible(m1, m2)) {
            return true;
        }
        Class<?>[] p1 = m1.getParameterTypes();
        Class<?>[] p2 = m2.getParameterTypes();
        for (int i = 0; i < p1.length; ++i) {
            if (argTypes[i] == null || p1[i] == p2[i] || !TypeUtils.isTypeConvertible(p1[i], p2[i])) continue;
            return false;
        }
        return true;
    }
}

