/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexCreationException;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RestrictedMethodInvocationAuthorizer;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IndexCreationData;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DefaultQueryService
implements InternalQueryService {
    private static final Logger logger = LogService.getLogger();
    public static final boolean QUERY_HETEROGENEOUS_OBJECTS = Boolean.valueOf(System.getProperty("gemfire.QueryService.QueryHeterogeneousObjects", "true"));
    public static boolean COPY_ON_READ_AT_ENTRY_LEVEL = Boolean.valueOf(System.getProperty("gemfire.QueryService.CopyOnReadAtEntryLevel", "false"));
    public static boolean ALLOW_UNTRUSTED_METHOD_INVOCATION = Boolean.getBoolean("gemfire.QueryService.allowUntrustedMethodInvocation");
    public static boolean TEST_QUERY_HETEROGENEOUS_OBJECTS = false;
    private final InternalCache cache;
    private final MethodInvocationAuthorizer methodInvocationAuthorizer;
    private InternalPool pool;
    private Map<Region, HashSet<IndexCreationData>> indexDefinitions = Collections.synchronizedMap(new HashMap());

    public DefaultQueryService(InternalCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CACHE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.cache = cache;
        this.methodInvocationAuthorizer = !cache.getSecurityService().isIntegratedSecurity() || ALLOW_UNTRUSTED_METHOD_INVOCATION ? (m, t) -> {} : new RestrictedMethodInvocationAuthorizer(cache.getSecurityService());
    }

    @Override
    public Query newQuery(String queryString) {
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(QueryMonitor.getMemoryUsedDuringLowMemory());
            throw new QueryExecutionLowMemoryException(reason);
        }
        if (queryString == null) {
            throw new QueryInvalidException(LocalizedStrings.DefaultQueryService_THE_QUERY_STRING_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (queryString.length() == 0) {
            throw new QueryInvalidException(LocalizedStrings.DefaultQueryService_THE_QUERY_STRING_MUST_NOT_BE_EMPTY.toLocalizedString());
        }
        ServerProxy serverProxy = this.pool == null ? null : new ServerProxy(this.pool);
        DefaultQuery query = new DefaultQuery(queryString, this.cache, serverProxy != null);
        query.setServerProxy(serverProxy);
        return query;
    }

    public Query newQuery(String queryString, ProxyCache proxyCache) {
        Query query = this.newQuery(queryString);
        ((DefaultQuery)query).setProxyCache(proxyCache);
        return query;
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createHashIndex(indexName, indexedExpression, fromClause, null);
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.HASH, indexedExpression, fromClause, imports);
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, null);
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, imports);
    }

    @Override
    public Index createKeyIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, fromClause, null);
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, null);
    }

    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports, boolean loadEntries) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, imports, loadEntries, null);
    }

    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports, boolean loadEntries, Region region) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
        }
        PartitionedIndex parIndex = null;
        if (region == null) {
            region = this.getRegionFromPath(imports, fromClause);
        }
        RegionAttributes ra = region.getAttributes();
        if (((LocalRegion)region).memoryThresholdReached.get() && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            LocalRegion lr = (LocalRegion)region;
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_INDEX.toLocalizedString(region.getName()), lr.getMemoryThresholdReachedMembers());
        }
        if (region instanceof PartitionedRegion) {
            try {
                parIndex = (PartitionedIndex)((PartitionedRegion)region).createIndex(false, indexType, indexName, indexedExpression, fromClause, imports, loadEntries);
            }
            catch (ForceReattemptException ex) {
                region.getCache().getLoggerI18n().info(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR, ex);
            }
            catch (IndexCreationException exx) {
                region.getCache().getLoggerI18n().info(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR, exx);
            }
            return parIndex;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, true);
        Index index = indexManager.createIndex(indexName, indexType, indexedExpression, fromClause, imports, null, null, loadEntries);
        return index;
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, imports, true);
    }

    private Region getRegionFromPath(String imports, String fromClause) throws RegionNotFoundException {
        QCompiler compiler = new QCompiler();
        if (imports != null) {
            compiler.compileImports(imports);
        }
        List list = compiler.compileFromClause(fromClause);
        CompiledValue cv = QueryUtils.obtainTheBottomMostCompiledValue(((CompiledIteratorDef)list.get(0)).getCollectionExpr());
        String regionPath = null;
        if (cv.getType() != 35) {
            throw new RegionNotFoundException(LocalizedStrings.DefaultQueryService_DEFAULTQUERYSERVICECREATEINDEXFIRST_ITERATOR_OF_INDEX_FROM_CLAUSE_DOES_NOT_EVALUATE_TO_A_REGION_PATH_THE_FROM_CLAUSE_USED_FOR_INDEX_CREATION_IS_0.toLocalizedString(fromClause));
        }
        regionPath = ((CompiledRegion)cv).getRegionPath();
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            throw new RegionNotFoundException(LocalizedStrings.DefaultQueryService_REGION_0_NOT_FOUND_FROM_1.toLocalizedString(regionPath, fromClause));
        }
        return region;
    }

    public IndexData getIndex(String regionPath, String[] definitions, IndexType indexType, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, true);
        IndexData indexData = indexManager.getIndex(indexType, definitions, indexedExpression, context);
        return indexData;
    }

    public Index getIndex(Region region, String indexName) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            return (Index)((PartitionedRegion)region).getIndex().get(indexName);
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndex(indexName);
    }

    public IndexData getBestMatchIndex(String regionPath, String[] definitions, IndexType indexType, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getBestMatchIndex(indexType, definitions, indexedExpression, context);
    }

    public Collection getIndexes() {
        ArrayList allIndexes = new ArrayList();
        for (Region<?, ?> region : this.cache.rootRegions()) {
            Collection indexes = this.getIndexes((Region)region);
            if (indexes != null) {
                allIndexes.addAll(indexes);
            }
            Iterator<Region<?, ?>> subRegions = region.subregions(true).iterator();
            while (subRegions.hasNext()) {
                indexes = this.getIndexes((Region)subRegions.next());
                if (indexes == null) continue;
                allIndexes.addAll(indexes);
            }
        }
        return allIndexes;
    }

    public Collection getIndexes(Region region) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            return ((PartitionedRegion)region).getIndexes();
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndexes();
    }

    public Collection getIndexes(Region region, IndexType indexType) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndexes(indexType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        Region<?, ?> region = index.getRegion();
        if (region instanceof PartitionedRegion) {
            try {
                ((PartitionedRegion)region).removeIndex(index, false);
            }
            catch (ForceReattemptException ex) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_REMOVING_INDEX___0), (Throwable)ex);
            }
            return;
        }
        ((AbstractIndex)index).acquireIndexWriteLockForRemove();
        try {
            IndexManager indexManager = ((LocalRegion)index.getRegion()).getIndexManager();
            indexManager.removeIndex(index);
        }
        finally {
            ((AbstractIndex)index).releaseIndexWriteLockForRemove();
        }
    }

    @Override
    public void removeIndexes() {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        for (Region<?, ?> region : this.cache.rootRegions()) {
            Iterator<Region<?, ?>> subRegions = region.subregions(true).iterator();
            while (subRegions.hasNext()) {
                this.removeIndexes((Region)subRegions.next());
            }
            this.removeIndexes((Region)region);
        }
    }

    public void removeIndexes(Region region) {
        IndexManager indexManager;
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            try {
                ((PartitionedRegion)region).removeIndexes(false);
            }
            catch (ForceReattemptException ex) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_REMOVING_INDEX___0), (Throwable)ex);
            }
        }
        if ((indexManager = IndexUtils.getIndexManager(region, false)) == null) {
            return;
        }
        indexManager.removeIndexes();
    }

    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqException {
        ClientCQ cq;
        block2: {
            cq = null;
            try {
                cq = this.getCqService().newCq(null, queryString, cqAttributes, this.pool, false);
            }
            catch (CqExistsException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to createCq. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqException {
        ClientCQ cq;
        block2: {
            cq = null;
            try {
                cq = this.getCqService().newCq(null, queryString, cqAttributes, this.pool, isDurable);
            }
            catch (CqExistsException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to createCq. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqExistsException, CqException {
        if (cqName == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
        }
        ClientCQ cq = this.getCqService().newCq(cqName, queryString, cqAttributes, this.pool, false);
        return cq;
    }

    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        if (cqName == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
        }
        ClientCQ cq = this.getCqService().newCq(cqName, queryString, cqAttributes, this.pool, isDurable);
        return cq;
    }

    @Override
    public void closeCqs() {
        block2: {
            try {
                this.getCqService().closeAllCqs(true);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to closeAll Cqs. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public CqQuery getCq(String cqName) {
        InternalCqQuery cq;
        block2: {
            cq = null;
            try {
                cq = this.getCqService().getCq(cqName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to getCq. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery[] getCqs() {
        CqQuery[] cqs = null;
        try {
            return this.toArray(this.getCqService().getAllCqs());
        }
        catch (CqException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to getAllCqs. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
            return cqs;
        }
    }

    private CqQuery[] toArray(Collection<? extends InternalCqQuery> allCqs) {
        CqQuery[] cqs = new CqQuery[allCqs.size()];
        allCqs.toArray(cqs);
        return cqs;
    }

    @Override
    public CqQuery[] getCqs(String regionName) throws CqException {
        return this.toArray(this.getCqService().getAllCqs(regionName));
    }

    @Override
    public void executeCqs() throws CqException {
        block2: {
            try {
                this.getCqService().executeAllClientCqs();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute all cqs. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public void stopCqs() throws CqException {
        block2: {
            try {
                this.getCqService().stopAllClientCqs();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop all CQs. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public void executeCqs(String regionName) throws CqException {
        block2: {
            try {
                this.getCqService().executeAllRegionCqs(regionName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs on the specified region. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public void stopCqs(String regionName) throws CqException {
        block2: {
            try {
                this.getCqService().stopAllRegionCqs(regionName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop cqs on the specified region. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public CqServiceStatistics getCqStatistics() {
        CqServiceStatistics stats;
        block2: {
            stats = null;
            try {
                stats = this.getCqService().getCqStatistics();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable get CQ Statistics. Error :{}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return stats;
    }

    public boolean isServer() {
        return !this.cache.getCacheServers().isEmpty();
    }

    public void closeCqService() {
        this.cache.getCqService().close();
    }

    public CqService getCqService() throws CqException {
        CqService service = this.cache.getCqService();
        service.start();
        return service;
    }

    public void setPool(InternalPool pool) {
        this.pool = pool;
        if (logger.isDebugEnabled()) {
            logger.debug("Setting ServerProxy with the Query Service using the pool :{} ", (Object)pool.getName());
        }
    }

    @Override
    public List<String> getAllDurableCqsFromServer() throws CqException {
        if (!this.isServer()) {
            if (this.pool != null) {
                return this.getCqService().getAllDurableCqsFromServer(this.pool);
            }
            throw new UnsupportedOperationException("GetAllDurableCQsFromServer requires a pool to be configured.");
        }
        return Collections.EMPTY_LIST;
    }

    public UserAttributes getUserAttributes(String cqName) {
        try {
            return this.getCqService().getUserAttributes(cqName);
        }
        catch (CqException ce) {
            return null;
        }
    }

    @Override
    public void defineKeyIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, fromClause, null);
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.HASH, indexedExpression, fromClause, null);
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.HASH, indexedExpression, fromClause, imports);
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, null);
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, imports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        IndexCreationData indexData = new IndexCreationData(indexName);
        indexData.setIndexData(indexType, fromClause, indexedExpression, imports);
        Region r = this.getRegionFromPath(imports, fromClause);
        Map<Region, HashSet<IndexCreationData>> map = this.indexDefinitions;
        synchronized (map) {
            HashSet<IndexCreationData> s = this.indexDefinitions.get(r);
            if (s == null) {
                s = new HashSet();
            }
            s.add(indexData);
            this.indexDefinitions.put(r, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
        HashSet<Index> indexes = new HashSet<Index>();
        boolean throwException = false;
        HashMap<String, Exception> exceptionsMap = new HashMap<String, Exception>();
        Map<Region, HashSet<IndexCreationData>> map = this.indexDefinitions;
        synchronized (map) {
            for (Map.Entry<Region, HashSet<IndexCreationData>> e : this.indexDefinitions.entrySet()) {
                Region region = e.getKey();
                HashSet<IndexCreationData> icds = e.getValue();
                if (region instanceof PartitionedRegion) {
                    throwException = this.createDefinedIndexesForPR(indexes, (PartitionedRegion)region, icds, exceptionsMap);
                    continue;
                }
                throwException = this.createDefinedIndexesForReplicatedRegion(indexes, region, icds, exceptionsMap);
            }
        }
        if (throwException) {
            throw new MultiIndexCreationException(exceptionsMap);
        }
        return new ArrayList<Index>(indexes);
    }

    private boolean createDefinedIndexesForPR(HashSet<Index> indexes, PartitionedRegion region, HashSet<IndexCreationData> icds, HashMap<String, Exception> exceptionsMap) {
        try {
            indexes.addAll(region.createIndexes(false, icds));
        }
        catch (IndexCreationException e1) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
        }
        catch (CacheException e1) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
            return true;
        }
        catch (ForceReattemptException e1) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
            return true;
        }
        catch (MultiIndexCreationException e) {
            exceptionsMap.putAll(e.getExceptionsMap());
            return true;
        }
        return false;
    }

    private boolean createDefinedIndexesForReplicatedRegion(HashSet<Index> indexes, Region region, Set<IndexCreationData> icds, HashMap<String, Exception> exceptionsMap) {
        IndexManager indexManager;
        boolean throwException = false;
        for (IndexCreationData indexCreationData : icds) {
            try {
                indexes.add(this.createIndex(indexCreationData.getIndexName(), indexCreationData.getIndexType(), indexCreationData.getIndexExpression(), indexCreationData.getIndexFromClause(), indexCreationData.getIndexImportString(), false, region));
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Index creation failed, {}, {}", (Object)indexCreationData.getIndexName(), (Object)ex.getMessage(), (Object)ex);
                }
                exceptionsMap.put(indexCreationData.getIndexName(), ex);
                throwException = true;
            }
        }
        if (IndexManager.testHook != null) {
            IndexManager.testHook.hook(13);
        }
        if ((indexManager = IndexUtils.getIndexManager(region, false)) == null) {
            for (IndexCreationData icd : icds) {
                exceptionsMap.put(icd.getIndexName(), new IndexCreationException("Index Creation Failed due to region destroy"));
            }
            return true;
        }
        if (indexes.size() > 0) {
            try {
                indexManager.populateIndexes(indexes);
            }
            catch (MultiIndexCreationException multiIndexCreationException) {
                exceptionsMap.putAll(multiIndexCreationException.getExceptionsMap());
                throwException = true;
            }
        }
        return throwException;
    }

    @Override
    public boolean clearDefinedIndexes() {
        this.indexDefinitions.clear();
        return true;
    }

    public InternalPool getPool() {
        return this.pool;
    }

    @Override
    public MethodInvocationAuthorizer getMethodInvocationAuthorizer() {
        return this.methodInvocationAuthorizer;
    }
}

