/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.PathUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.internal.cache.PartitionedRegion;

public class CompiledPath
extends AbstractCompiledValue {
    private CompiledValue _receiver;
    private String _tailID;

    public CompiledPath(CompiledValue rcvr, String id) {
        this._receiver = rcvr;
        this._tailID = id;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this._receiver);
    }

    @Override
    public int getType() {
        return -5;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return context.addDependencies(this, this._receiver.computeDependencies(context));
    }

    @Override
    public List getPathOnIterator(RuntimeIterator itr, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        if (!this.isDependentOnIterator(itr, context)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getTailID());
        CompiledValue v = this.getReceiver();
        int type = v.getType();
        while (type == -5) {
            CompiledPath p = (CompiledPath)v;
            list.add(0, p.getTailID());
            v = p.getReceiver();
            type = v.getType();
        }
        if (type == 34) {
            List path = v.getPathOnIterator(itr, context);
            if (path == null) {
                return null;
            }
            list.addAll(0, path);
            return list;
        }
        return null;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledValue rcvr = this.getReceiver();
        Object evalRcvr = rcvr.evaluate(context);
        if (context.isCqQueryContext() && (evalRcvr instanceof Region.Entry || evalRcvr instanceof CqEntry)) {
            try {
                Object re;
                if (evalRcvr instanceof Region.Entry) {
                    re = (Region.Entry)evalRcvr;
                    if (re.isDestroyed()) {
                        return QueryService.UNDEFINED;
                    }
                    evalRcvr = re.getValue();
                } else if (evalRcvr instanceof CqEntry) {
                    re = (CqEntry)evalRcvr;
                    evalRcvr = ((CqEntry)re).getValue();
                }
            }
            catch (EntryDestroyedException ede) {
                return QueryService.UNDEFINED;
            }
        }
        Object obj = PathUtils.evaluateAttribute(context, evalRcvr, this.getTailID());
        PartitionedRegion pr = context.getPartitionedRegion();
        if (pr != null && obj instanceof Region && pr.getFullPath().equals(((Region)obj).getFullPath())) {
            obj = context.getBucketRegion();
        }
        return obj;
    }

    public String getTailID() {
        return this._tailID;
    }

    @Override
    public CompiledValue getReceiver() {
        return this._receiver;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        int len;
        if (this._tailID.startsWith("get") && (len = this._tailID.length()) > 3) {
            clauseBuffer.insert(0, len > 4 ? this._tailID.substring(4) : "");
            clauseBuffer.insert(0, Character.toLowerCase(this._tailID.charAt(3)));
        } else {
            clauseBuffer.insert(0, this._tailID);
        }
        clauseBuffer.insert(0, '.');
        this._receiver.generateCanonicalizedExpression(clauseBuffer, context);
    }
}

