/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Functions;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CompiledFunction
extends AbstractCompiledValue {
    private CompiledValue[] _args;
    private int _function;

    public CompiledFunction(CompiledValue[] args, int function) {
        this._args = args;
        this._function = function;
    }

    @Override
    public List getChildren() {
        return Arrays.asList(this._args);
    }

    @Override
    public int getType() {
        return -2;
    }

    public int getFunction() {
        return this._function;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this._function == 104) {
            Object arg = this._args[0].evaluate(context);
            return this.call(arg, context);
        }
        if (this._function == 106) {
            return Functions.nvl(this._args[0], this._args[1], context);
        }
        if (this._function == 107) {
            return Functions.to_date(this._args[0], this._args[1], context);
        }
        throw new QueryInvalidException(LocalizedStrings.CompiledFunction_UNSUPPORTED_FUNCTION_WAS_USED_IN_THE_QUERY.toLocalizedString());
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        int len = this._args.length;
        for (int i = 0; i < len; ++i) {
            context.addDependencies(this, this._args[i].computeDependencies(context));
        }
        return context.getDependencySet(this, true);
    }

    private Object call(Object arg, ExecutionContext context) throws FunctionDomainException, TypeMismatchException {
        Support.Assert(this._function == 104);
        return Functions.element(arg, context);
    }

    public CompiledValue[] getArguments() {
        return this._args;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        int len = this._args.length;
        for (int i = len - 1; i > 0; --i) {
            this._args[i].generateCanonicalizedExpression(clauseBuffer, context);
            clauseBuffer.insert(0, ',');
        }
        this._args[0].generateCanonicalizedExpression(clauseBuffer, context);
        switch (this._function) {
            case 106: {
                clauseBuffer.insert(0, "NVL(");
                break;
            }
            case 104: {
                clauseBuffer.insert(0, "ELEMENT(");
                break;
            }
            case 107: {
                clauseBuffer.insert(0, "TO_DATE(");
                break;
            }
            default: {
                super.generateCanonicalizedExpression(clauseBuffer, context);
            }
        }
    }
}

